# Privacy Policy for FlxWoo

**Last Updated:** November 20, 2025
**Plugin Version:** 2.1.0

## Introduction

This privacy policy describes how the **FlxWoo WordPress plugin** collects, processes, and transmits data when installed on your WooCommerce website. FlxWoo is designed with privacy and security as core principles.

**Important:** This document describes how the **plugin itself** handles data. As a site owner, you remain responsible for your own privacy policy that covers your overall data practices, including the use of this plugin.

## Overview

FlxWoo is a dual-component system:
1. **WordPress Plugin** (open source, MIT license) - Installed on your site
2. **Next.js Renderer** (FlxWoo SaaS, closed source) - Hosted rendering service

The plugin transmits WooCommerce data to the Next.js rendering service to generate optimized cart, checkout, and order confirmation pages.

---

## Configuration (v2.1.0+)

Starting with version 2.1.0, site administrators can configure FlxWoo settings via:

### Admin Settings Page
- **Location:** WordPress Admin > WooCommerce > FlxWoo > Settings
- **Configurable Options:**
  - Renderer URL (where customer data is transmitted)
  - Request timeout (maximum duration for data transmission)
  - Cache settings (optimize performance)
  - Development mode (allows HTTP for localhost testing)

### Configuration Priority
Settings are applied in this order:
1. **Database Settings** (configured via Admin Settings Page)
2. **wp-config.php Constants** (override for advanced users)
3. **Default Values** (built-in fallbacks)

### Privacy Impact
This configuration control means:
- ✅ Site administrators choose where customer data is sent
- ✅ Timeout controls how long data transmission can take
- ✅ Development mode can be disabled to enforce HTTPS encryption

**Transparency:** Check with your site administrator for the specific renderer URL and configuration being used on your site.

---

## What Data Is Collected

### 1. Cart Data
When a customer visits `/cart` on your site, the plugin collects:

**Cart Items:**
- Product ID, name, SKU, quantity
- Product prices, subtotals, taxes
- Product images (URLs only)
- Product variations and attributes (e.g., "Size: Large")
- Stock status and availability

**Cart Totals:**
- Subtotal, tax amount, total
- Shipping costs
- Applied coupons and discount amounts
- Cart fees (gift wrapping, handling fees, etc.)

**No payment information is collected at the cart stage.**

### 2. Checkout Data
When a customer visits `/checkout` on your site, the plugin collects:

**Form Configuration:**
- Available billing and shipping fields (names, requirements)
- Field labels, placeholders, validation rules
- Country and state options

**Payment Gateways:**
- Gateway ID (e.g., "stripe", "paypal")
- Gateway title (e.g., "Credit Card")
- Gateway icon URL (if provided)
- **Note:** Payment credentials, API keys, and secrets are NEVER transmitted

**Shipping Methods:**
- Method ID (e.g., "flat_rate")
- Method title and cost
- Availability status

**Customer Information (if logged in):**
- Billing and shipping addresses (for pre-filling forms)
- Email address
- Phone number
- Customer display name

**No credit card numbers, CVV codes, or payment credentials are ever collected or transmitted.**

### 3. Order Confirmation Data
When a customer completes an order and visits `/thank-you` page:

**Order Details:**
- Order ID, order number, order key
- Order status (e.g., "processing", "completed")
- Order totals, taxes, shipping
- Ordered items with quantities and prices
- Billing and shipping addresses
- Customer email

**No payment transaction details or credit card information is transmitted.**

### 4. Site Metadata
To properly render pages, the plugin sends:

- Site name (e.g., "My Store")
- Home URL
- Locale (e.g., "en_US")
- Currency code and symbol (e.g., "USD", "$")
- Number formatting preferences (decimal separator, thousands separator)
- Date/time format preferences

### 5. Technical Data
The plugin logs the following for debugging (only when `WP_DEBUG` is enabled):

- API request/response status codes
- Error messages (with PII automatically sanitized)
- Rendering duration and performance metrics

**PII Sanitization:** All logs automatically remove email addresses, phone numbers, IP addresses, and other personally identifiable information before writing to debug logs.

### 6. Error Monitoring (Optional)

**Next.js Renderer (Optional):**
If enabled by the site administrator, the Next.js renderer may send error reports to Sentry.io for debugging and monitoring purposes. These reports include:
- Error messages and stack traces
- Request timing and performance metrics
- Sanitized context data (all PII automatically removed before transmission)

**PII Protection in Error Reports:**
Before sending any error data to external monitoring services:
- ✅ Email addresses are masked (e.g., `j***@example.com` - keeps domain for debugging)
- ✅ Phone numbers are masked except last 4 digits (e.g., `***-***-4567`)
- ✅ Full addresses are redacted (keeps city/state/country only)
- ✅ Names are masked except first letter (e.g., `J*** S***`)
- ✅ Passwords, tokens, payment data, and credentials are completely redacted as `[REDACTED]`
- ✅ Credit card numbers, CVV, and payment method tokens are never included

**WordPress Plugin:**
The WordPress plugin does NOT send data to external error monitoring services. All logs remain local to your WordPress installation (`wp-content/debug.log`) and are controlled by your WordPress debug settings.

**Transparency:** Error monitoring in the Next.js renderer is controlled by the FlxWoo SaaS provider and helps maintain service reliability. No customer PII reaches external services due to automatic sanitization.

---

## How Data Is Used

### Purpose
Data is collected and transmitted **solely for the purpose of rendering optimized cart, checkout, and order confirmation pages**. No other processing occurs.

### Processing Location
- **Plugin Processing:** On your WordPress server (your hosting environment)
- **Rendering Service:** FlxWoo SaaS (hosted Next.js renderer)

### Data Flow
1. Customer visits cart/checkout/thank-you page
2. Plugin aggregates data from WooCommerce
3. Plugin sends HTTP POST request to FlxWoo SaaS renderer
4. Renderer generates HTML and returns it to plugin
5. Plugin displays HTML to customer
6. **No data is permanently stored by the renderer**

---

## Data Transmission

### External Service
The plugin transmits data to the **FlxWoo SaaS rendering service**, a third-party service operated by FlxWoo.

**Renderer URL:** Configurable via (in priority order):
1. WordPress Admin settings page (WP Admin > WooCommerce > FlxWoo > Settings)
2. `FLX_WOO_RENDERER_URL` constant in wp-config.php
3. Default value (configured by site administrator)

**Note:** Site administrators control where customer data is transmitted. The specific renderer URL depends on your site's configuration. Contact your site administrator or check the FlxWoo settings page for details.

### Security Measures
- **HTTPS Only:** All data transmission uses encrypted HTTPS connections
- **No Storage:** The renderer does not permanently store transmitted data
- **Automatic Fallback:** If the renderer is unavailable, native WooCommerce templates are used
- **CORS Protection:** Cross-origin requests are restricted to authorized origins
- **CSP Headers:** Content Security Policy headers prevent XSS attacks

### Data Retention
- **In Transit:** Data is transmitted during page load only
- **Temporary Processing:** Data exists in renderer memory for milliseconds during HTML generation
- **No Permanent Storage:** Data is not saved to databases or log files by the renderer
- **WordPress Logs:** Debug logs (when enabled) are stored according to your WordPress log retention policy

---

## Third-Party Services

### FlxWoo SaaS Renderer
- **Service:** Next.js rendering engine
- **Provider:** FlxWoo (operated by Rickey Gu)
- **Purpose:** HTML generation for cart/checkout/thank-you pages
- **Data Shared:** Cart data, checkout configuration, order details, site metadata (as described above)
- **Data Retention:** No permanent storage; data processed in memory only
- **Privacy Policy:** This document serves as the privacy policy for the rendering service

### Other Services
The plugin itself does not integrate with any other third-party services. However, WooCommerce may transmit data to:
- Payment gateways (Stripe, PayPal, etc.)
- Shipping providers
- Tax calculation services

These services are outside the scope of FlxWoo and are governed by WooCommerce's data handling and the respective service providers' privacy policies.

---

## User Rights (GDPR/CCPA Compliance)

As a site owner using FlxWoo, you should inform your customers that:

### Right to Access
Customers can request access to their data. Since FlxWoo does not permanently store data, no FlxWoo-specific data exists beyond what's in your WooCommerce database.

### Right to Deletion
Customers can request deletion of their data. Use WooCommerce's built-in data erasure tools. FlxWoo does not maintain separate customer records.

### Right to Object
Customers can object to data processing. Since FlxWoo processing is essential for cart/checkout functionality, objecting effectively means not using the checkout system.

### Right to Data Portability
Use WooCommerce's data export features. FlxWoo does not store additional data that needs exporting.

### Data Breach Notification
In the unlikely event of a data breach involving the FlxWoo renderer:
- You will be notified within 72 hours
- Affected data types will be disclosed
- Remediation steps will be provided

---

## Cookies and Tracking

### Cookies Set by FlxWoo
**None.** The FlxWoo plugin does not set any cookies.

### Cookies Used by WooCommerce
FlxWoo relies on WooCommerce's standard cookie functionality:
- `woocommerce_cart_hash` - Cart contents identifier
- `woocommerce_items_in_cart` - Cart item count
- `wp_woocommerce_session_*` - Session identifier

These cookies are set by WooCommerce, not FlxWoo.

### Analytics and Tracking
FlxWoo does not include analytics or tracking. Any analytics on your cart/checkout pages come from tools you've installed separately (Google Analytics, Facebook Pixel, etc.).

---

## Children's Privacy

FlxWoo does not knowingly collect or process data from children under the age of 13 (or applicable age in your jurisdiction). If your store sells to children, ensure your own privacy policy addresses this.

---

## International Data Transfers

### Data Location
- **Your WordPress Site:** Data originates from your hosting provider's location
- **FlxWoo SaaS Renderer:** Hosting location is configured by your site administrator
  - Check WP Admin > WooCommerce > FlxWoo > Settings for the configured renderer URL
  - Contact your site administrator for specific hosting location details
  - The renderer URL determines where customer data is transmitted

### Compliance
If you operate in the EU and serve EU customers:
- Data is transmitted via HTTPS encryption
- No permanent storage occurs (minimizes transfer risk)
- Processing is necessary for service delivery (GDPR Article 6(1)(b) - contract performance)

If you have concerns about data transfers, contact FlxWoo support for information about data processing agreements.

---

## Data Security

### Technical Measures
- **Encryption in Transit:** TLS/HTTPS for all API requests
- **Input Validation:** Zod schema validation prevents malformed data
- **XSS Protection:** HTML escaping and Content Security Policy headers
- **PII Sanitization:** Automatic removal of sensitive data from debug logs
- **Error Handling:** Graceful fallback prevents data exposure during errors

### Security Features Added in v2.1.0

**Enhanced Protection:**
- ✅ **Rate Limiting** - Protects against excessive requests that could expose data through timing attacks or abuse
- ✅ **Admin Settings Validation** - All configuration values are validated and sanitized before saving to prevent malicious input
- ✅ **Health Monitoring Dashboard** - Tracks renderer availability and data transmission status (WP Admin > WooCommerce > FlxWoo > Health)
- ✅ **Enhanced PII Sanitization** - Improved algorithms for removing sensitive data from error logs
- ✅ **Sentry Error Monitoring with PII Protection** - Server-side errors monitored with automatic PII sanitization (Next.js renderer only)

**Configuration Security:**
- ✅ **HTTPS Enforcement Option** - Development mode can be disabled to require HTTPS for all data transmission
- ✅ **Timeout Controls** - Administrators can limit maximum request duration (1-60 seconds)
- ✅ **Configurable Renderer URL** - Site administrators control where customer data is sent

**Monitoring & Transparency:**
- ✅ **Real-time Health Checks** - Verify renderer connectivity and data transmission status
- ✅ **Performance Tracking** - Monitor data transmission duration and identify issues
- ✅ **Error Logging** - All errors logged locally with automatic PII sanitization

### Organizational Measures
- Regular security audits of plugin code
- Dependency updates for security patches
- Incident response procedures

### Your Responsibilities
As a site owner:
- Keep WordPress, WooCommerce, and FlxWoo updated
- Use HTTPS on your website
- Implement appropriate server security
- Review and update your own privacy policy

---

## Changes to This Privacy Policy

This privacy policy may be updated to reflect:
- Changes in plugin functionality
- Updates to data protection laws
- Improvements in security practices

**Notification:** Major changes will be announced via plugin update notices. Check this document periodically for updates.

---

## Your Privacy Policy

### Suggested Disclosure
If you use FlxWoo on your WooCommerce site, consider adding this to your site's privacy policy:

> **Cart and Checkout Rendering**
>
> Our website uses FlxWoo, a plugin that enhances cart and checkout pages. When you view your cart or proceed to checkout, your cart data, product selections, and (if logged in) your saved addresses are temporarily transmitted to FlxWoo's rendering service to generate an optimized page layout. This data is processed in real-time and is not permanently stored by the rendering service. The transmission is encrypted via HTTPS.
>
> For more information, see the [FlxWoo Privacy Policy](https://flxwoo.com/privacy).

### Customize for Your Jurisdiction
Depending on where you operate:
- **EU (GDPR):** Ensure you have a lawful basis (typically "contract performance")
- **US (CCPA):** Disclose if data is "sold" (it is not in FlxWoo's case)
- **UK (UK GDPR):** Similar to EU GDPR requirements
- **Other jurisdictions:** Consult local privacy laws

---

## Contact Information

### Plugin Developer
**Name:** Rickey Gu
**Email:** rickey29@gmail.com
**Website:** [flxwoo.com](https://flxwoo.com)

### Data Protection Inquiries
For questions about how FlxWoo processes data, contact: rickey29@gmail.com

### Support
For technical support or plugin issues:
- WordPress Forums: [wordpress.org/support/plugin/flx-woo](https://wordpress.org/support/plugin/flx-woo)
- Email: rickey29@gmail.com

---

## Legal Basis for Processing (GDPR)

Under GDPR Article 6, FlxWoo processes data based on:

1. **Contract Performance (Article 6(1)(b))**: Processing is necessary to fulfill the checkout process you've requested
2. **Legitimate Interests (Article 6(1)(f))**: Providing an optimized checkout experience is a legitimate interest, balanced against your privacy rights

---

## Summary

**What we collect:** Cart items, checkout configuration, order details, site metadata
**Why we collect it:** To render optimized cart/checkout pages
**Where it goes:** FlxWoo SaaS rendering service (HTTPS encrypted)
**How long we keep it:** Not permanently stored (processed in memory only)
**Your rights:** Access, deletion, objection (via WooCommerce tools)
**Cookies:** None set by FlxWoo
**Third parties:** FlxWoo SaaS renderer only (no other integrations)

---

**By using the FlxWoo plugin, you acknowledge that cart, checkout, and order data will be transmitted to FlxWoo's rendering service as described in this privacy policy.**

---

*This privacy policy is provided for transparency and compliance purposes. It does not constitute legal advice. Consult with a privacy attorney to ensure your site's overall privacy practices comply with applicable laws.*
