# Changelog

All notable changes to FlxWoo will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [2.4.0] - 2025-12-28

### Added

**Moat-Building Features - Performance Benchmarking & A/B Testing**

- **Benchmarking Dashboard (v2.4.0)**
  - Compare store performance to industry benchmarks
  - Visual performance metrics comparison (conversion rate, AOV, cart abandonment)
  - Interactive charts showing your store vs. industry averages
  - Configurable time periods (7, 30, 90 days)
  - Actionable insights and recommendations
  - Real-time data fetching from Next.js analytics API
  - AJAX-powered dashboard with period selection
  - Color-coded performance indicators (above/below average)
  - Files Added: `src/Admin/BenchmarkingPage.php`, `src/Admin/views/benchmarking-page.php`

- **A/B Testing Foundations (v2.4.0)**
  - Create and manage checkout A/B tests
  - Test different variations of checkout flows
  - Real-time test results with statistical significance
  - Test status management (draft, active, completed, archived)
  - Visual test results dashboard with conversion metrics
  - Winner selection based on statistical confidence
  - AJAX-powered test creation and management
  - Integration with analytics tracking infrastructure
  - Files Added: `src/Admin/ABTestingPage.php`, `src/Admin/views/ab-testing-page.php`

- **Plugin Compatibility Database (v2.4.0)**
  - Track WooCommerce plugin compatibility with FlxWoo
  - Report compatibility issues directly from admin
  - View tested plugins and their compatibility status
  - Crowdsourced compatibility data from FlxWoo community
  - Filter by plugin category and compatibility status
  - Submit compatibility reports with plugin details
  - Visual compatibility indicators (compatible, issues, untested)
  - Files Added: `src/Admin/CompatibilityPage.php`, `src/Admin/views/compatibility-page.php`

- **Admin Interface Enhancements**
  - Three new admin pages under WooCommerce > FlxWoo menu
  - Professional WordPress admin integration
  - Consistent design language across all admin pages
  - Loading states and error handling for all AJAX operations
  - WordPress nonce verification for security
  - Chart.js integration for data visualization
  - Shared CSS framework across admin dashboards

### Changed

- **Files Modified:**
  - `src/Admin/AdminHooks.php` - Added new menu items and asset loading for v2.4.0 features
  - `src/Bootstrap.php` - Registered new admin page classes

### Technical

- PHPUnit tests for new functionality
- WordPress coding standards compliant
- Feature flag integration for all new features
- Non-blocking API calls with timeout protection
- Comprehensive error handling and fallbacks

### Rationale

- Building competitive moats through network effects (benchmarking data)
- Enabling conversion optimization through A/B testing
- Improving user experience with compatibility transparency
- Foundation for future data-driven features

## [2.3.0] - 2025-12-23

### Added

- **Analytics Event Tracking (v2.3.0)**
  - `EventTracker.php` - Core analytics tracking functionality
  - `AnalyticsHooks.php` - WooCommerce integration hooks
  - Automatic tracking of checkout_started, checkout_completed, checkout_abandoned events
  - Privacy-by-design: SHA-256 store IDs (irreversible), no PII collected
  - Non-blocking async requests to Next.js analytics API (2-second timeout)
  - Feature flag integration for enabling/disabling analytics
  - Files Added: `src/Analytics/EventTracker.php`, `src/Hooks/AnalyticsHooks.php`
  - GDPR/CCPA compliant - No customer names, emails, addresses, IPs, or payment details tracked

- **Enhanced Feature Flags Management Page**
  - Feature Overview Dashboard with at-a-glance statistics
  - Interactive dependency tree visualization showing feature relationships
  - Health status monitoring with color-coded indicators (Healthy/Warning/Ready)
  - Card-based feature configuration UI with improved visual hierarchy
  - Real-time rollout slider updates with gradient visualization
  - Kill switch confirmation dialog to prevent accidental activation
  - Enhanced store information display with dashicons
  - Organized documentation section with grid layout
  - New PHP methods in `FeatureFlagsPage` class:
    - `get_feature_overview()` - Dashboard statistics
    - `get_feature_status_list()` - Feature status items with dependencies
    - `get_dependency_tree()` - Hierarchical dependency structure
    - `get_feature_health()` - Health monitoring with issue detection
  - New asset files:
    - `feature-flags.css` (9.6KB) - Responsive styles
    - `feature-flags.js` (4.1KB) - Interactive enhancements

- **Activity Analytics Page (v2.4.0 Preview)**
  - Admin page for visualizing feature flag activity
  - Interactive charts for timeline, feature breakdown, user activity
  - CSV export functionality
  - Real-time filtering and data refresh
  - Files Added: `src/Admin/ActivityAnalyticsPage.php`, `src/Admin/views/activity-analytics-page.php`

### Changed

- **Admin Settings Page URL Update**
  - Changed from `?page=flx-woo` to `?page=flx-woo-settings`
  - Updated all menu registration slugs in `AdminHooks.php`
  - Updated asset loading hook checks
  - Updated Feature Flags submenu parent slug
  - Impact: Users with bookmarked URLs will need to use new URL from menu

- **Performance Dashboard Analytics Integration**
  - Added `get_events_today()` method to query Next.js analytics API
  - Displays real-time event counts tracked today
  - Non-blocking API calls with graceful fallback
  - Files Modified: `src/Admin/PerformanceDashboard.php`

- **Feature Flags Page UX Improvements**
  - Reorganized template into 6 distinct sections
  - Improved asset enqueuing with `$_GET['page']` fallback
  - Enhanced feature card layout with hover effects and status badges

### Technical

- 15+ files modified/added
- Fully responsive design with mobile-optimized layouts
- WordPress coding standards compliant
- Backward compatible with existing functionality
- 18 PHPUnit tests passing

### Rationale

- Laid foundation for moat-building features (benchmarking, A/B testing)
- Privacy-first analytics enables competitive advantage through data network effects
- Enhanced admin UI improves developer experience and feature discoverability

## [2.2.1] - Previous Release

### Changed
- Bug fixes and improvements

---

**Note:** Version numbers follow [Semantic Versioning](https://semver.org/):
- MAJOR version for incompatible API changes
- MINOR version for new functionality in a backward compatible manner
- PATCH version for backward compatible bug fixes
