<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>

<div class="wrap">
    <h1>Floating Channel Buttons – Settings</h1>
    <form method="post" action="options.php">
        <?php settings_fields('fscb-settings-group'); ?>
        <?php do_settings_sections('fscb-settings-group'); ?>
        <table class="form-table">
            <tr>
                <th scope="row">WhatsApp Channel Link</th>
                <td><input type="text" name="fscb_whatsapp_link" value="<?php echo esc_attr(get_option('fscb_whatsapp_link')); ?>" size="60" /></td>
            </tr>
            <tr>
                <th scope="row">Telegram Username (without @)</th>
                <td><input type="text" name="fscb_telegram_user" value="<?php echo esc_attr(get_option('fscb_telegram_user')); ?>" size="60" /></td>
            </tr>
            <tr>
                <th scope="row">Sticky Bar Text</th>
                <td><input type="text" name="fscb_bar_text" value="<?php echo esc_attr(get_option('fscb_bar_text')); ?>" size="60" /></td>
            </tr>
            <tr>
                <th scope="row">WhatsApp Button Text</th>
                <td><input type="text" name="fscb_whatsapp_text" value="<?php echo esc_attr(get_option('fscb_whatsapp_text')); ?>" size="60" /></td>
            </tr>
            <tr>
                <th scope="row">Telegram Button Text</th>
                <td><input type="text" name="fscb_telegram_text" value="<?php echo esc_attr(get_option('fscb_telegram_text')); ?>" size="60" /></td>
            </tr>
            <tr>
                <th scope="row">Show Sticky Bar</th>
                <td>
                    <select name="fscb_show_bar">
                        <option value="yes" <?php selected(get_option('fscb_show_bar'), 'yes'); ?>>Yes</option>
                        <option value="no" <?php selected(get_option('fscb_show_bar'), 'no'); ?>>No</option>
                    </select>
                </td>
            </tr>
            <tr>
                <th scope="row">Show Floating Buttons</th>
                <td>
                    <select name="fscb_show_float">
                        <option value="yes" <?php selected(get_option('fscb_show_float'), 'yes'); ?>>Yes</option>
                        <option value="no" <?php selected(get_option('fscb_show_float'), 'no'); ?>>No</option>
                    </select>
                </td>
            </tr>
            <tr>
                <th scope="row">Device Visibility</th>
                <td>
                    <select name="fscb_device_visibility">
                        <option value="both" <?php selected(get_option('fscb_device_visibility'), 'both'); ?>>Both</option>
                        <option value="desktop" <?php selected(get_option('fscb_device_visibility'), 'desktop'); ?>>Desktop Only</option>
                        <option value="mobile" <?php selected(get_option('fscb_device_visibility'), 'mobile'); ?>>Mobile Only</option>
                    </select>
                </td>
            </tr>
            <tr>
                <th scope="row">Link Target</th>
                <td>
                    <select name="fscb_link_target">
                        <option value="_blank" <?php selected(get_option('fscb_link_target'), '_blank'); ?>>New Tab (_blank)</option>
                        <option value="_self" <?php selected(get_option('fscb_link_target'), '_self'); ?>>Same Tab (_self)</option>
                    </select>
                </td>
            </tr>
        </table>
        <?php submit_button(); ?>
    </form>
</div>
