<?php
/**
 * Plugin Name: Floating Social Channel Buttons
 * Plugin URI: https://wpexplained.in/floating-social-channel-buttons-wordpress-plugin/
 * Description: Add floating WhatsApp and Telegram buttons and a sticky bar to your WordPress site.
 * Version: 1.4.3
 * Requires at least: 5.5
 * Tested up to: 6.8
 * Author: WP Explained
 * Author URI: https://wpexplained.in/
 * License: GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function fscb_add_custom_floating_buttons() {
    $whatsapp = esc_url(get_option('fscb_whatsapp_link', 'https://whatsapp.com/channel/'));
    $telegram = sanitize_text_field(get_option('fscb_telegram_user', 'telegram'));

    $whatsapp_txt_raw = get_option('fscb_whatsapp_text');
    $telegram_txt_raw = get_option('fscb_telegram_text');
    $bar_text_raw     = get_option('fscb_bar_text');

    $whatsapp_txt = ($whatsapp_txt_raw !== '') ? $whatsapp_txt_raw : 'Join on WhatsApp';
    $telegram_txt = ($telegram_txt_raw !== '') ? $telegram_txt_raw : 'Join on Telegram';
    $bar_text     = ($bar_text_raw     !== '') ? $bar_text_raw     : 'Get Updates on';

    $show_bar   = get_option('fscb_show_bar', 'yes');
    $show_float = get_option('fscb_show_float', 'yes');
    $visibility = get_option('fscb_device_visibility', 'both');
    $target     = get_option('fscb_link_target', '_blank');

    $class = ($visibility === 'mobile') ? 'fscb-mobile-only' : (($visibility === 'desktop') ? 'fscb-desktop-only' : '');

    echo '<style>
        #fscb-buttons {position:fixed;bottom:20px;right:20px;z-index:9999;}
        .fscb-btn {display:block;margin:10px 0;padding:12px 20px;border-radius:50px;font-weight:bold;color:#fff;text-align:center;text-decoration:none;box-shadow:0 4px 8px rgba(0,0,0,0.2);}
        .fscb-btn:hover {transform:scale(1.05);}
        .fscb-btn.telegram {background:#0088cc;}
        .fscb-btn.whatsapp {background:#25D366;}
        #fscb-bar {position:fixed;top:0;left:0;width:100%;background:#ff3c00;color:#fff;text-align:center;padding:10px;font-weight:bold;z-index:10000;}
        #fscb-bar a {color:yellow;text-decoration:underline;margin:0 10px;}
        @media(max-width:768px){.fscb-desktop-only{display:none !important;}}
        @media(min-width:769px){.fscb-mobile-only{display:none !important;}}
    </style>';

    echo '<script>
    function getTelegramLink() {
        if (/Android|iPhone|iPad|iPod/i.test(navigator.userAgent)) {
            return "tg://resolve?domain=' . esc_js($telegram) . '";
        } else {
            return "https://t.me/' . esc_js($telegram) . '";
        }
    }
    document.addEventListener("DOMContentLoaded", function() {
        document.querySelectorAll(".fscb-telegram").forEach(link => {
            link.setAttribute("href", getTelegramLink());
        });
    });
    </script>';

    if ($show_bar === 'yes') {
        echo '<div id="fscb-bar" class="' . esc_attr($class) . '">' . esc_html($bar_text) .
            ' <a href="' . esc_url($whatsapp) . '" target="' . esc_attr($target) . '">' . esc_html($whatsapp_txt) . '</a> | ' .
            '<a href="#" class="fscb-telegram" target="' . esc_attr($target) . '">' . esc_html($telegram_txt) . '</a></div>';
    }

    if ($show_float === 'yes') {
        echo '<div id="fscb-buttons" class="' . esc_attr($class) . '">
            <a href="' . esc_url($whatsapp) . '" target="' . esc_attr($target) . '" class="fscb-btn whatsapp">' . esc_html($whatsapp_txt) . '</a>
            <a href="#" target="' . esc_attr($target) . '" class="fscb-btn telegram fscb-telegram">' . esc_html($telegram_txt) . '</a>
        </div>';
    }
}
add_action('wp_footer', 'fscb_add_custom_floating_buttons');

function fscb_menu() {
    add_options_page('Social Buttons Settings', 'Channel Buttons', 'manage_options', 'fscb-settings', 'fscb_settings_page');
}
add_action('admin_menu', 'fscb_menu');

function fscb_settings_page() {
    if ( ! defined( 'ABSPATH' ) ) exit;
    include plugin_dir_path(__FILE__) . 'settings-page.php';
}

function fscb_register_settings() {
    register_setting('fscb-settings-group', 'fscb_whatsapp_link', ['sanitize_callback' => 'esc_url_raw']);
    register_setting('fscb-settings-group', 'fscb_telegram_user', ['sanitize_callback' => 'sanitize_text_field']);
    register_setting('fscb-settings-group', 'fscb_bar_text', ['sanitize_callback' => 'sanitize_text_field']);
    register_setting('fscb-settings-group', 'fscb_show_bar', ['sanitize_callback' => 'sanitize_text_field']);
    register_setting('fscb-settings-group', 'fscb_show_float', ['sanitize_callback' => 'sanitize_text_field']);
    register_setting('fscb-settings-group', 'fscb_device_visibility', ['sanitize_callback' => 'sanitize_text_field']);
    register_setting('fscb-settings-group', 'fscb_link_target', ['sanitize_callback' => 'sanitize_text_field']);
    register_setting('fscb-settings-group', 'fscb_whatsapp_text', ['sanitize_callback' => 'sanitize_text_field']);
    register_setting('fscb-settings-group', 'fscb_telegram_text', ['sanitize_callback' => 'sanitize_text_field']);
}
add_action('admin_init', 'fscb_register_settings');
