<?php // Flipdish Ordering - Core functionality

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {

	die;

}


/**
 * Create shortcode content
 * @since 1.3.0 Display store banner, fix 1 being displayed and add initial screen and header and footer display on mobile support
 * @since 1.4.0 Fix warning messages on store banner and portal id and fix init screen and mobile setting not working
 * @since 1.4.2 Display version number
 * @since 1.4.3 Fix headers already sent issue
 */
function flipdish_ordering_system() {

	$output  = '';
	$options = get_option( 'flipdish_ordering_options', flipdish_ordering_options_default() );

	if ( ! isset( $options['fd_portal_id'] ) || '' === $options['fd_portal_id'] ) {

		return $output .= '<div>
					<h2>You must enter a Flipdish AppID</h2>
					<p><a href="https://help.flipdish.com/en/articles/4175488-how-to-find-your-appid" rel="noopener noreferrer" target="_blank">Learn how to get your Flipdish AppID here.</a></p>
					<hr />
					<p>Thank you for choosing <strong>Flipdish</strong>.</p>
					</div>';
	} else {

		// Main ordering system div
		$output .= '<div 
					data-plugin-version="' . FLIPDISH_ORDERING_VERSION . '"
					data-theme="' . esc_attr( $options['fd_theme_type'] ) . '" 
					data-offset="' . esc_attr( $options['fd_data_offset_value'] ) . '" 
					' . ( 'menu' === $options['fd_initial_screen'] ? 'data-initial-screen="menu"' : '' ) . '
					' . ( 1 === $options['fd_mobile_full_screen'] ? 'data-full-screen-on-mobile="false"' : '' ) . '
					id="flipdish-menu"
					data-restaurant="' . esc_attr( $options['fd_portal_id'] ) . '">
					</div>';

		// Production Web Ordering Script
		wp_enqueue_script( 'flipdish_production_web_ordering' );

		// Transparent background
		if ( isset( $options['fd_transparent_background'] ) && 1 === $options['fd_transparent_background'] ) {
			wp_enqueue_style( 'flipdish_production_web_ordering_transparent_background' );
		}

		return $output;
	}

}
add_shortcode( 'flipdish_ordering', 'flipdish_ordering_system' );


/**
 * Front-end web ordering scripts
 * @since 1.4.3 Register production web ordering scripts & styles
 * @since 1.4.4 Fix register style issue
 * @since 1.4.5 Include common fixes css
 */
function front_end_web_ordering_scripts() {
	wp_register_script( 
		'flipdish_production_web_ordering', 
		'https://web-order.flipdish.co/client/productionwlbuild/latest/static/js/main.js', 
		array(), 
		'1.0',   // <-- version added 
		true     // <-- load in footer
	);
	wp_register_style( 'flipdish_production_web_ordering_transparent_background', plugin_dir_url( __FILE__ ) . 'flipdish-ordering-transparent-styles.css', false, '1.0.0', 'all' );

	// Common fixes css
	wp_enqueue_style( 'flipdish_production_web_ordering_common_fixes', plugin_dir_url( __FILE__ ) . 'common-fixes.css', false, '1.0.0', 'all' );
}
add_action( 'wp_enqueue_scripts', 'front_end_web_ordering_scripts' );
