<?php // Flipdish Ordering - Register Settings - Display

// Register Group
add_settings_section(
	'flipdish_ordering_section_display',
	esc_html__( 'Ordering System Display Settings', 'flipdish-ordering-system' ),
	'flipdish_ordering_callback_section_display',
	'flipdish-ordering-system'
);


// Fields
add_settings_field(
	'fd_theme_type',
	esc_html__( 'Theme type', 'flipdish-ordering-system' ),
	'flipdish_ordering_callback_field_radio',
	'flipdish-ordering-system',
	'flipdish_ordering_section_display',
	array(
		'id'      => 'fd_theme_type',
		'label'   => esc_html__( 'This will change the colour theme of your ordering system to a light or dark version.', 'flipdish-ordering-system' ),
		'options' => array(
			'light' => esc_html__( 'Light theme', 'flipdish-ordering-system' ),
			'dark'  => esc_html__( 'Dark theme', 'flipdish-ordering-system' ),
		),
	)
);

add_settings_field(
	'fd_data_offset_value',
	esc_html__( 'Space above Basket', 'flipdish-ordering-system' ),
	'flipdish_ordering_callback_field_text',
	'flipdish-ordering-system',
	'flipdish_ordering_section_display',
	array(
		'id'    => 'fd_data_offset_value',
		'label' => esc_html__( 'When headings are fixed on the page they can overlap the Basket. Increase this number in order to move the Basket down.', 'flipdish-ordering-system' ),
	)
);

add_settings_field(
	'fd_transparent_background',
	esc_html__( 'Transparent background', 'flipdish-ordering-system' ),
	'flipdish_ordering_callback_field_checkbox',
	'flipdish-ordering-system',
	'flipdish_ordering_section_display',
	array(
		'id'    => 'fd_transparent_background',
		'label' => esc_html__( 'This will replace the background with a transparent one. Please ensure the text is easily readable on the background of your website.', 'flipdish-ordering-system' ),
	)
);

add_settings_field(
	'fd_initial_screen',
	esc_html__( 'Initial Ordering System Screen', 'flipdish-ordering-system' ),
	'flipdish_ordering_callback_field_radio',
	'flipdish-ordering-system',
	'flipdish_ordering_section_display',
	array(
		'id'      => 'fd_initial_screen',
		'label'   => esc_html__( 'Initial ordering system display page.', 'flipdish-ordering-system' ) . ' <a href="https://help.flipdish.com/en/articles/1088676-add-web-ordering-to-your-website">Learn more.</a>',
		'options' => array(
			'options' => esc_html__( 'Ordering Options', 'flipdish-ordering-system' ),
			'menu'    => esc_html__( 'Menu', 'flipdish-ordering-system' ),
		),
	)
);

add_settings_field(
	'fd_mobile_full_screen',
	'Display page header and footer on mobile',
	'flipdish_ordering_callback_field_checkbox',
	'flipdish-ordering-system',
	'flipdish_ordering_section_display',
	array(
		'id'    => 'fd_mobile_full_screen',
		'label' => esc_html__( 'Choose whether to display your page header and footer on mobile or not.', 'flipdish-ordering-system' ),
	)
);
