<?php // Flipdish Ordering - Settings Page

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
	die;
}

/**
 * Display the plugin settings page
 */
function flipdish_ordering_display_settings_page() {

	// Check if the user is allowed access
	if ( ! current_user_can( 'manage_options' ) ) {
		return;
	}
	?>

	<div class="wrap">

		<div class="flipdishHeader">
			<?php echo '<img width="700px" src="' . esc_url( plugins_url( 'images/flipdish_header_large.png', __FILE__ ) ) . '" > '; ?>
		</div>

		<div class="flipdishBody">

			<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>

			<p>
				<a href="https://flipdish.com/">Flipdish</a> provides ordering systems for restaurants, takeaways, shops and delis. Visit <a href="https://portal.flipdish.com/">our portal page</a> to set up your business with Flipdish.
			</p>

			<p><strong>Plugin:</strong> V<?php echo esc_html( FLIPDISH_ORDERING_VERSION ); ?> - <strong>PHP:</strong> V<?php echo esc_html( phpversion() ); ?></p>

			<hr />

			<?php settings_errors(); ?>

			<form action="options.php" method="post">
				<?php
				settings_fields( 'flipdish_ordering_options' );
				do_settings_sections( 'flipdish-ordering-system' );
				?>
				<div class="flipdishSubmit">
					<?php submit_button(); ?>
				</div>
			</form>

			<hr />

			<input style="position:absolute; left: -9999px;" type="text" value="[flipdish_ordering]" id="shortcodeText" placeholder="flipdish_ordering">

			<h3>Please insert the shortcode below into the page to which you wish to add the ordering system:</h3>

			<p class="shortcodeText"><?php echo esc_html('[flipdish_ordering]'); ?></p>
			<button class="copyShortcode" onclick="shortcodeCopy()">Copy Shortcode</button>

			<hr />

			<form action="<?php echo esc_attr( admin_url( 'admin-post.php' ) ); ?>" method="post" onsubmit="return confirm('Are you sure you want to reset your Flipdish ordering settings?');">
				<h2>Reset Plugin Data</h2>
				<p>Are you having any issues or want to start over? You can reset this plugin's settings to the default options here.</p>

				<input type="hidden" name="action" value="flipdish_ordering_reset_data">
				<?php wp_nonce_field( 'flipdish_ordering_reset_action', 'flipdish_ordering_reset_nonce' ); ?>

				<div class="flipdishSubmit">
					<?php submit_button( 'Reset Data' ); ?>
				</div>
			</form>

		</div>

	</div>

	<?php
}
add_action( 'admin_post_flipdish_ordering_reset_data', 'flipdish_ordering_handle_reset' );

/**
 * Reset handler for plugin data
 */
function flipdish_ordering_handle_reset() {

    if ( ! current_user_can( 'manage_options' ) ) {
        wp_die( 'Unauthorized user' );
    }

    // Check nonce
    if ( ! isset( $_POST['flipdish_ordering_reset_nonce'] ) || 
     ! wp_verify_nonce( wp_unslash( $_POST['flipdish_ordering_reset_nonce'] ), 'flipdish_ordering_reset_action' ) ) {
    wp_die( 'Nonce verification failed. Action aborted.' );
}

    // Reset the option
    delete_option( 'flipdish_ordering_options' );

    // Redirect back
    wp_redirect( add_query_arg( 'settings-updated', 'true', admin_url( 'admin.php?page=flipdish-ordering-system' ) ) );
    exit;
}