<?php
/*
Plugin Name: flickrStream
Plugin URI: http://timomontalto.com/flickrstream/
Description: Shows pictures from a flickr user photostream
Version: 0.5
License: GPL
Author: Timo Montalto
Author URI: http://timomontalto.com
*/
function get_flickrStream() {

if (false === ( $ausgabe = get_transient('bilder_cache') ) ) {

// Parameter fuer API call werden zusammengestellt
$params_old = array(
	'api_key'	=> '4ef2fe2affcdd6e13218f5ddd0e2500d',
	'method'	=> 'flickr.people.getPublicPhotos',
	'user_id'	=>  '51043375@N02',
	'format'	=> 'php_serial',
	'per_page'	=> '3',
);

// Options aus der Datenbank ziehen
$shitname = get_option('flickrStream_flickrid');
$zahl = get_option('flickrStream_display_numitems');
$imagesize = get_option('flickrStream_display_imagesize');
$cachetime = get_option('flickrStream_display_cachetime');

// Parameter im Array mit den Daten der Optionspage updaten
$params = array();
foreach($params_old as $key => $value) {
   if($key == 'user_id') {
        $params[''.$key.''] = $shitname;
   }elseif ($key == 'per_page') {
        $params[''.$key.''] = $zahl;   
   }else{
         $params[''.$key.''] = $value;
     }
 }


$encoded_params = array();

foreach ($params as $k => $v){
	$encoded_params[] = urlencode($k).'='.urlencode($v);
}

// API Call und daten in $rsp speichern
$url = "http://api.flickr.com/services/rest/?".implode('&', $encoded_params);
$rsp = file_get_contents($url);
$rsp_obj = unserialize($rsp);

// Bildergr?e abrufen
     	if ($imagesize == "square") {
             	$imgurl = "_s.jpg";
           	} elseif ($imagesize == "thumbnail") {
             $imgurl = "_t.jpg";
           	} elseif ($imagesize == "small") {
             $imgurl = "_m.jpg";
           	} elseif ($imagesize == "medium") {
             $imgurl = "_z.jpg";
           	} elseif ($imagesize == "large") {
             $imgurl = "_b.jpg";
           	}
// Wenn der Aufruf funktioniert hat...
if ($rsp_obj['stat'] == 'ok'){	

  for($count = 0; $count < $zahl; $count++)
  {
   $ausgabe .= "<div class='flickrsingle container" . $count . "'><a href='http://farm" . $rsp_obj['photos']['photo'][$count]['farm'] . ".static.flickr.com/" . $photo_server1 = $rsp_obj['photos']['photo'][$count]['server'] . "/" . $photo_id1 = $rsp_obj['photos']['photo'][$count]['id'] . "_" . $photo_secret1 = $rsp_obj['photos']['photo'][$count]['secret'] . "_z.jpg'><img class='flickrimage flickrpic" . $count . "' src='http://farm" . $rsp_obj['photos']['photo'][$count]['farm'] . ".static.flickr.com/" . $photo_server1 = $rsp_obj['photos']['photo'][$count]['server'] . "/" . $photo_id1 = $rsp_obj['photos']['photo'][$count]['id'] . "_" . $photo_secret1 = $rsp_obj['photos']['photo'][$count]['secret'] . $imgurl . "' title='" . $photo_title1 = $rsp_obj['photos']['photo'][$count]['title'] . "' /></a> <span class='flickrtext subline" . $count . "'>" . $photo_title1 = $rsp_obj['photos']['photo'][$count]['title'] . "</span></div>";
  }

}else{
// ...sonst erscheint Hinweis, das der Aufruf fehlschlug
	echo "Aufruf fehlgeschlagen!";
}
	$cachetime = "60*60*" . $cachetime;
     set_transient('bilder_cache', $ausgabe, $cachetime);
}

echo get_transient('bilder_cache');


}

function flickrStream_subpanel() {
     if (isset($_POST['save_flickrStream_settings'])) {
     
     // Daten werden aus Input Feldern gelesen
       $option_flickrid = $_POST['flickr_id'];
       $option_display_numitems = $_POST['display_numitems'];
       $option_display_imagesize = $_POST['display_imagesize'];
       $option_display_cachetime = $_POST['display_cachetime'];
     // Daten werden in die Options Tabelle geschrieben
       update_option('flickrStream_flickrid', $option_flickrid);
       update_option('flickrStream_display_numitems', $option_display_numitems);
       update_option('flickrStream_display_imagesize', $option_display_imagesize);
       update_option('flickrStream_display_cachetime', $option_display_cachetime);
     // Cache reseted
        delete_transient('bilder_cache');
       ?> <div class="updated"><p>flickrStream Einstellungen gespeichert</p></div> <?php
     }
	?>
	<div class="wrap">
		<h2>flickrStream Einstellungen</h2>
		<form method="post">
		<table class="form-table">
		 <tr valign="top">
		  <th scope="row">ID Number</th>
	      <td><input name="flickr_id" type="text" id="flickr_id" value="<?php echo get_option('flickrStream_flickrid'); ?>" size="20" />
        		</td>
         </tr>
         <tr valign="top">
          <th scope="row">Bilder anzeigen</th>
          <td>
		 	Wieviele? 
        	<select name="display_numitems" id="display_numitems">
		      <option <?php if(get_option('flickrStream_display_numitems') == '1') { echo 'selected'; } ?> value="1">1</option>
		      <option <?php if(get_option('flickrStream_display_numitems') == '2') { echo 'selected'; } ?> value="2">2</option>
		      <option <?php if(get_option('flickrStream_display_numitems') == '3') { echo 'selected'; } ?> value="3">3</option>
		      <option <?php if(get_option('flickrStream_display_numitems') == '4') { echo 'selected'; } ?> value="4">4</option>
		      <option <?php if(get_option('flickrStream_display_numitems') == '5') { echo 'selected'; } ?> value="5">5</option>
		      <option <?php if(get_option('flickrStream_display_numitems') == '6') { echo 'selected'; } ?> value="6">6</option>
		      <option <?php if(get_option('flickrStream_display_numitems') == '7') { echo 'selected'; } ?> value="7">7</option>
		      <option <?php if(get_option('flickrStream_display_numitems') == '8') { echo 'selected'; } ?> value="8">8</option>
		      <option <?php if(get_option('flickrStream_display_numitems') == '9') { echo 'selected'; } ?> value="9">9</option>
		      <option <?php if(get_option('flickrStream_display_numitems') == '10') { echo 'selected'; } ?> value="10">10</option>
		      <option <?php if(get_option('flickrStream_display_numitems') == '11') { echo 'selected'; } ?> value="11">11</option>
		      <option <?php if(get_option('flickrStream_display_numitems') == '12') { echo 'selected'; } ?> value="12">12</option>
		      <option <?php if(get_option('flickrStream_display_numitems') == '13') { echo 'selected'; } ?> value="13">13</option>
		      <option <?php if(get_option('flickrStream_display_numitems') == '14') { echo 'selected'; } ?> value="14">14</option>
		      <option <?php if(get_option('flickrStream_display_numitems') == '15') { echo 'selected'; } ?> value="15">15</option>
		      <option <?php if(get_option('flickrStream_display_numitems') == '16') { echo 'selected'; } ?> value="16">16</option>
		      <option <?php if(get_option('flickrStream_display_numitems') == '17') { echo 'selected'; } ?> value="17">17</option>
		      <option <?php if(get_option('flickrStream_display_numitems') == '18') { echo 'selected'; } ?> value="18">18</option>
		      <option <?php if(get_option('flickrStream_display_numitems') == '19') { echo 'selected'; } ?> value="19">19</option>
		      <option <?php if(get_option('flickrStream_display_numitems') == '20') { echo 'selected'; } ?> value="20">20</option>
		      </select>
		      Format?
            <select name="display_imagesize" id="display_imagesize">
		      <option <?php if(get_option('flickrStream_display_imagesize') == 'square') { echo 'selected'; } ?> value="square">square</option>
		      <option <?php if(get_option('flickrStream_display_imagesize') == 'thumbnail') { echo 'selected'; } ?> value="thumbnail">thumbnail</option>
		      <option <?php if(get_option('flickrStream_display_imagesize') == 'small') { echo 'selected'; } ?> value="small">small</option>
		      <option <?php if(get_option('flickrStream_display_imagesize') == 'medium') { echo 'selected'; } ?> value="medium">medium</option>
		      <option <?php if(get_option('flickrStream_display_imagesize') == 'large') { echo 'selected'; } ?> value="large">large</option>
		    </select>
		    Cache-Zeit
        	<select name="display_cachetime" id="display_cachetime">
		      <option <?php if(get_option('flickrStream_display_cachetime') == '1') { echo 'selected'; } ?> value="1">1</option>
		      <option <?php if(get_option('flickrStream_display_cachetime') == '3') { echo 'selected'; } ?> value="3">3</option>
		      <option <?php if(get_option('flickrStream_display_cachetime') == '6') { echo 'selected'; } ?> value="6">6</option>
		      <option <?php if(get_option('flickrStream_display_cachetime') == '8') { echo 'selected'; } ?> value="8">8</option>
		      <option <?php if(get_option('flickrStream_display_cachetime') == '10') { echo 'selected'; } ?> value="10">10</option>
		      <option <?php if(get_option('flickrStream_display_cachetime') == '12') { echo 'selected'; } ?> value="12">12</option>
		      <option <?php if(get_option('flickrStream_display_cachetime') == '18') { echo 'selected'; } ?> value="18">18</option>
		      <option <?php if(get_option('flickrStream_display_cachetime') == '24') { echo 'selected'; } ?> value="24">24</option>
		      </select>
		      Stunden
           </td> 
         </tr> 
                  </table>      
<p>Die Ausgabe erfolgt durch die Platzierung von <strong>&lt;?php if ( function_exists('get_flickrStream') ) { get_flickrStream() } ?&gt;</strong> im Template</p>
                <div class="submit">
           <input type="submit" name="save_flickrStream_settings" value="<?php _e('Speichern', 'save_flickrStream_settings') ?>" />
        </div>
        </form>
    </div>
<?php } 
function flickrStream_admin_menu() {
   if (function_exists('add_options_page')) {
        add_options_page('flickrStream Settings', 'flickrStream', 8, basename(__FILE__), 'flickrStream_subpanel');
        }
}

add_action('admin_menu', 'flickrStream_admin_menu'); 
?>