<?php
/*
Plugin Name: FlexiShare Pro - Customizable Floating Share Button
Plugin URI: https://biharinfozone.in/flexishare-pro
Description: A customizable floating share button plugin for WordPress. Allows users to add a share button with customizable positioning, color, and a fallback modal for increased social engagement.
Version: 1.0
Author: Pawan Jagriti
Author URI: https://biharinfozone.in/author/pawanjagriti
License: GPLv2 or later
Stable tag: 1.0
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: flexishare-pro
*/

// Enqueue scripts and styles
function flexishare_enqueue_scripts() {
    wp_enqueue_style( 'flexishare-style', plugins_url( 'include/floating-share-btn.css', __FILE__ ), array(), '1.0.0' );
    wp_enqueue_script( 'flexishare-script', plugins_url( 'include/floating-share-btn.js', __FILE__ ), array( 'jquery' ), '1.0.0', true );
}
add_action( 'wp_enqueue_scripts', 'flexishare_enqueue_scripts' );

// Add settings menu in the admin dashboard
function flexishare_add_settings_page() {
    add_options_page( 
        esc_html__( 'Floating Share Button Settings', 'flexishare-pro' ), 
        esc_html__( 'Floating Share Button', 'flexishare-pro' ), 
        'manage_options', 
        'flexishare-settings', 
        'flexishare_render_settings_page' 
    );
}
add_action( 'admin_menu', 'flexishare_add_settings_page' );

// Render the settings page
function flexishare_render_settings_page() {
    if ( ! current_user_can( 'manage_options' ) ) {
        return;
    }

    // Process form submission
    if ( isset( $_POST['flexishare_settings_submit'] ) && check_admin_referer( 'flexishare_nonce_action', 'flexishare_nonce_field' ) ) {
        function flexishare_append_px( $value ) {
            return is_numeric( $value ) && strpos( $value, 'px' ) === false ? $value . 'px' : $value;
        }

        if ( isset( $_POST['flexishare_position'] ) ) {
            $position = sanitize_text_field( wp_unslash( $_POST['flexishare_position'] ) );
            update_option( 'flexishare_position', $position );

            // Set left or right position to 'auto' based on the selection
            update_option( 'flexishare_left_position', $position === 'right' ? 'auto' : flexishare_append_px( sanitize_text_field( wp_unslash( $_POST['flexishare_left_position'] ) ) ) );
            update_option( 'flexishare_right_position', $position === 'left' ? 'auto' : flexishare_append_px( sanitize_text_field( wp_unslash( $_POST['flexishare_right_position'] ) ) ) );
        }

        if ( isset( $_POST['flexishare_bottom_position'] ) ) {
            update_option( 'flexishare_bottom_position', flexishare_append_px( sanitize_text_field( wp_unslash( $_POST['flexishare_bottom_position'] ) ) ) );
        }
        if ( isset( $_POST['flexishare_background_color'] ) ) {
            update_option( 'flexishare_background_color', sanitize_hex_color( wp_unslash( $_POST['flexishare_background_color'] ) ) );
        }
        if ( isset( $_POST['flexishare_enable_fallback_modal'] ) ) {
            update_option( 'flexishare_enable_fallback_modal', absint( wp_unslash( $_POST['flexishare_enable_fallback_modal'] ) ) );
        }

        add_settings_error( 'flexishare_messages', 'flexishare_message', __( 'Settings Saved', 'flexishare-pro' ), 'updated' );
    }

    settings_errors( 'flexishare_messages' );

    ?>
    <div class="wrap">
        <h1><?php esc_html_e( 'Floating Share Button Settings', 'flexishare-pro' ); ?></h1>
        <form method="post" action="">
            <?php wp_nonce_field( 'flexishare_nonce_action', 'flexishare_nonce_field' ); ?>
            
            <table class="form-table">
                <tr>
                    <th scope="row"><?php esc_html_e( 'Button Position', 'flexishare-pro' ); ?></th>
                    <td>
                        <select id="flexishare_position" name="flexishare_position">
                            <option value="left" <?php selected( get_option( 'flexishare_position' ), 'left' ); ?>><?php esc_html_e( 'Left', 'flexishare-pro' ); ?></option>
                            <option value="right" <?php selected( get_option( 'flexishare_position' ), 'right' ); ?>><?php esc_html_e( 'Right', 'flexishare-pro' ); ?></option>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><?php esc_html_e( 'Left Position (px)', 'flexishare-pro' ); ?></th>
                    <td><input type="text" name="flexishare_left_position" value="<?php echo esc_attr( get_option( 'flexishare_left_position', 'auto' ) ); ?>"></td>
                </tr>
                <tr>
                    <th scope="row"><?php esc_html_e( 'Right Position (px)', 'flexishare-pro' ); ?></th>
                    <td><input type="text" name="flexishare_right_position" value="<?php echo esc_attr( get_option( 'flexishare_right_position', '20px' ) ); ?>"></td>
                </tr>
                <tr>
                    <th scope="row"><?php esc_html_e( 'Bottom Position (px)', 'flexishare-pro' ); ?></th>
                    <td><input type="text" name="flexishare_bottom_position" value="<?php echo esc_attr( get_option( 'flexishare_bottom_position', '20px' ) ); ?>"></td>
                </tr>
                <tr>
                    <th scope="row"><?php esc_html_e( 'Background Color', 'flexishare-pro' ); ?></th>
                    <td><input type="text" name="flexishare_background_color" value="<?php echo esc_attr( get_option( 'flexishare_background_color', '#007bff' ) ); ?>"></td>
                </tr>
                <tr>
                    <th scope="row"><?php esc_html_e( 'Enable Fallback Modal', 'flexishare-pro' ); ?></th>
                    <td>
                        <input type="checkbox" name="flexishare_enable_fallback_modal" value="1" <?php checked( get_option( 'flexishare_enable_fallback_modal', 0 ), 1 ); ?>>
                    </td>
                </tr>
            </table>
            <p class="submit">
                <input type="submit" name="flexishare_settings_submit" class="button-primary" value="<?php esc_attr_e( 'Save Settings', 'flexishare-pro' ); ?>">
            </p>
        </form>
    </div>
    <?php
}

// Output the floating share button in the footer
function flexishare_add_floating_share_button() {
    $position = get_option( 'flexishare_position', 'right' );
    $left = get_option( 'flexishare_left_position', 'auto' );
    $right = get_option( 'flexishare_right_position', '20px' );
    $bottom = get_option( 'flexishare_bottom_position', '20px' );
    $background_color = get_option( 'flexishare_background_color', '#007bff' );
    $enable_fallback_modal = get_option( 'flexishare_enable_fallback_modal', 0 );

    ?>
    <style>
        .floating-share-btn {
            position: fixed;
            bottom: <?php echo esc_attr($bottom); ?>;
            <?php echo esc_attr($position); ?>: <?php echo esc_attr($position === 'left' ? $left : $right); ?>;
            background-color: <?php echo esc_attr($background_color); ?>;
            border-radius: 50%;
            padding: 15px;
            cursor: pointer;
            z-index: 1000;
            height: 60px;
            width: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
            animation: tada 1.5s infinite;
        }
    
        .floating-share-btn:active {
            
        }
    
        .floating-share-btn:hover {
            animation: tada 1.5s infinite;
        }
    
        .floating-share-btn:hover {
            background-color: #ff4b4b;
        }
    
        .superwebshare-svg {
            width: 24px;
            height: 24px;
            color: white;
        }
    
        #fallback-share-container {
            position: fixed;
            bottom: 20px;
            right: 20px;
            background-color: #fff;
            padding: 15px;
            border-radius: 8px;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
            z-index: 1000;
            width: 250px;
        }
    
        .fallback-share-content p {
            margin: 0 0 10px;
        }
    
        #share-url {
            width: 100%;
            padding: 5px;
            margin-bottom: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
    
        .fallback-share-content button {
            padding: 5px 10px;
            margin-bottom: 10px;
            background-color: #ff6b6b;
            color: #fff;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
    
        .fallback-share-content a {
            color: #007bff;
            text-decoration: none;
        }
    
        .fallback-share-content a:hover {
            text-decoration: underline;
        }
    
        /* Modal Styles */
        .fallback-modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0, 0, 0, 0.4);
            /* Black with low opacity */
        }
    
        .fallback-modal-content {
            background-color: #fefefe;
            margin: 10% auto;
            padding: 20px;
            border-radius: 8px;
            width: 80%;
            max-width: 400px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
            position: relative;
        }
    
        .close-btn {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
        }
    
        .close-btn:hover,
        .close-btn:focus {
            color: #000;
            text-decoration: none;
            cursor: pointer;
        }
    
        .post-details-area {
            display: flex;
            align-items: center;
            width: 100%;
        }
    
        .post-title-desc-here {
            text-align: left;
        }

        
    
        .social-icons {
            display: flex;
            justify-content: space-around;
            flex-wrap: wrap;
            margin: 20px 0;
        }
    
        .social-icons a {
            font-size: 24px;
            color: white;
            background-color: #555;
            border-radius: 50%;
            width: 45px;
            height: 45px;
            display: flex;
            justify-content: center;
            align-items: center;
            margin: 5px;
        }
    
        .social-icons svg {
            fill: white;
            width: 35px;
        }
    
        .social-icons a:hover {
            background-color: #333;
        }
    
        .copy-link {
            text-align: center;
        }
    
        .copy-link input {
            width: 100%;
            padding: 10px;
            margin-top: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            margin-bottom: 10px;
        }
    
        .copy-link button {
            background-color: #ff6b6b;
            color: #fff;
            border: none;
            padding: 10px 20px;
            border-radius: 5px;
            cursor: pointer;
        }
    
        .copy-link button:hover {
            background-color: #ff4b4b;
        }
    
        @keyframes tada {
            0% {
                transform: scale(1)
            }
    
            10%,
            20% {
                transform: scale(0.9) rotate(-3deg)
            }
    
            30%,
            50%,
            70%,
            90% {
                transform: scale(1.1) rotate(3deg)
            }
    
            40%,
            60%,
            80% {
                transform: scale(1.1) rotate(-3deg)
            }
    
            100% {
                transform: scale(1) rotate(0)
            }
        };
    </style>
    
    <div class="floating-share-btn" onclick="triggerShare()">
    <svg xmlns="http://www.w3.org/2000/svg" class="superwebshare-svg" fill="currentColor" viewBox="0 0 1000 1000" stroke="currentColor" stroke-width="0">
        <path stroke-linecap="round" stroke-linejoin="round" d="M789.86,323.67c91.79,0,164.25-72.46,164.25-164.25S881.64,0,789.86,0S625.6,72.46,625.6,164.25c0,4.83,0,14.49,0,24.15L306.76,371.98c-24.15-24.15-57.97-33.82-96.62-33.82c-91.79,0-164.25,72.46-164.25,164.25s72.46,164.25,164.25,164.25c38.65,0,72.46-14.49,96.62-33.82L625.6,821.26c0,9.66,0,14.49,0,19.32c0,86.96,72.46,159.42,159.42,159.42s159.42-72.46,159.42-159.42s-67.63-159.42-154.59-159.42c-33.82,0-67.63,9.66-96.62,33.82L374.4,526.57c0-9.66,0-19.32,0-24.15s0-14.49,0-24.15l318.84-188.41C717.39,314.01,751.21,323.67,789.86,323.67z"></path>
    </svg>
    </div>

    <?php if ( $enable_fallback_modal ) : ?>
        <!-- Fallback Share Modal -->
<div id="fallback-share-modal" class="fallback-modal" style="display: none;">
        <div class="fallback-modal-content">
            <span class="close-btn" onclick="closeModal()">&times;</span>
			<img id="share-image" src="" alt="Featured Image" style="display:none; margin-bottom: 10px; padding-right: 15px;">
			<h2 class="ellipsis" id="share-title">Post Title Here</h2>
            <p class="ellipsis" id="share-description">Meta description will appear here.</p>

            <div class="copy-link">
                <input type="text" value="" id="share-url" readonly>
                <button onclick="copyToClipboard()">Copy</button>
            </div>
            <p>Or share via:</p>
            <div class="social-icons">
                <a href="https://www.facebook.com/sharer/sharer.php?u=" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="100" height="100" viewBox="0 0 30 30">
                    <path d="M15,3C8.373,3,3,8.373,3,15c0,6.016,4.432,10.984,10.206,11.852V18.18h-2.969v-3.154h2.969v-2.099c0-3.475,1.693-5,4.581-5 c1.383,0,2.115,0.103,2.461,0.149v2.753h-1.97c-1.226,0-1.654,1.163-1.654,2.473v1.724h3.593L19.73,18.18h-3.106v8.697 C22.481,26.083,27,21.075,27,15C27,8.373,21.627,3,15,3z"></path>
                </svg></a>
                <a href="https://twitter.com/intent/tweet?url=" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="100" height="100" viewBox="0 0 30 30">
                    <path d="M28,6.937c-0.957,0.425-1.985,0.711-3.064,0.84c1.102-0.66,1.947-1.705,2.345-2.951c-1.03,0.611-2.172,1.055-3.388,1.295 c-0.973-1.037-2.359-1.685-3.893-1.685c-2.946,0-5.334,2.389-5.334,5.334c0,0.418,0.048,0.826,0.138,1.215 c-4.433-0.222-8.363-2.346-10.995-5.574C3.351,6.199,3.088,7.115,3.088,8.094c0,1.85,0.941,3.483,2.372,4.439 c-0.874-0.028-1.697-0.268-2.416-0.667c0,0.023,0,0.044,0,0.067c0,2.585,1.838,4.741,4.279,5.23 c-0.447,0.122-0.919,0.187-1.406,0.187c-0.343,0-0.678-0.034-1.003-0.095c0.679,2.119,2.649,3.662,4.983,3.705 c-1.825,1.431-4.125,2.284-6.625,2.284c-0.43,0-0.855-0.025-1.273-0.075c2.361,1.513,5.164,2.396,8.177,2.396 c9.812,0,15.176-8.128,15.176-15.177c0-0.231-0.005-0.461-0.015-0.69C26.38,8.945,27.285,8.006,28,6.937z"></path>
                </svg></a>
                <a href="https://wa.me/?text=" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="100" height="100" viewBox="0 0 30 30">
                    <path d="M 15 3 C 8.373 3 3 8.373 3 15 C 3 17.251208 3.6323415 19.350068 4.7109375 21.150391 L 3.1074219 27 L 9.0820312 25.431641 C 10.829354 26.425062 12.84649 27 15 27 C 21.627 27 27 21.627 27 15 C 27 8.373 21.627 3 15 3 z M 10.892578 9.4023438 C 11.087578 9.4023438 11.287937 9.4011562 11.460938 9.4101562 C 11.674938 9.4151563 11.907859 9.4308281 12.130859 9.9238281 C 12.395859 10.509828 12.972875 11.979906 13.046875 12.128906 C 13.120875 12.277906 13.173313 12.453437 13.070312 12.648438 C 12.972312 12.848437 12.921344 12.969484 12.777344 13.146484 C 12.628344 13.318484 12.465078 13.532109 12.330078 13.662109 C 12.181078 13.811109 12.027219 13.974484 12.199219 14.271484 C 12.371219 14.568484 12.968563 15.542125 13.851562 16.328125 C 14.986562 17.342125 15.944188 17.653734 16.242188 17.802734 C 16.540187 17.951734 16.712766 17.928516 16.884766 17.728516 C 17.061766 17.533516 17.628125 16.864406 17.828125 16.566406 C 18.023125 16.268406 18.222188 16.319969 18.492188 16.417969 C 18.766188 16.515969 20.227391 17.235766 20.525391 17.384766 C 20.823391 17.533766 21.01875 17.607516 21.09375 17.728516 C 21.17075 17.853516 21.170828 18.448578 20.923828 19.142578 C 20.676828 19.835578 19.463922 20.505734 18.919922 20.552734 C 18.370922 20.603734 17.858562 20.7995 15.351562 19.8125 C 12.327563 18.6215 10.420484 15.524219 10.271484 15.324219 C 10.122484 15.129219 9.0605469 13.713906 9.0605469 12.253906 C 9.0605469 10.788906 9.8286563 10.071437 10.097656 9.7734375 C 10.371656 9.4754375 10.692578 9.4023438 10.892578 9.4023438 z"></path>
                </svg></a>
                <a href="https://pinterest.com/pin/create/button/?url=" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="100" height="100" viewBox="0 0 30 30">
                    <path d="M15,3C8.373,3,3,8.373,3,15c0,5.084,3.163,9.426,7.627,11.174c-0.105-0.949-0.2-2.406,0.042-3.442 c0.218-0.936,1.407-5.965,1.407-5.965s-0.359-0.719-0.359-1.781c0-1.669,0.967-2.914,2.171-2.914c1.024,0,1.518,0.769,1.518,1.69 c0,1.03-0.655,2.569-0.994,3.995c-0.283,1.195,0.599,2.169,1.777,2.169c2.133,0,3.772-2.249,3.772-5.495 c0-2.873-2.064-4.882-5.012-4.882c-3.414,0-5.418,2.561-5.418,5.208c0,1.031,0.397,2.137,0.893,2.739 c0.098,0.119,0.112,0.223,0.083,0.344c-0.091,0.379-0.293,1.194-0.333,1.361c-0.052,0.22-0.174,0.266-0.401,0.16 c-1.499-0.698-2.436-2.889-2.436-4.649c0-3.785,2.75-7.262,7.929-7.262c4.163,0,7.398,2.966,7.398,6.931 c0,4.136-2.608,7.464-6.227,7.464c-1.216,0-2.359-0.632-2.75-1.378c0,0-0.602,2.291-0.748,2.853 c-0.271,1.042-1.002,2.349-1.492,3.146C12.57,26.812,13.763,27,15,27c6.627,0,12-5.373,12-12S21.627,3,15,3z"></path>
                </svg></a>
                <a href="https://www.linkedin.com/shareArticle?mini=true&url=" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="100" height="100" viewBox="0 0 30 30">
                    <path d="M24,4H6C4.895,4,4,4.895,4,6v18c0,1.105,0.895,2,2,2h18c1.105,0,2-0.895,2-2V6C26,4.895,25.105,4,24,4z M10.954,22h-2.95 v-9.492h2.95V22z M9.449,11.151c-0.951,0-1.72-0.771-1.72-1.72c0-0.949,0.77-1.719,1.72-1.719c0.948,0,1.719,0.771,1.719,1.719 C11.168,10.38,10.397,11.151,9.449,11.151z M22.004,22h-2.948v-4.616c0-1.101-0.02-2.517-1.533-2.517 c-1.535,0-1.771,1.199-1.771,2.437V22h-2.948v-9.492h2.83v1.297h0.04c0.394-0.746,1.356-1.533,2.791-1.533 c2.987,0,3.539,1.966,3.539,4.522V22z"></path>
                </svg></a>
                <a href="https://www.tumblr.com/widgets/share/tool?canonicalUrl=" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="100" height="100" viewBox="0 0 30 30">
                    <path d="M24,4H6C4.895,4,4,4.895,4,6v18c0,1.105,0.895,2,2,2h18c1.105,0,2-0.895,2-2V6C26,4.895,25.105,4,24,4z M20,21.714 c0,0.055-0.022,0.11-0.066,0.143C19.879,21.912,18.305,23,15.429,23C11.979,23,12,18.87,12,18.429v-4.571H9.913 c-0.111,0-0.199-0.088-0.199-0.199v-1.899c0-0.088,0.045-0.154,0.121-0.187c0.033-0.011,3.307-1.453,3.307-4.373 C13.143,7.088,13.231,7,13.342,7h1.889c0.11,0,0.198,0.088,0.198,0.199v4.373h3.23c0.099,0,0.199,0.088,0.199,0.199v1.889 c0,0.11-0.099,0.198-0.199,0.198h-3.23v4.571c0,0.066-0.105,1.456,1.371,1.456c1.213,0,2.88-0.397,2.891-0.397 c0.066-0.045,0.143-0.045,0.199-0.011C19.955,19.51,20,19.576,20,19.653V21.714z"></path>
                </svg></a>
                <a href="https://www.reddit.com/submit?url=" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="100" height="100" viewBox="0 0 30 30">
                    <path d="M 17.662109 2 C 15.565005 2 14 3.7131367 14 5.6621094 L 14 9.0351562 C 11.24971 9.1810926 8.7344872 9.9143634 6.7265625 11.064453 C 5.9527826 10.321405 4.9166871 9.991448 3.9121094 9.9921875 C 2.8229214 9.9929893 1.7094525 10.370413 0.94140625 11.234375 L 0.92382812 11.253906 L 0.90625 11.273438 C 0.16947928 12.194228 -0.12225605 13.427747 0.07421875 14.652344 C 0.25365009 15.770711 0.90137168 16.893419 2.0273438 17.628906 C 2.0199689 17.753058 2 17.874618 2 18 C 2 22.962 7.832 27 15 27 C 22.168 27 28 22.962 28 18 C 28 17.874618 27.980031 17.753058 27.972656 17.628906 C 29.098628 16.893419 29.74635 15.770711 29.925781 14.652344 C 30.122256 13.427747 29.830521 12.194228 29.09375 11.273438 L 29.076172 11.253906 L 29.058594 11.234375 C 28.290448 10.370294 27.177168 9.9929893 26.087891 9.9921875 C 25.08323 9.991448 24.046988 10.321133 23.273438 11.064453 C 21.265513 9.9143634 18.75029 9.1810926 16 9.0351562 L 16 5.6621094 C 16 4.6830821 16.565214 4 17.662109 4 C 18.182797 4 18.817104 4.2609042 19.810547 4.609375 C 20.650361 4.9039572 21.743308 5.2016984 23.140625 5.2910156 C 23.474875 6.2790874 24.402814 7 25.5 7 C 26.875 7 28 5.875 28 4.5 C 28 3.125 26.875 2 25.5 2 C 24.561213 2 23.747538 2.5304211 23.320312 3.3007812 C 22.125831 3.2346294 21.248238 2.9947078 20.472656 2.7226562 C 19.568849 2.4056271 18.738422 2 17.662109 2 z M 3.9121094 11.992188 C 4.3072494 11.991896 4.6826692 12.095595 4.9921875 12.263672 C 3.8881963 13.18517 3.0505713 14.261821 2.5449219 15.4375 C 2.2764358 15.106087 2.114647 14.734002 2.0507812 14.335938 C 1.9430146 13.664243 2.1440212 12.966045 2.4628906 12.552734 C 2.7642172 12.228395 3.3144613 11.992626 3.9121094 11.992188 z M 26.085938 11.992188 C 26.683756 11.992627 27.235874 12.22849 27.537109 12.552734 C 27.855979 12.966045 28.056985 13.664243 27.949219 14.335938 C 27.885353 14.734002 27.723564 15.106087 27.455078 15.4375 C 26.949429 14.261821 26.111804 13.18517 25.007812 12.263672 C 25.316626 12.095792 25.690955 11.991896 26.085938 11.992188 z M 10 14 C 11.105 14 12 14.895 12 16 C 12 17.105 11.105 18 10 18 C 8.895 18 8 17.105 8 16 C 8 14.895 8.895 14 10 14 z M 20 14 C 21.105 14 22 14.895 22 16 C 22 17.105 21.105 18 20 18 C 18.895 18 18 17.105 18 16 C 18 14.895 18.895 14 20 14 z M 20.238281 19.533203 C 19.599281 21.400203 17.556 23 15 23 C 12.444 23 10.400719 21.400969 9.7617188 19.667969 C 10.911719 20.600969 12.828 21.267578 15 21.267578 C 17.172 21.267578 19.088281 20.600203 20.238281 19.533203 z"></path>
                    </svg></a>
                <a href="https://t.me/share/url?url=" target="_blank"><svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="100" height="100" viewBox="0 0 64 64">
                    <path d="M32,10c12.15,0,22,9.85,22,22s-9.85,22-22,22s-22-9.85-22-22S19.85,10,32,10z M39.589,40.968	c0.404-1.241,2.301-13.615,2.534-16.054c0.071-0.738-0.163-1.229-0.619-1.449c-0.553-0.265-1.371-0.133-2.322,0.21	c-1.303,0.47-17.958,7.541-18.92,7.951c-0.912,0.388-1.775,0.81-1.775,1.423c0,0.431,0.256,0.673,0.96,0.924	c0.732,0.261,2.577,0.82,3.668,1.121c1.05,0.29,2.243,0.038,2.913-0.378c0.709-0.441,8.901-5.921,9.488-6.402	c0.587-0.48,1.056,0.135,0.576,0.616c-0.48,0.48-6.102,5.937-6.844,6.693c-0.901,0.917-0.262,1.868,0.343,2.249	c0.689,0.435,5.649,3.761,6.396,4.295c0.747,0.534,1.504,0.776,2.198,0.776C38.879,42.942,39.244,42.028,39.589,40.968z"></path>
                    </svg></a>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <script>
        function triggerShare() {
    const postTitle = document.querySelector('meta[property="og:title"]')?.getAttribute("content") || document.title;
    const metaDescription = document.querySelector('meta[name="description"]')?.getAttribute("content") || '';
    const postUrl = window.location.href;
    const featuredImage = document.querySelector('meta[property="og:image"]')?.getAttribute("content") || '';

    if (navigator.share) {
        navigator.share({
            title: postTitle,
            text: metaDescription,
            url: postUrl,
            
        }).catch((error) => {
            console.log('Error sharing:', error);
            showFallbackShareOptions(postTitle, metaDescription, postUrl, featuredImage);
        });
    } else {
        showFallbackShareOptions(postTitle, metaDescription, postUrl, featuredImage);
    }
}

function showFallbackShareOptions(title, description, url, imageUrl) {
    const fallbackModal = document.getElementById('fallback-share-modal');
    fallbackModal.style.display = 'block';
    document.getElementById('share-url').value = url;
    document.getElementById('share-title').innerText = title;
    document.getElementById('share-description').innerText = description;
    if (imageUrl) {
        document.getElementById('share-image').src = imageUrl;
        document.getElementById('share-image').style.display = 'block';
    } else {
        document.getElementById('share-image').style.display = 'none';
    }
    updateSocialLinks(url, title, description, imageUrl);
}

function closeModal() {
    document.getElementById('fallback-share-modal').style.display = 'none';
}

function updateSocialLinks(url, title, description, imageUrl) {
    const socialLinks = document.querySelectorAll('.social-icons a');
    socialLinks.forEach(link => {
        const href = link.getAttribute('href');
        const finalUrl = `${href}${encodeURIComponent(url)}&title=${encodeURIComponent(title)}&description=${encodeURIComponent(description)}&image=${encodeURIComponent(imageUrl)}`;
        link.setAttribute('href', finalUrl);
    });
};

function copyToClipboard() {
    const copyText = document.getElementById('share-url');
    copyText.select();
    document.execCommand('copy');
    alert('Link copied to clipboard!');
}

window.onclick = function(event) {
    const fallbackModal = document.getElementById('fallback-share-modal');
    if (event.target == fallbackModal) {
        fallbackModal.style.display = 'none';
    }
};

$(document).ready(function() {
    $('.ellipsis').each(function() {
        var lineHeight = parseInt($(this).css('line-height'), 10);
        var maxHeight = lineHeight * 2; // Limit to 2 lines

        if ($(this).height() > maxHeight) {
            $(this).css('overflow', 'hidden');
            $(this).css('display', '-webkit-box');
            $(this).css('-webkit-box-orient', 'vertical');
            $(this).css('-webkit-line-clamp', 2);
            $(this).css('text-overflow', 'ellipsis');
        }
    });
});
    </script>
    <?php
}
add_action( 'wp_footer', 'flexishare_add_floating_share_button' );

