/**
 * WordPress dependencies
 */
import { Path, SVG, Circle, Polygon } from '@wordpress/components';

export const blockIcon = (
	<SVG xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
		<Polygon points="17.5 1 7.8 5.6 10.8 6 6.5 10 16.5 5.5 13.4 5 17.5 1" />
		<Path d="M19,11H5c-1.1,0-2,.9-2,2v8c0,1.1.9,2,2,2h14c1.1,0,2-.9,2-2v-8c0-1.1-.9-2-2-2ZM11.5,16.5h-7v-3.5c0-.3.2-.5.5-.5h6.5v4ZM13,12.5h6c.3,0,.5.2.5.5v3.5h-6.5v-4ZM4.5,21v-3h7v3.5h-6.5c-.3,0-.5-.2-.5-.5ZM19,21.5h-6v-3.5h6.5v3c0,.3-.2.5-.5.5Z" />
	</SVG>
);

export const tableMergeCell = (
	<SVG xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
		<Path d="M11 5C11 4 10 3 9.00003 3H5.00003C3.98623 3 2.99293 4.01901 3.00003 5V19C2.99293 19.981 3.98623 21 5.00003 21H9.00003C10 21 11 20 11 19V15H9.50003V19C9.50003 19.3 9.30003 19.5 9.00003 19.5H5.00003C4.70003 19.5 4.50003 19.3 4.50003 19V12.75H8.30003L6.50003 14.5L7.50003 15.5L11 12L7.50003 8.5L6.50003 9.5L8.30003 11.25H4.50003V5C4.50003 4.7 4.70003 4.5 5.00003 4.5H9.00003C9.30003 4.5 9.50003 4.7 9.50003 5V9H11V5ZM21 5C21 4 20 3 19 3H15C13.9862 3 12.9929 4.01902 13 5V9H14.5V5C14.5 4.7 14.7 4.5 15 4.5H19C19.3 4.5 19.5 4.7 19.5 5V11.25H15.75L17.5 9.5L16.5 8.5L13 12L16.5 15.5L17.5 14.5L15.75 12.75H19.5V15.875V18.5L19 19H15.0012L14.5 18.5V15H13V19C12.9929 19.981 13.9874 21 15.0012 21H19C20 21 21 20 21 19V5Z" />
	</SVG>
);

export const tableSplitCell = (
	<SVG xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
		<Path d="M3 5C3 4 4 3 5 3H9C10.0138 3 11.0071 4.01901 11 5V19C11.0071 19.981 10.0138 21 9 21H5C4 21 3 20 3 19V15H4.5V19C4.5 19.3 4.7 19.5 5 19.5H9C9.3 19.5 9.5 19.3 9.5 19V12.75H5.7L7.5 14.5L6.5 15.5L3 12L6.5 8.5L7.5 9.5L5.7 11.25H9.5V5C9.5 4.7 9.3 4.5 9 4.5H5C4.7 4.5 4.5 4.7 4.5 5V9H3V5ZM13 5C13 4 14 3 15 3H19C20.0138 3 21.0071 4.01902 21 5V9H19.5V5C19.5 4.7 19.3 4.5 19 4.5H15C14.7 4.5 14.5 4.7 14.5 5V11.25H18.25L16.5 9.5L17.5 8.5L21 12L17.5 15.5L16.5 14.5L18.25 12.75H14.5V15.875V18.5L15 19H18.9988L19.5 18.5V15H21V19C21.0071 19.981 20.0126 21 18.9988 21H15C14 21 13 20 13 19V5Z" />
	</SVG>
);

export const borderSeparate = (
	<SVG xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
		<Path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M5.00001 3C4 3 3.00001 4 3.00001 5L3 9C3 10 4 11 5.00001 11H9C10 11 11 10 11 9L11 5C11 3.9 10.1 3 9.00001 3H5.00001ZM5.00001 9.5H9.00001C9.30001 9.5 9.50001 9.3 9.50001 9V5C9.50001 4.7 9.30001 4.5 9.00001 4.5H5.00001C4.70001 4.5 4.50001 4.7 4.50001 5V9C4.50001 9.3 4.70001 9.5 5.00001 9.5ZM15 3C14 3 13 4 13 5V9C13 10 14 11 15 11H19C20 11 21 10 21 9V5C21 4 20 3 19 3H15ZM15 9.5H19C19.3 9.5 19.5 9.3 19.5 9V5C19.5 4.7 19.3 4.5 19 4.5H15C14.7 4.5 14.5 4.7 14.5 5V9C14.5 9.3 14.7 9.5 15 9.5ZM5.00001 13C4 13 3 14 3 15L3.00001 19C3.00001 20 4 21 5 21H9C10 21 11 20 11 19V15C11 14 10 13 9.00001 13H5.00001ZM5.00001 19.5H9C9.3 19.5 9.50001 19.3 9.50001 19V15C9.50001 14.7 9.3 14.5 9 14.5H5C4.7 14.5 4.5 14.7 4.5 15L4.50001 19C4.50001 19.3 4.70001 19.5 5.00001 19.5ZM15 13C14 13 13 14 13 15V19C13 20 14 21 15 21H19C20 21 21 20 21 19V15C21 14 20 13 19 13H15ZM15 19.5H19C19.3 19.5 19.5 19.3 19.5 19L19.5 15C19.5 14.7 19.3 14.5 19 14.5H15C14.7 14.5 14.5 14.7 14.5 15V19C14.5 19.3 14.7 19.5 15 19.5Z"
		/>
	</SVG>
);

export const borderCollapse = (
	<SVG xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
		<Path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M19 3H5C4 3 3 4 3 5V19C3 20 4 21 5 21H19C20 21 21 20 21 19V5C21 3.9 20.1 3 19 3ZM5 19.5C4.7 19.5 4.5 19.3 4.5 19V13.25C4.5 12.95 4.7 12.75 5 12.75H10.75C11.05 12.75 11.25 12.95 11.25 13.25V19C11.25 19.3 11.05 19.5 10.75 19.5H5ZM5 4.5C4.7 4.5 4.5 4.7 4.5 5V10.75C4.5 11.05 4.7 11.25 5 11.25H10.75C11.05 11.25 11.25 11.05 11.25 10.75V5C11.25 4.7 11.05 4.5 10.75 4.5H5ZM13.25 11.25C12.95 11.25 12.75 11.05 12.75 10.75V5C12.75 4.7 12.95 4.5 13.25 4.5H19C19.3 4.5 19.5 4.7 19.5 5V10.75C19.5 11.05 19.3 11.25 19 11.25H13.25ZM19 19.5C19.3 19.5 19.5 19.3 19.5 19V13.25C19.5 12.95 19.3 12.75 19 12.75H13.25C12.95 12.75 12.75 12.95 12.75 13.25V19C12.75 19.3 12.95 19.5 13.25 19.5H19Z"
		/>
	</SVG>
);

export const borderSolid = (
	<SVG xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
		<Path d="M4,11.2h16v1.5H4v-1.5Z" />
	</SVG>
);

export const borderDotted = (
	<SVG xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
		<Circle cx="6" cy="12" r="2" />
		<Circle cx="18" cy="12" r="2" />
		<Circle cx="12" cy="12" r="2" />
	</SVG>
);

export const borderDashed = (
	<SVG xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
		<Path d="M4 11.25H8V12.75H4V11.25ZM16 11.25H20V12.75H16V11.25ZM10 11.25H14V12.75H10V11.25Z" />
	</SVG>
);

export const borderDouble = (
	<SVG xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
		<Path d="M4 9.5H20V11H4V9.5ZM4 13H20V14.5H4V13Z" />
	</SVG>
);
