<?php
/*
 * Plugin Name:       Flexible Custom Post Type Order
 * Plugin URI:        http://wordpress.org/plugins/flexible-custom-post-type-order/
 * Description:       Flexible Custom Post Type Order plugin will generate multiple re-ordering interface for your same post types as well as individual custom post types as many times as you want.
 * Version:           1.1.3
 * Requires at least: 6.2
 * Requires PHP:      7.2
 * Author:            Satish V. Dharavia
 * Author URI:        https://profiles.wordpress.org/satishnavjivan1/
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       flexible-custom-post-type-order
 * Domain Path:       /languages
 * Requires Plugins:  
 */





if (!defined('ABSPATH'))
    exit; // Exit if accessed directly



// only include add-on once
define('fcpto_PATH', plugin_dir_path(__FILE__));
require_once(fcpto_PATH . 'fcpto-option.php');
require_once(fcpto_PATH . 'fcpto-list.php');
require_once(fcpto_PATH . 'fcpto-fun.php');



/**
 * Admin side js
 * Drag and Drop Custom fcpto JS
 */
define('fcpto_URL', plugins_url('', __FILE__));
function fcpto_enqueue()
{
    wp_enqueue_script('jquery-ui-sortable');
}
add_action('admin_enqueue_scripts', 'fcpto_enqueue');

// Admin side css add 
function fcpto_ev_load_custom_wp_admin_style()
{
    wp_register_style('fcpto-style', fcpto_URL . '/css/style.css', array(), '1.0.0');
    wp_enqueue_style('fcpto-style');
}
add_action('admin_enqueue_scripts', 'fcpto_ev_load_custom_wp_admin_style');


// General Option
add_action('admin_menu', 'fcpto_register_submenu_page');
function fcpto_register_submenu_page()
{
    $fcpto_options = unserialize(get_option('fcpto_options'));
    $order_options = unserialize(get_option('order_options'));
    if ($fcpto_options != '') {
        foreach ($fcpto_options as $key => $val) {
            if ($val == 'show') {
                if ($order_options[$key] != '') {
                    for ($i = 1; $i <= $order_options[$key]; $i++) {
                        if ($key != 'post') {
                            add_submenu_page('edit.php?post_type=' . $key, 'FCPT Order ' . $i, 'FCPT Order ' . $i, 'manage_options', 'fcpto_list_' . $key . '-' . $i, 'fcpto_list');
                        }
                        else {
                            add_submenu_page('edit.php', 'FCPT Order ' . $i, 'FCPT Order ' . $i, 'manage_options', 'fcpto_list_post' . '-' . $i, 'fcpto_list');
                        }
                    }
                }
            }
        }
    }
    add_options_page('Flexible Custom Post Type Order', 'Flexible Custom Post Type Order', 'manage_options', 'fcpto-options', 'fcpto_plugin_options');
}

/* Add meta box */
add_action('add_meta_boxes', 'fcpto_add_custom_field_metabox');
function fcpto_add_custom_field_metabox()
{
    // Add meta box  goes into our admin_init function
    $fcpto_options = unserialize(get_option('fcpto_options'));
    $post_type_name = get_post_type(get_the_ID());
    if ((!empty($fcpto_options)) && ($fcpto_options != '')) {
        if ($fcpto_options[$post_type_name] == 'show') {
            add_meta_box(
                'fcpto_custom_field',
                __('Order Fields', 'flexible-custom-post-type-order'),
                'fcpto_custom_field_metabox',
                $post_type_name,
                'normal',
                'high'
            );
        }
    }
}
function fcpto_custom_field_metabox()
{
    $post_type_name = get_post_type(get_the_ID());
    $order_options = unserialize(get_option('order_options'));
    $no_of_order = 0;
    $no_of_order = $order_options[$post_type_name];
    if ($no_of_order > 0) {
        for ($i = 1; $i <= $no_of_order; $i++) {
?>
        <input type="text" name="custom_order_type_dsnv_<?php echo esc_html($i); ?>" value="<?php $orde_no = get_post_meta(get_the_ID(), 'custom_order_type_dsnv_' . $i, true);
            if ($orde_no != '') {
                echo esc_html($orde_no);
            }
            else {
                echo esc_html('0');
            }?>">
        <?php
        }
    }
}



// On post save, save data
add_action('save_post', 'fcpto_save_postdata', 10, 2);
function fcpto_save_postdata($post_id)
{
    // Check if user has permissions to save data.
    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    // Check if not an autosave.
    if (wp_is_post_autosave($post_id)) {
        return;
    }

    // Check if not a revision.
    if (wp_is_post_revision($post_id)) {
        return;
    }

    $post_type_name = get_post_type($post_id);
    $order_options = get_option('order_options');
    $fcpto_options = get_option('fcpto_options');

    if (is_string($order_options))
        $order_options = unserialize($order_options);
    if (is_string($fcpto_options))
        $fcpto_options = unserialize($fcpto_options);

    // Check if ordering is enabled for this post type
    if (empty($fcpto_options[$post_type_name]) || $fcpto_options[$post_type_name] !== 'show') {
        return;
    }

    $no_of_order = 0;
    if (isset($order_options[$post_type_name])) {
        $no_of_order = intval($order_options[$post_type_name]);
    }

    if ($no_of_order > 0) {
        global $wpdb;
        for ($i = 1; $i <= $no_of_order; $i++) {
            $meta_key = 'custom_order_type_snv_' . $i;

            // Check if meta already exists (don't overwrite manual re-orders or existing values unless empty)
            $existing_val = get_post_meta($post_id, $meta_key, true);

            // If it's a new post or has no order value yet
            if ($existing_val === '') {
                // Find the current minimum value to place this new post BEFORE the first one (ASC order)
                // We want new posts to be FIRST. If list is 0, 1, 2... new should be -1.
                // If list is empty, start at 0.

                // Get min value directly from DB for performance
                // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery
                $min_val = $wpdb->get_var($wpdb->prepare(
                    "
                    SELECT MIN(CAST(meta_value AS SIGNED)) 
                    FROM {$wpdb->postmeta} 
                    WHERE meta_key = %s
                    ",
                    $meta_key
                ));

                if (is_null($min_val)) {
                    $new_val = 0;
                }
                else {
                    $new_val = intval($min_val) - 1;
                }

                update_post_meta($post_id, $meta_key, $new_val);
            }
        }
    }
}
?>