<?php
// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;
// All option
function fcpto_plugin_options() {

    $fcpto_options = unserialize(get_option('fcpto_options'));
    $order_options = unserialize(get_option('order_options'));
    ?>
    <div id="cpto" class="wrap"> 
        <div id="icon-settings" class="icon32"></div>
        <h2><?php esc_attr_e('General Settings', 'flexible-custom-post-type-order') ?></h2>
        <form id="form_data" name="form" method="post">   
            <table class="form-table">
                <tbody>
                    <tr valign="top">
                        <th scope="row" ><label><?php esc_attr_e('Show / Hide Re-Order Interface', 'flexible-custom-post-type-order') ?></label></th>
                        <th scope="row" ><label><?php esc_attr_e('Re-Order no. of List', 'flexible-custom-post-type-order') ?></label></th>
                    </tr>
    <?php
    $post_types = get_post_types();
    foreach (@$post_types as $post_type_name) {
        //ignore list
        $ignore_post_types = array(
            'reply',
            'topic',
            'report',
            'status',
            'shop_order',
            'shop_coupon',
            'shop_webhook',
            'attachment',
            'popup_theme',
            'acf'
        );

        if (in_array($post_type_name, $ignore_post_types))
            continue;

        $post_type_data = get_post_type_object($post_type_name);
        if ($post_type_data->show_ui === FALSE)
            continue;
        ?>
                        <tr valign="top">
                            <td>
                                <p><label>
                                        <select name="show_reorder_interfaces[<?php echo esc_html($post_type_name) ?>]">
                                            <option value="hide" <?php if (@$fcpto_options[$post_type_name] == 'hide') {
                                                echo ' selected="selected"';
                                            } ?>><?php esc_attr_e("Hide", 'flexible-custom-post-type-order'); ?></option>

                                            <option value="show" <?php if (@$fcpto_options[$post_type_name] == 'show') {
                                                echo ' selected="selected"';
                                            } ?>><?php esc_attr_e("Show", 'flexible-custom-post-type-order'); ?></option>
                                        </select> &nbsp;&nbsp;<?php echo esc_html($post_type_data->labels->singular_name) ?>
                                    </label>
                            </td>
                            <td>
                                <label>
                                    <input type="number" name="re-re-no-of-order[<?php echo esc_html($post_type_name) ?>]" value="<?php if ($order_options[$post_type_name] == '') {
                    echo '1';
                } else {
                    echo esc_html($order_options[$post_type_name]);
                } ?>">
                                    &nbsp;&nbsp;<?php echo esc_html($post_type_data->labels->singular_name); ?>
                                </label>
                            </td>
                        </tr>
    <?php } ?>

                </tbody>
            </table>
			
            <p class="submit">
                <button onclick="fn_option_save();" class="button button-primary button-large" type="button" name="Save-Settings"><?php 
                            esc_attr_e('Save Settings', 'flexible-custom-post-type-order') ?></button>
            </p>
			<?php wp_nonce_field('fcpto_form_submit','fcpto_form_nonce'); ?>
            <input type="hidden" name="form_submit" value="true" />
            <input type="hidden" name="action" value="fcpto_save_option"/>

        </form>

        <br />
        <script type="text/javascript">
            function fn_option_save() {
                var form_data = jQuery('#form_data').serialize();
                jQuery.ajax({
                    type: "POST",
                    url: "<?php echo esc_url(admin_url('admin-ajax.php')); ?>",
                    data: form_data,
                    success: function (data) {
                        window.location.reload(true);
                    }
                    //window.location.reload();
                });
                return false;
            }
        </script>
        
    </div>        
    <?php
}


/*  Message store in session */
add_action('wp_ajax_fcpto_save_option', 'fcpto_save_option');
function fcpto_save_option() {
    session_start();

    if (
        isset($_POST['form_submit']) &&
        isset($_POST['fcpto_form_nonce']) &&
        wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['fcpto_form_nonce'])), 'fcpto_form_submit')
    ) {
        // Sanitize and serialize arrays safely
        $show_reorder_interfaces = '';
        if (isset($_POST['show_reorder_interfaces']) && is_array($_POST['show_reorder_interfaces'])) {
            $cleaned_interfaces = array_map('sanitize_text_field', wp_unslash($_POST['show_reorder_interfaces']));
            $show_reorder_interfaces = serialize($cleaned_interfaces);
        }
        update_option('fcpto_options', $show_reorder_interfaces);

        $re_order = '';
        if (isset($_POST['re-re-no-of-order']) && is_array($_POST['re-re-no-of-order'])) {
            $cleaned_order = array_map('sanitize_text_field', wp_unslash($_POST['re-re-no-of-order']));
            $re_order = serialize($cleaned_order);
        }
        update_option('order_options', $re_order);

        $_SESSION['notices'] = array('type' => 'success', 'msg' => 'Setting saved successfully.');
    } else {
        $_SESSION['notices'] = array('type' => 'error', 'msg' => 'Failed to save settings.');
    }

    wp_die();
}


?>