<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
function fcpto_list()
{
    $post_type = 'post';
    // phpcs:disable WordPress.Security.NonceVerification.Recommended
    if (isset($_GET['post_type'])) {
        $post_type = sanitize_text_field(wp_unslash($_GET['post_type']));
    }
    // phpcs:enable
    $no_order = '1';
    // phpcs:disable WordPress.Security.NonceVerification.Recommended
    if (isset($_GET['page'])) {
        $page_data = explode('-', sanitize_text_field(wp_unslash($_GET['page'])));
        if (end($page_data) != '') {
            $no_order = end($page_data);
        }
    }
    // phpcs:enable

    // Create nonce
    $ajax_nonce = wp_create_nonce('fcpto_list_security');

    fcpto_ensure_default_custom_order_meta_all($no_order, $post_type);
    //return $category_tree_array;




    $pageposts = fcpto_categoryParentChildTree();
?>
    <div class="fcpto_snv">
        <table class="widefat">
            <tr>
                <td>
                    <h2><?php
    global $wp_post_types;
    $obj = $wp_post_types[$post_type];
    echo esc_html(ucwords($obj->labels->singular_name));
?>  Re Order (<?php echo esc_html($no_order); ?>) </h2>
                </td>
                <td>
                    <button onclick="order_save();" class="button button-primary button-large" type="submit" ><?php esc_html_e('Save Order', 'flexible-custom-post-type-order'); ?></button>
                    <button id="display_query_code" class="button button-primary button-large" type="button"><?php esc_html_e('Display Query Code', 'flexible-custom-post-type-order'); ?></button>
                    <button onclick="fn_reset_order();" class="button button-primary button-large" type="button" name="Reset"><?php esc_html_e('Reset Order', 'flexible-custom-post-type-order'); ?></button>
                </td>
            </tr>
            <tr class="querycode" style="display: none;">
                <td>
                    <h2><?php esc_html_e('Query parameter', 'flexible-custom-post-type-order'); ?></h2>      
                </td>
                <td>
                    <span class="shortcode"><input readonly="readonly" onfocus="this.select();" type="text" value="'orderby' => 'meta_value_num', 'meta_key' => 'custom_order_type_snv_<?php echo esc_html($no_order); ?>'" ></span>
                </td>
            </tr>
            <tr class="querycode" style="display: none;">
                <td>
                    <h2><?php esc_html_e('Query Code', 'flexible-custom-post-type-order'); ?></h2>      
                </td>
                <td>
                    <span class="shortcode">
                        <textarea rows="12" onfocus="this.select();" >&lt;?php $data = new WP_Query( 
                        array(  'post_type' => '<?php echo esc_html($post_type); ?>', 
                                'post_status' => array( 'publish'),
                                'posts_per_page' => -1, 
                                'orderby' => 'meta_value_num', 
                                'meta_key' => 'custom_order_type_snv_<?php echo esc_html($no_order); ?>', 
                                'order' => 'ASC',   
                     ) ); ?&gt;
    &lt;?php while ( $data->have_posts() ) : $data->the_post(); ?&gt;
    &lt;?php the_title(); ?&gt;
    &lt;?php endwhile;?>
    &lt;?php wp_reset_query(); ?&gt;</textarea></span>
                </td>
            </tr>
        </table>
        <ul id="sortable">
    <?php $i = 0; ?>
            <?php foreach ($pageposts as $value) { ?>
                <?php $i++; ?>
                <li class="row-title" id='item-<?php echo esc_html($value['id']); ?>'><span class="box"><?php echo esc_html($i); ?></span><?php echo esc_html($value['name']); ?></li>
            <?php
    }?>
        </ul>
    </div>

    <script>
        jQuery('#display_query_code').click(function () {
            jQuery('.fcpto_snv .querycode').toggle('slow');
            if (jQuery(this).text() == "Display Query Code") 
            { 
               jQuery(this).text("Hide Query Code"); 
            } 
            else 
            { 
               jQuery(this).text("Display Query Code"); 
            };
        });
        jQuery(document).ready(function() {
        jQuery('#sortable').sortable({
            axis: 'y',
            update: function (event, ui) {
                var data = jQuery(this).sortable('serialize');
                var no_order = '<?php echo esc_html($no_order); ?>';
                // POST to server using $.post or $.ajax
                var queryString = {"action": "fcpto_list_update", "data": data, "no_order": no_order, "security": "<?php echo esc_js($ajax_nonce); ?>"};
                //send the data through ajax
                jQuery.ajax({
                    type: 'POST',
                    url: ajaxurl,
                    data: queryString,
                    cache: false,
                    dataType: "html",
                    success: function (data) {

                    },
                    error: function (html) {

                    }
                });
            }
        });
        
            var data = jQuery('#sortable').sortable('serialize');
            var no_order = '<?php echo esc_html($no_order); ?>';
            // POST to server using $.post or $.ajax
            var queryString = {"action": "fcpto_list_update", "data": data, "no_order": no_order, "security": "<?php echo esc_js($ajax_nonce); ?>"};
            //send the data through ajax
            jQuery.ajax({
                type: 'POST',
                url: ajaxurl,
                data: queryString,
                cache: false,
                dataType: "html",
                success: function (data) {

                },
                error: function (html) {

                }
            });

        });
        function fn_reset_order()
        {
    <?php
    $http_host = isset($_SERVER['HTTP_HOST']) ? sanitize_text_field(wp_unslash($_SERVER['HTTP_HOST'])) : '';
    $request_uri = isset($_SERVER['REQUEST_URI']) ? sanitize_text_field(wp_unslash($_SERVER['REQUEST_URI'])) : '';
    $url = "//" . $http_host . $request_uri;
?>
            var no_order = '<?php echo esc_html($no_order); ?>';
            var post_type = '<?php echo esc_html($post_type); ?>';
            var queryString = {"action": "fcpto_list_reset_order", "no_order": no_order, "post_type": post_type, "security": "<?php echo esc_js($ajax_nonce); ?>"};
            //Send the data through ajax
            jQuery.ajax({
                type: 'POST',
                url: ajaxurl,
                data: queryString,
                cache: false,
                dataType: "html",
                success: function () {
                    window.location.href = "<?php echo esc_html($url); ?>";
                },
                error: function (html) {

                }
            });
        }
        function order_save()
        {
    <?php
    $http_host = isset($_SERVER['HTTP_HOST']) ? sanitize_text_field(wp_unslash($_SERVER['HTTP_HOST'])) : '';
    $request_uri = isset($_SERVER['REQUEST_URI']) ? sanitize_text_field(wp_unslash($_SERVER['REQUEST_URI'])) : '';
    $url = "//" . $http_host . $request_uri;
?>
            window.location.href = "<?php echo esc_url_raw($url); ?>";
        }
    </script>
    <?php
}

/*  fcpto update list */
add_action('wp_ajax_fcpto_list_update', 'fcpto_list_update');
function fcpto_list_update()
{
    check_ajax_referer('fcpto_list_security', 'security');

    $data = isset($_POST['data']) ? str_replace('&', '', sanitize_text_field(wp_unslash($_POST['data']))) : '';
    $data = explode('item[]=', $data);
    $no_order = isset($_POST['no_order']) ? intval($_POST['no_order']) : 0;
    // key = order number and value =  post id
    foreach ($data as $key => $value) {
        update_post_meta($value, 'custom_order_type_snv_' . $no_order, $key);
    }
}

/*  fcpto reset order and reorder*/
add_action('wp_ajax_fcpto_list_reset_order', 'fcpto_list_reset_order');
function fcpto_list_reset_order()
{
    check_ajax_referer('fcpto_list_security', 'security');
    global $wpdb;

    if (!empty($_POST['post_type'])) {
        $post_type = sanitize_text_field(wp_unslash($_POST['post_type']));

        $cache_key = 'fcpto_list_posts_' . md5($post_type);
        $pageposts = wp_cache_get($cache_key, 'fcpto_list');

        if (false === $pageposts) {
            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery
            $pageposts = $wpdb->get_results(
                $wpdb->prepare(
                "
                        SELECT p.ID
                        FROM {$wpdb->posts} p
                        INNER JOIN {$wpdb->postmeta} pm ON (p.ID = pm.post_id)
                        WHERE p.post_type = %s
                        AND (
                            p.post_status = 'publish'
                            OR p.post_status = 'future'
                            OR p.post_status = 'draft'
                            OR p.post_status = 'pending'
                            OR p.post_status = 'private'
                        )
                        GROUP BY p.ID
                        ORDER BY p.post_name ASC
                        ",
                $post_type
            ),
                OBJECT
            );
            wp_cache_set($cache_key, $pageposts, 'fcpto_list', 3600);
        }
    }


    $no_order = 1;
    if (!empty($_POST['no_order'])) {
        $no_order = intval($_POST['no_order']);
    }
    if (!isset($_SESSION)) {
        @session_start();
    }
    if (!empty($pageposts)) {
        foreach ($pageposts as $key => $rowCategories) {
            update_post_meta($rowCategories->ID, 'custom_order_type_snv_' . $no_order, $key);
        }
        $_SESSION['notices'] = array('type' => 'success', 'msg' => 'Order reset successfully.');
    }
    else {
        $_SESSION['notices'] = array('type' => 'error', 'msg' => 'Order reset data not found.');
    }
}



function fcpto_categoryParentChildTree($parent = 0, $spacing = '', $category_tree_array = '')
{
    $post_type = 'post';
    // phpcs:disable WordPress.Security.NonceVerification.Recommended
    if (isset($_GET['post_type'])) {
        //$post_type = sanitize_text_field($_GET['post_type']);
        $post_type = sanitize_text_field(wp_unslash($_GET['post_type']));
    }
    // phpcs:enable
    $no_order = '1';
    // phpcs:disable WordPress.Security.NonceVerification.Recommended
    if (isset($_GET['page'])) {
        $page_data = explode('-', sanitize_text_field(wp_unslash($_GET['page'])));
        if (end($page_data) != '') {
            $no_order = end($page_data);
        }
    }
    // phpcs:enable
    if (!is_array($category_tree_array))
        $category_tree_array = array();

    global $wpdb;

    // Prepare and fetch in one step
    $cache_key = 'fcpto_list_tree_' . md5($parent . '_' . $no_order . '_' . $post_type);
    $pageposts = wp_cache_get($cache_key, 'fcpto_list');

    if (false === $pageposts) {
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery
        $pageposts = $wpdb->get_results(
            $wpdb->prepare(
            "
                        SELECT {$wpdb->posts}.* 
                        FROM {$wpdb->posts}  
                        INNER JOIN {$wpdb->postmeta} ON ( {$wpdb->posts}.ID = {$wpdb->postmeta}.post_id ) 
                        WHERE 
                            {$wpdb->posts}.post_parent = %d 
                            AND {$wpdb->postmeta}.meta_key = %s
                            AND {$wpdb->posts}.post_type = %s
                            AND (
                                {$wpdb->posts}.post_status = 'publish' 
                                OR {$wpdb->posts}.post_status = 'future' 
                                OR {$wpdb->posts}.post_status = 'draft' 
                                OR {$wpdb->posts}.post_status = 'pending' 
                                OR {$wpdb->posts}.post_status = 'private'
                            )
                        GROUP BY {$wpdb->posts}.ID 
                        ORDER BY {$wpdb->postmeta}.meta_value+0 ASC
                        ",
            $parent,
            'custom_order_type_snv_' . $no_order,
            $post_type
        ),
            OBJECT
        );
        wp_cache_set($cache_key, $pageposts, 'fcpto_list', 3600);
    }

    // Fallback
    if (empty($pageposts)) {
        $cache_key_fallback = 'fcpto_list_tree_fallback_' . md5($parent . '_' . $post_type);
        $pageposts = wp_cache_get($cache_key_fallback, 'fcpto_list');

        if (false === $pageposts) {
            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery
            $pageposts = $wpdb->get_results(
                $wpdb->prepare(
                "
                            SELECT {$wpdb->posts}.* 
                            FROM {$wpdb->posts}  
                            INNER JOIN {$wpdb->postmeta} ON ( {$wpdb->posts}.ID = {$wpdb->postmeta}.post_id ) 
                            WHERE 
                                {$wpdb->posts}.post_parent = %d 
                                AND {$wpdb->posts}.post_type = %s
                                AND (
                                    {$wpdb->posts}.post_status = 'publish' 
                                    OR {$wpdb->posts}.post_status = 'future' 
                                    OR {$wpdb->posts}.post_status = 'draft' 
                                    OR {$wpdb->posts}.post_status = 'pending' 
                                    OR {$wpdb->posts}.post_status = 'private'
                                )
                            GROUP BY {$wpdb->posts}.ID 
                            ORDER BY {$wpdb->posts}.post_name ASC
                            ",
                $parent,
                $post_type
            ),
                OBJECT
            );
            wp_cache_set($cache_key_fallback, $pageposts, 'fcpto_list', 3600);
        }
    }


    if (!empty($pageposts)) {
        foreach ($pageposts as $rowCategories) {
            $category_tree_array[] = array("id" => $rowCategories->ID, "name" => $spacing . $rowCategories->post_title);
            $category_tree_array = fcpto_categoryParentChildTree($rowCategories->ID, '&nbsp;&nbsp;&nbsp;&nbsp;' . $spacing . '&#8212;&nbsp;', $category_tree_array);
        }
    }
    return $category_tree_array;
}
?>