<?php
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
function fcpto_ensure_default_custom_order_meta_all($no_order, $post_type)
{
    $meta_key_default = 'custom_order_type_snv_' . $no_order;

    // Get all posts of type pms_project (no limit)
    $projects = get_posts(array(
        'post_type' => $post_type,
        'posts_per_page' => -1,
        'post_status' => 'any',
        'fields' => 'ids',
    ));

    if (empty($projects)) {
        return;
    }

    foreach ($projects as $post_id) {
        $existing_value = get_post_meta($post_id, $meta_key_default, true);

        // If meta not exists or empty, set default
        if (empty($existing_value)) {
            update_post_meta($post_id, $meta_key_default, '0');
        }
    }
}
?>