<?php
// Exit if accessed directly.
if( ! defined( 'ABSPATH' ) ) exit;

/**
 * Title: Home
 * Slug: flexi-patterns/home
 * Categories: flexi-patterns
 */
?>
<!-- wp:group {"align":"wide","style":{"spacing":{"padding":{"top":"1.25rem","bottom":"1.25rem","left":"1.25rem","right":"1.25rem"}},"border":{"radius":"0.31rem"}},"backgroundColor":"accent","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide has-accent-background-color has-background" style="border-radius:0.31rem;padding-top:1.25rem;padding-right:1.25rem;padding-bottom:1.25rem;padding-left:1.25rem"><!-- wp:heading {"textAlign":"center"} -->
<h2 class="wp-block-heading has-text-align-center"><?php esc_html_e( 'Create your dream website today!', 'flexi-patterns' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><?php esc_html_e( 'Design and launch a stunning, user-friendly website with ease.', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons"><!-- wp:button -->
<div class="wp-block-button"><a class="wp-block-button__link wp-element-button" href="#"><?php esc_html_e( 'Learn more...', 'flexi-patterns' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"wide","style":{"spacing":{"padding":{"top":"1.25rem","bottom":"1.25rem","left":"1.25rem","right":"1.25rem"}},"border":{"width":"0.06rem","color":"#cfcabe","radius":"0.31rem"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide has-border-color" style="border-color:#cfcabe;border-width:0.06rem;border-radius:0.31rem;padding-top:1.25rem;padding-right:1.25rem;padding-bottom:1.25rem;padding-left:1.25rem"><!-- wp:columns {"align":"wide"} -->
<div class="wp-block-columns alignwide"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:image {"id":654,"width":"100px","height":"100px","scale":"cover","sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"50%","width":"0.06rem"}},"borderColor":"accent"} -->
<figure class="wp-block-image size-large is-resized has-custom-border"><img src="<?php echo esc_url( FLEXI_PATTERNS_URL . 'assets/images/placeholder-image.webp' ); ?>" alt="<?php esc_html_e( 'Placeholder', 'flexi-patterns' ); ?>" class="has-border-color has-accent-border-color wp-image-654" style="border-width:0.06rem;border-radius:50%;object-fit:cover;width:100px;height:100px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":4} -->
<h4 class="wp-block-heading"><?php esc_html_e( 'Customize options', 'flexi-patterns' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e( 'Lorem ipsum dolor sit amet, consectetur, adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore.', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:image {"id":654,"width":"100px","height":"100px","scale":"cover","sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"50%","width":"0.06rem"}},"borderColor":"accent"} -->
<figure class="wp-block-image size-large is-resized has-custom-border"><img src="<?php echo esc_url( FLEXI_PATTERNS_URL . 'assets/images/placeholder-image.webp' ); ?>" alt="<?php esc_html_e( 'Placeholder', 'flexi-patterns'); ?>" class="has-border-color has-accent-border-color wp-image-654" style="border-width:0.06rem;border-radius:50%;object-fit:cover;width:100px;height:100px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":4} -->
<h4 class="wp-block-heading"><?php esc_html_e( 'Unmatched Speed', 'flexi-patterns' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e( 'Lorem ipsum dolor sit amet, consectetur, adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore.', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:image {"id":654,"width":"100px","height":"100px","scale":"cover","sizeSlug":"large","linkDestination":"none","style":{"border":{"radius":"50%","width":"0.06rem"}},"borderColor":"accent"} -->
<figure class="wp-block-image size-large is-resized has-custom-border"><img src="<?php echo esc_url( FLEXI_PATTERNS_URL . 'assets/images/placeholder-image.webp' ); ?>" alt="<?php esc_html_e( 'Placeholder', 'flexi-patterns' ); ?>" class="has-border-color has-accent-border-color wp-image-654" style="border-width:0.06rem;border-radius:50%;object-fit:cover;width:100px;height:100px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":4} -->
<h4 class="wp-block-heading"><?php esc_html_e( 'SEO Friendly', 'flexi-patterns' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e( 'Lorem ipsum dolor sit amet, consectetur, adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore.', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"1.25rem","padding":{"top":"1.25rem","bottom":"1.25rem","left":"1.25rem","right":"1.25rem"}},"border":{"radius":"0.31rem"}},"backgroundColor":"accent","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide has-accent-background-color has-background" style="border-radius:0.31rem;padding-top:1.25rem;padding-right:1.25rem;padding-bottom:1.25rem;padding-left:1.25rem"><!-- wp:group {"align":"wide","layout":{"type":"constrained","contentSize":""}} -->
<div class="wp-block-group alignwide"><!-- wp:heading {"textAlign":"center","align":"wide","className":"wp-block-heading","style":{"spacing":{"padding":{"top":"1.25rem"}}},"textColor":"heading"} -->
<h2 class="wp-block-heading alignwide has-text-align-center has-heading-color has-text-color" style="padding-top:1.25rem"><?php esc_html_e( 'Craft a beautiful and effective website', 'flexi-patterns' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center"} -->
<p class="has-text-align-center"><?php esc_html_e( 'Build a professional website that is both functional and visually appealing.', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:columns {"align":"wide","style":{"spacing":[]}} -->
<div class="wp-block-columns alignwide"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:image {"sizeSlug":"full","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
<figure class="wp-block-image size-full has-custom-border"><img src="<?php echo esc_url( FLEXI_PATTERNS_URL . 'assets/images/placeholder-image.webp' ); ?>" alt="<?php esc_html_e( 'Placeholder', 'flexi-patterns' ); ?>" style="border-radius:8px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:group {"style":{"spacing":{"padding":{"left":"var:preset|spacing|medium","right":"var:preset|spacing|x-small"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:var(--wp--preset--spacing--x-small);padding-left:var(--wp--preset--spacing--medium)"><!-- wp:paragraph {"style":{"typography":{"letterSpacing":"2px"}},"fontSize":"x-small"} -->
<p class="has-x-small-font-size" style="letter-spacing:2px"><?php esc_html_e( '01', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:heading {"level":4,"className":"wp-block-heading","textColor":"heading"} -->
<h4 class="wp-block-heading has-heading-color has-text-color"><?php esc_html_e( 'Intuitive Visual Editing', 'flexi-patterns' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|primary"}}},"typography":{"fontStyle":"normal","fontWeight":"500"},"spacing":{"margin":{"top":"var:preset|spacing|small"}}},"fontSize":"small"} -->
<p class="has-link-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--small);font-style:normal;font-weight:500"><a href="#"><?php esc_html_e( 'Learn More', 'flexi-patterns' ); ?></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"align":"wide"} -->
<div class="wp-block-columns alignwide"><!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:group {"style":{"spacing":{"padding":{"right":"var:preset|spacing|x-small","left":"var:preset|spacing|medium"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:var(--wp--preset--spacing--x-small);padding-left:var(--wp--preset--spacing--medium)"><!-- wp:paragraph {"style":{"typography":{"letterSpacing":"2px"}},"fontSize":"x-small"} -->
<p class="has-x-small-font-size" style="letter-spacing:2px"><?php esc_html_e( '02', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:heading {"level":4,"className":"wp-block-heading","textColor":"heading"} -->
<h4 class="wp-block-heading has-heading-color has-text-color"><?php esc_html_e( 'Effortless Visual Design', 'flexi-patterns' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|primary"}}},"typography":{"fontStyle":"normal","fontWeight":"500"},"spacing":{"margin":{"top":"var:preset|spacing|small"}}},"fontSize":"small"} -->
<p class="has-link-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--small);font-style:normal;font-weight:500"><a href="#"><?php esc_html_e( 'Learn More', 'flexi-patterns' ); ?></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column -->
<div class="wp-block-column"><!-- wp:image {"sizeSlug":"full","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
<figure class="wp-block-image size-full has-custom-border"><img src="<?php echo esc_url( FLEXI_PATTERNS_URL . 'assets/images/placeholder-image.webp' ); ?>" alt="<?php esc_html_e( 'Placeholder', 'flexi-patterns' ); ?>" style="border-radius:8px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"align":"wide","style":{"spacing":[]}} -->
<div class="wp-block-columns alignwide"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:image {"sizeSlug":"full","linkDestination":"none","style":{"border":{"radius":"8px"}}} -->
<figure class="wp-block-image size-full has-custom-border"><img src="<?php echo esc_url( FLEXI_PATTERNS_URL . 'assets/images/placeholder-image.webp' ); ?>" alt="<?php esc_html_e( 'Placeholder', 'flexi-patterns' ); ?>" style="border-radius:8px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:group {"style":{"spacing":{"padding":{"left":"var:preset|spacing|medium","right":"var:preset|spacing|x-small"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group" style="padding-right:var(--wp--preset--spacing--x-small);padding-left:var(--wp--preset--spacing--medium)"><!-- wp:paragraph {"style":{"typography":{"letterSpacing":"2px"}},"fontSize":"x-small"} -->
<p class="has-x-small-font-size" style="letter-spacing:2px"><?php esc_html_e( '03', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:heading {"level":4,"className":"wp-block-heading","textColor":"heading"} -->
<h4 class="wp-block-heading has-heading-color has-text-color"><?php esc_html_e( 'Powerful Visual Editing Tools', 'flexi-patterns' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|primary"}}},"typography":{"fontStyle":"normal","fontWeight":"500"},"spacing":{"margin":{"top":"var:preset|spacing|small"}}},"fontSize":"small"} -->
<p class="has-link-color has-small-font-size" style="margin-top:var(--wp--preset--spacing--small);font-style:normal;font-weight:500"><a href="#"><?php esc_html_e( 'Learn More', 'flexi-patterns' ); ?></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"1.25rem","padding":{"top":"1.25rem","bottom":"1.25rem","left":"1.25rem","right":"1.25rem"}},"border":{"width":"0.06rem","color":"#cfcabe","radius":"0.31rem"}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide has-border-color" style="border-color:#cfcabe;border-width:0.06rem;border-radius:0.31rem;padding-top:1.25rem;padding-right:1.25rem;padding-bottom:1.25rem;padding-left:1.25rem"><!-- wp:group {"align":"wide","style":{"spacing":{"padding":{"bottom":"var:preset|spacing|x-small"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignwide" style="padding-bottom:var(--wp--preset--spacing--x-small)"><!-- wp:paragraph {"align":"center","style":{"typography":{"letterSpacing":"2px","textTransform":"uppercase"}},"textColor":"primary","fontSize":"x-small"} -->
<p class="has-text-align-center has-primary-color has-text-color has-x-small-font-size" style="letter-spacing:2px;text-transform:uppercase"><?php esc_html_e( 'Testimonials', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:heading {"textAlign":"center","align":"wide"} -->
<h2 class="wp-block-heading alignwide has-text-align-center"><?php esc_html_e( 'What our customers say about us', 'flexi-patterns' ); ?></h2>
<!-- /wp:heading --></div>
<!-- /wp:group -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|medium","left":"0rem"}}}} -->
<div class="wp-block-columns alignwide"><!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|xx-small","padding":{"right":"1.25rem"}}},"layout":{"type":"default"}} -->
<div class="wp-block-column" style="padding-right:1.25rem"><!-- wp:group {"style":{"spacing":{"padding":{"top":"1.25rem","bottom":"1.25rem","left":"1.25rem","right":"1.25rem"},"blockGap":"var:preset|spacing|xx-small"},"border":{"radius":"16px","width":"1px"},"dimensions":{"minHeight":"100%"}},"borderColor":"outline","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color has-outline-border-color" style="border-width:1px;border-radius:16px;min-height:100%;padding-top:1.25rem;padding-right:1.25rem;padding-bottom:1.25rem;padding-left:1.25rem"><!-- wp:group {"style":{"spacing":{"padding":{"bottom":"1.25rem"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group" style="padding-bottom:1.25rem"><!-- wp:image {"width":"100px","height":"100px","scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"border":{"width":"0.06rem","color":"#cfcabe","radius":"50%"}}} -->
<figure class="wp-block-image size-full is-resized has-custom-border"><img src="<?php echo esc_url( FLEXI_PATTERNS_URL . 'assets/images/placeholder-image.webp' ); ?>" alt="<?php esc_html_e( 'David Miller', 'flexi-patterns' ); ?>" class="has-border-color" style="border-color:#cfcabe;border-width:0.06rem;border-radius:50%;object-fit:cover;width:100px;height:100px"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"style":{"typography":{"fontSize":"1rem"}}} -->
<p style="font-size:1rem"><?php esc_html_e( 'David Miller', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"textColor":"neutral","fontSize":"small"} -->
<p class="has-neutral-color has-text-color has-small-font-size"><?php esc_html_e( 'Creative Director', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:heading {"level":4,"className":"wp-block-heading","style":{"spacing":{"margin":{"top":"var:preset|spacing|small"}}},"textColor":"heading"} -->
<h4 class="wp-block-heading has-heading-color has-text-color" style="margin-top:var(--wp--preset--spacing--small)"><?php esc_html_e( 'Top choice for quality!', 'flexi-patterns' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|xx-small"}}} -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"1.25rem","bottom":"1.25rem","left":"1.25rem","right":"1.25rem"},"blockGap":"var:preset|spacing|xx-small"},"border":{"radius":"16px","width":"1px"},"dimensions":{"minHeight":"100%"}},"borderColor":"outline","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color has-outline-border-color" style="border-width:1px;border-radius:16px;min-height:100%;padding-top:1.25rem;padding-right:1.25rem;padding-bottom:1.25rem;padding-left:1.25rem"><!-- wp:group {"style":{"spacing":{"padding":{"bottom":"1.25rem"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group" style="padding-bottom:1.25rem"><!-- wp:image {"width":"100px","height":"100px","scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"border":{"width":"0.06rem","color":"#cfcabe","radius":"50%"}}} -->
<figure class="wp-block-image size-full is-resized has-custom-border"><img src="<?php echo esc_url( FLEXI_PATTERNS_URL . 'assets/images/placeholder-image.webp' ); ?>" alt="<?php esc_html_e( 'James Smith', 'flexi-patterns' ); ?>" class="has-border-color" style="border-color:#cfcabe;border-width:0.06rem;border-radius:50%;object-fit:cover;width:100px;height:100px"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"style":{"typography":{"fontSize":"1rem"}}} -->
<p style="font-size:1rem"><?php esc_html_e( 'James Smith', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"textColor":"neutral","fontSize":"small"} -->
<p class="has-neutral-color has-text-color has-small-font-size"><?php esc_html_e( 'Social Media Lead', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:heading {"level":4,"className":"wp-block-heading","style":{"spacing":{"margin":{"top":"var:preset|spacing|small"}}},"textColor":"heading"} -->
<h4 class="wp-block-heading has-heading-color has-text-color" style="margin-top:var(--wp--preset--spacing--small)"><?php esc_html_e( 'Limitless design possibilities', 'flexi-patterns' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|medium","left":"var:preset|spacing|medium"}}}} -->
<div class="wp-block-columns alignwide"><!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|xx-small","padding":{"right":"1.25rem"}}}} -->
<div class="wp-block-column" style="padding-right:1.25rem"><!-- wp:group {"style":{"spacing":{"padding":{"top":"1.25rem","bottom":"1.25rem","left":"1.25rem","right":"1.25rem"},"blockGap":"var:preset|spacing|xx-small"},"border":{"radius":"16px","width":"1px"},"dimensions":{"minHeight":"100%"}},"borderColor":"outline","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color has-outline-border-color" style="border-width:1px;border-radius:16px;min-height:100%;padding-top:1.25rem;padding-right:1.25rem;padding-bottom:1.25rem;padding-left:1.25rem"><!-- wp:group {"style":{"spacing":{"padding":{"bottom":"1.25rem"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group" style="padding-bottom:1.25rem"><!-- wp:image {"width":"100px","height":"100px","scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"border":{"width":"0.06rem","color":"#cfcabe","radius":"50%"}}} -->
<figure class="wp-block-image size-full is-resized has-custom-border"><img src="<?php echo esc_url( FLEXI_PATTERNS_URL . 'assets/images/placeholder-image.webp' ); ?>" alt="<?php esc_html_e( 'Lisa Rodriguez', 'flexi-patterns' ); ?>" class="has-border-color" style="border-color:#cfcabe;border-width:0.06rem;border-radius:50%;object-fit:cover;width:100px;height:100px"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"style":{"typography":{"fontSize":"1rem"}}} -->
<p style="font-size:1rem"><?php esc_html_e( 'Lisa Rodriguez', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"textColor":"neutral","fontSize":"small"} -->
<p class="has-neutral-color has-text-color has-small-font-size"><?php esc_html_e( 'Marketing Coordinator', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:heading {"level":4,"className":"wp-block-heading","style":{"spacing":{"margin":{"top":"var:preset|spacing|small"}}},"textColor":"heading"} -->
<h4 class="wp-block-heading has-heading-color has-text-color" style="margin-top:var(--wp--preset--spacing--small)"><?php esc_html_e( 'Optimized for every device', 'flexi-patterns' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"blockGap":"var:preset|spacing|xx-small"}}} -->
<div class="wp-block-column"><!-- wp:group {"style":{"spacing":{"padding":{"top":"1.25rem","bottom":"1.25rem","left":"1.25rem","right":"1.25rem"},"blockGap":"var:preset|spacing|xx-small"},"border":{"radius":"16px","width":"1px"},"dimensions":{"minHeight":"100%"}},"borderColor":"outline","layout":{"type":"constrained"}} -->
<div class="wp-block-group has-border-color has-outline-border-color" style="border-width:1px;border-radius:16px;min-height:100%;padding-top:1.25rem;padding-right:1.25rem;padding-bottom:1.25rem;padding-left:1.25rem"><!-- wp:group {"style":{"spacing":{"padding":{"bottom":"1.25rem"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
<div class="wp-block-group" style="padding-bottom:1.25rem"><!-- wp:image {"width":"100px","height":"100px","scale":"cover","sizeSlug":"full","linkDestination":"none","style":{"border":{"width":"0.06rem","color":"#cfcabe","radius":"50%"}}} -->
<figure class="wp-block-image size-full is-resized has-custom-border"><img src="<?php echo esc_url( FLEXI_PATTERNS_URL . 'assets/images/placeholder-image.webp' ); ?>" alt="<?php esc_html_e( 'Leslie Wilson', 'flexi-patterns' ); ?>" class="has-border-color" style="border-color:#cfcabe;border-width:0.06rem;border-radius:50%;object-fit:cover;width:100px;height:100px"/></figure>
<!-- /wp:image -->

<!-- wp:group {"style":{"spacing":{"blockGap":"0"}},"layout":{"type":"flex","orientation":"vertical"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"style":{"typography":{"fontSize":"1rem"}}} -->
<p style="font-size:1rem"><?php esc_html_e( 'Leslie Wilson', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"textColor":"neutral","fontSize":"small"} -->
<p class="has-neutral-color has-text-color has-small-font-size"><?php esc_html_e( 'Content Manager', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:group -->

<!-- wp:heading {"level":4,"className":"wp-block-heading","style":{"spacing":{"margin":{"top":"var:preset|spacing|small"}}},"textColor":"heading"} -->
<h4 class="wp-block-heading has-heading-color has-text-color" style="margin-top:var(--wp--preset--spacing--small)"><?php esc_html_e( 'User friendly and simple', 'flexi-patterns' ); ?></h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p><?php esc_html_e( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->

<!-- wp:group {"align":"wide","style":{"spacing":{"padding":{"top":"1.25rem","bottom":"1.25rem","left":"1.25rem","right":"1.25rem"}},"border":{"radius":"0.31rem"}},"backgroundColor":"accent","layout":{"type":"default"}} -->
<div class="wp-block-group alignwide has-accent-background-color has-background" style="border-radius:0.31rem;padding-top:1.25rem;padding-right:1.25rem;padding-bottom:1.25rem;padding-left:1.25rem"><!-- wp:heading {"textAlign":"center","className":"wp-block-heading","style":{"typography":{"letterSpacing":"-1px"}},"textColor":"contrast"} -->
<h2 class="wp-block-heading has-text-align-center has-contrast-color has-text-color" style="letter-spacing:-1px"><?php esc_html_e( 'Start your own journey', 'flexi-patterns' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","textColor":"contrast"} -->
<p class="has-text-align-center has-contrast-color has-text-color"><?php esc_html_e( 'Take your journey to the next level!', 'flexi-patterns' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons"><!-- wp:button {"className":"is-style-swt-button-inverse"} -->
<div class="wp-block-button is-style-swt-button-inverse"><a class="wp-block-button__link wp-element-button" href="#"><?php esc_html_e( 'Get Started', 'flexi-patterns' ); ?></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group -->