<?php
/**
 * Functions for Flex Pricing for WooCommerce.
 *
 * @since 1.0.0
 * @package functions
 */

defined( 'ABSPATH' ) || exit;
if ( ! function_exists( 'wcfp_set_dynamic_prices_in_session' ) ) {
	/**
	 * Set dynamic prices in session.
	 *
	 * @param array $dynamic_prices dynamic prices.
	 *
	 * @since 1.0.0
	 */
	function wcfp_set_dynamic_prices_in_session( $dynamic_prices ) {
		if ( ! empty( $dynamic_prices ) && function_exists( 'WC' ) && WC()->session ) {
			WC()->session->set( 'wcfp_dynamic_prices', $dynamic_prices['prices'] );
		}
	}
}
if ( ! function_exists( 'wcfp_set_api_pricing_last_refreshed_date_in_session' ) ) {
	/**
	 * Set session value for interval.
	 *
	 * @param string $current_time Current time.
	 *
	 * @since 1.0.0
	 */
	function wcfp_set_api_pricing_last_refreshed_date_in_session( $current_time ) {
		if ( function_exists( 'WC' ) && WC()->session ) {
			WC()->session->set( 'api_pricing_last_refreshed_date', $current_time );
		}
	}
}
if ( ! function_exists( 'wcfp_get_dynamic_prices_from_session' ) ) {
	/**
	 * Dynamic prices for session.
	 *
	 * @since 1.0.0
	 */
	function wcfp_get_dynamic_prices_from_session() {
		$dynamic_prices = array();
		if ( function_exists( 'WC' ) && WC()->session ) {
			$dynamic_prices = WC()->session->get( 'wcfp_dynamic_prices' );
		}
		return $dynamic_prices;
	}
}
if ( ! function_exists( 'wcfp_get_api_pricing_last_refreshed_date_from_session' ) ) {
	/**
	 * Get last refreshed date.
	 *
	 * @since 1.0.0
	 */
	function wcfp_get_api_pricing_last_refreshed_date_from_session() {
		$api_pricing_last_refreshed_date = '';
		if ( function_exists( 'WC' ) && WC()->session ) {
			$api_pricing_last_refreshed_date = WC()->session->get( 'api_pricing_last_refreshed_date' );
		}
		return $api_pricing_last_refreshed_date;
	}
}
if ( ! function_exists( 'wcfp_check_connection_to_rust_api' ) ) {
	/**
	 * Check connection to RUST API.
	 *
	 * @since 1.0.0
	 */
	function wcfp_check_connection_to_rust_api() {
		$api_client = new wcfp_API_Client();
		$result     = $api_client->wcfp_fetch_dynamic_prices();
		if ( $result ) {
			return true;
		} else {
			return false;
		}
	}
}
