<?php
/**
 * WCFP_Settings.
 *
 * @since 1.0.0
 * @package WCFP_Settings
 */

defined( 'ABSPATH' ) || exit;
if ( ! class_exists( 'WCFP_Settings' ) ) {
	/**
	 * Admin Settings and configurations.
	 *
	 * @since 1.0.0
	 */
	class WCFP_Settings {
		/**
		 * Call for admin actions.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {
			add_filter( 'plugin_action_links_' . plugin_basename( dirname( __DIR__ ) . '/flex-pricing.php' ), array( __CLASS__, 'wcfp_add_settings_link' ) );
			add_action( 'wp_ajax_wcfp_test_connection_ajax', array( $this, 'wcfp_handle_wcfp_test_connection' ) );
			add_action( 'admin_notices', array( __CLASS__, 'wcfp_admin_notice__success' ) );
			add_action( 'admin_enqueue_scripts', array( __CLASS__, 'wcfp_admin_enqueue' ) );
		}
		public static function wcfp_admin_enqueue() {
			wp_enqueue_style( 'wcfp-admin-style', WCFP_URL . 'assets/backend-style.css', '', '1.0.0' );
			wp_enqueue_script( 'wcfp-admin-script', WCFP_URL . 'assets/backend-scripts.js', array( 'jquery' ), '1.0.0', true );
			wp_localize_script( 'wcfp-admin-script', 'wcfp_flex_pricing', array( 
					'ajaxurl'   => admin_url( 'admin-ajax.php' ),
					'nonce' => wp_create_nonce('wcfp_test_connection_action')
					) 
				);
		}
		/**
		 * Permalinks warning message.
		 *
		 * @since 1.0.0
		 */
		public static function wcfp_admin_notice__success() {
			if ( empty( get_option( 'permalink_structure' ) ) ) {
				?>
				<div class="notice notice-warning is-dismissible">
					<p><?php esc_html_e( 'Flex Pricing is not compatible with the "Plain" Permalinks setting. Please check your settings.', 'flex-pricing' ); ?></p>
				</div>
				<?php
			}
		}
		/**
		 * Settings fields registration.
		 *
		 * @since 1.0.0
		 */
		/**
		 * Plugins settings links.
		 *
		 * @param array $links Plugins settings links.
		 *
		 * @since 1.0.0
		 */
		public static function wcfp_add_settings_link( $links ) {
			$settings_url = esc_url( get_admin_url( null, 'admin.php?page=wc-settings&tab=wcfp-flex-pricing' ) );
			if ( ! $settings_url ) {
				$settings_url = '#'; // Fallback URL.
			}
			$settings_link = sprintf( '<a href="%s">%s</a>', $settings_url, esc_html__( 'Settings', 'flex-pricing' ) );
			array_unshift( $links, $settings_link );
			return $links;
		}
		/**
		 * Test API connection.
		 *
		 * @since 1.0.0
		 */
		public function wcfp_handle_wcfp_test_connection() {
			check_ajax_referer( 'wcfp_test_connection_action', 'nonce' );
			$api_client = new wcfp_API_Client();
			$result     = $api_client->wcfp_fetch_dynamic_prices();
			if ( !is_wp_error($result) ) {
				$message = esc_html__( 'Successfully connected with Flex Pricing.', 'flex-pricing' );
				wp_send_json_success($message);
			} else {
				$message = esc_html__( 'Failed to connect with Flex Pricing.', 'flex-pricing' );
				wp_send_json_error($message);
			}
		}
	}
	new WCFP_Settings();
}
