<?php
/**
 * WCFP_Setting_Fields.
 *
 * @since 1.0.0
 * @package WCFP_Setting_Fields
 */

defined( 'ABSPATH' ) || exit;
if ( ! class_exists( 'WCFP_Setting_Fields' ) ) {
	/**
	 * Setting Fields.
	 *
	 * @since 1.0.0
	 */
	class WCFP_Setting_Fields {
		/**
		 * Generate settings tabs.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {
			add_filter( 'woocommerce_settings_tabs_array', array( __CLASS__, 'wcfp_woocommerce_settings_tabs_array' ), 99, 1 );
			add_filter( 'woocommerce_sections_wcfp-flex-pricing', array( __CLASS__, 'wcfp_section_flex_pricing'), 99 );
			add_action( 'woocommerce_settings_save_wcfp-flex-pricing', array( __CLASS__, 'wcfp_settings_save'), 10 );
		}
		public static function wcfp_woocommerce_settings_tabs_array( $settings_tabs ) {
			$settings_tabs['wcfp-flex-pricing'] = esc_html__( 'Flex Pricing', 'flex-pricing' );
			return $settings_tabs;
		}
		public static function wcfp_section_flex_pricing() {
			$settings = self::wcfp_get_custom_settings();
			WC_Admin_Settings::output_fields( $settings );
			?>
			<div class="wrap">
				<h3><?php esc_html_e('Next Steps for Your WooCommerce Integration', 'flex-pricing'); ?></h3>
				<p><?php esc_html_e('After successfully connecting your WooCommerce store to Flex Pricing, here\'s what happens next:', 'flex-pricing'); ?></p>
				<ol>
				<li><strong><?php esc_html_e('Wait for synchronization (approximately 15 minutes)', 'flex-pricing'); ?></strong><br>
				<?php esc_html_e('Your WooCommerce products will be imported to Flex Pricing. The "Products" section inside your Flex Pricing dashboard will populate automatically once the connection is successful.', 'flex-pricing'); ?></li>
				<li><strong><?php esc_html_e('Create pricing rules', 'flex-pricing'); ?></strong><br>
				<?php esc_html_e('Once synchronization is complete, visit the ', 'flex-pricing'); ?><a href="https://flexpricing.com/app/pricing-rules"><?php esc_html_e('"Pricing Rules" section', 'flex-pricing'); ?></a><?php esc_html_e(' in your Flex Pricing dashboard to create rules based on your business needs.', 'flex-pricing'); ?></li>
				<li><strong><?php esc_html_e('Assign rules to products', 'flex-pricing'); ?></strong><br>
				<?php esc_html_e('Apply your pricing rules to specific products in the ', 'flex-pricing'); ?><a href="https://flexpricing.com/app/products"><?php esc_html_e('"Products" section', 'flex-pricing'); ?></a> <?php esc_html_e('of your Flex Pricing dashboard.', 'flex-pricing'); ?></li>
				</ol>
				<p><?php esc_html_e('Need help getting started? Check out our ', 'flex-pricing'); ?><a href="https://www.youtube.com/@FlexPricing"><?php esc_html_e('video tutorials', 'flex-pricing'); ?></a> <?php esc_html_e('or visit the ', 'flex-pricing'); ?><a href="https://flexpricing.com/app/support"><?php esc_html_e('Support Center', 'flex-pricing'); ?></a> <?php esc_html_e('inside your Flex Pricing dashboard.', 'flex-pricing'); ?></p>
				<p><?php esc_html_e('Connection issues? If your Flex Pricing dashboard still shows "Not Connected" after completing setup here, please ', 'flex-pricing' ); ?><a href="https://flexpricing.com/app/support"><?php esc_html_e('contact our support team', 'flex-pricing' ); ?></a> <?php esc_html_e('for assistance.', 'flex-pricing' ); ?></p>
				<p><a href="https://flexpricing.com/app/dashboard" class="button button-primary"><?php esc_html_e('Go to Flex Pricing Dashboard', 'flex-pricing' ); ?></a></p>
				<button class="button" id="wcfp-test-btn"><?php esc_html_e( 'Test Connection', 'flex-pricing' ); ?></button>
				<span class="dashicons dashicons-update wcfp-loading"></span>
				<p class="notice wcfp_notice"></p>
			</div>
			<?php
		}
		public static function wcfp_get_custom_settings() {
				$settings = array(
					array(
						'title' => esc_html__( 'Flex Pricing Settings', 'flex-pricing' ),
						'type'  => 'title',
						'id'    => 'wcfp_settings',
					),
					array(
						'title' => esc_html__( 'Store API Key', 'flex-pricing' ),
						'type'  => 'text',
						'id'    => 'wcfp_api_key',
						'desc' => 'To retrieve your "Store API Key":<br />- New users: <a href="https://flexpricing.com/signup/">Create an account</a> on FlexPricing<br />- Existing users: <a href="https://flexpricing.com/login/">Log in</a> to your FlexPricing account<br />Once logged in, navigate to <a href="https://flexpricing.com/app/store-settings">Store Settings</a> in your dashboard to find your "Store API Key".',
					),
				);
				if ( isset( $_COOKIE['wcfp_test_mode'] ) ) {
					$settings[] = array(
						'title' => esc_html__( 'Pricing API URL', 'flex-pricing' ),
						'type'  => 'text',
						'id'    => 'wcfp_pricing_api_url',
					);
				}
				$settings[] = array(
						'title' => esc_html__( 'Pricing Refresh Interval', 'flex-pricing' ),
						'type'  => 'text',
						'id'    => 'wcfp_pricing_refresh_interval',
					);
				if ( isset( $_SERVER['SERVER_NAME'] ) && 0 === strcmp( 'localhost', filter_var( wp_unslash( $_SERVER['SERVER_NAME'] ) ) ) ) {
					$settings[] = array(
						'title' => esc_html__( 'Test IP Address', 'flex-pricing' ),
						'type'  => 'text',
						'id'    => 'wcfp_test_ip_address',
					);
				}
				$settings[] = array(
					'type'  => 'sectionend',
					'id'    => 'wcfp_settings',
				);
			return $settings;
		}
		public static function wcfp_settings_save() {
			global $current_section;
			$tab_id   = 'wcfp-flex-pricing';
			$settings = self::wcfp_get_custom_settings();
			WC_Admin_Settings::save_fields( $settings );
			$test_connection_result = get_transient( 'wcfp_test_connection_result' );
			if ( $test_connection_result ) {
				$class = $test_connection_result['success'] ? 'notice-success wcfp_success' : 'notice-error wcfp_error';
				printf(
					'<div class="notice wcfp_notice %s"><p>%s</p></div>',
					esc_attr( $class ),
					esc_html( $test_connection_result['message'] )
				);
				delete_transient( 'wcfp_test_connection_result' );  // Clear the transient after displaying the message.
			}
			if ( ! isset( $_COOKIE['wcfp_test_mode'] ) ) {
				update_option( 'wcfp_pricing_api_url', 'https://partner-api.flexpricing.com/store-prices-for-user' );
				update_option( 'wcfp_pricing_refresh_interval', '5' );
			}
			if ( $current_section ) {
				/**
				 * Save rush fee settings
				 * 
				 * @since 1.0.0
				 */
				do_action( 'woocommerce_update_options_' . $tab_id . '_' . $current_section );
			}
		}
	}
	new WCFP_Setting_Fields();
}
