<?php
/**
 * Plugin Name: Flex Pricing
 * Description: Create and deploy dynamic pricing rules for your WooCommerce store products. With Flex Pricing you can display unique prices based on specific shopper attributes, in real time. Use this plugin to maximize your revenue and conversion rates.
 * Version: 1.0.1
 * Author: Flex Pricing, LLC
 * Author URI: https://flexpricing.com/
 * Developer: Flex Pricing, LLC
 * Developer URI: https://woocommerce.com/
 * Text Domain: flex-pricing
 * Domain Path: /languages
 * WC requires at least: 3.5
 * WC tested up to: 9.5.2
 * Requires at least: 5.4
 * Requires PHP: 7.4
 * Tested up to	6.8
 * Copyright: © 2025, Flex Pricing, LLC.
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 *
 * @package extension
 **/

defined( 'ABSPATH' ) || exit;
if ( ! defined( 'WCFP_URL' ) ) {
	define( 'WCFP_URL', plugin_dir_url( __FILE__ ) );
}
if ( ! defined( 'WCFP_DIR' ) ) {
	define( 'WCFP_DIR', plugin_dir_path( __FILE__ ) );
}
if ( ! class_exists( 'WCFP_Flex_Pricing' ) ) {
	/**
	 * Flex Pricing main class.
	 *
	 * @since 1.0.0
	 */
	class WCFP_Flex_Pricing {
		/**
		 * Load plugin functionality.
		 *
		 * @since 1.0.0
		 */
		public function __construct() {
			if ( ! function_exists( 'is_plugin_active_for_network' ) ) {
				include_once ABSPATH . '/wp-admin/includes/plugin.php';
			}
			/**
			 * Check if WooCommerce is installed.
			 *
			 * @since 1.0.0
			 */
			if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ), true ) || is_plugin_active_for_network( 'woocommerce/woocommerce.php' ) ) {
				add_action( 'plugins_loaded', array( __CLASS__, 'wcfp_init' ) );
				add_action( 'before_woocommerce_init', array( __CLASS__, 'wcfp_woocommerce_hpos_compatible' ) );
			} else {
				add_action( 'admin_notices', array( __CLASS__, 'wcfp_admin_notice' ) );
			}
		}
		/**
		 * WooCommerce plgin missing warning.
		 *
		 * @since 1.0.0
		 */
		public static function was_admin_notice() {
			global $pagenow;
			if ( 'plugins.php' === $pagenow ) {
				$class   = esc_attr( 'notice notice-error is-dismissible' );
				$message = esc_html_x( 'Flex Pricing for WooCommerce needs WooCommerce to be installed and active.', 'Admin notice for WooCommerce', 'flex-pricing' );
				printf( '<div class="%1$s"><p>%2$s</p></div>', esc_html( $class ), esc_html( $message ) );
			}
		}
		/**
		 * Declare HPOS compatibility.
		 *
		 * @since 1.0.0
		 */
		public static function wcfp_woocommerce_hpos_compatible() {
			if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
				\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
			}
		}
		/**
		 * Load plugin files.
		 *
		 * @since 1.0.0
		 */
		public static function wcfp_init() {
			include_once WCFP_DIR . 'includes/functions.php';
			include_once WCFP_DIR . 'includes/class-wcfp-api-client.php';
			if ( is_admin() ) {
				include_once WCFP_DIR . 'includes/class-wcfp-settings.php';
				require_once WCFP_DIR . 'includes/class-wcfp-setting-fields.php';
			} else {
				include_once WCFP_DIR . 'includes/class-wcfp-pricing-manager.php';
			}
		}
		public static function wcfp_admin_notice() {
			global $pagenow;
			if ( 'plugins.php' == $pagenow ) {
				$class = 'notice notice-error is-dismissible';
				$message = esc_html__('Flex Pricing plugin needs WooCommerce to be installed and active.', 'flex-pricing');
				printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr($class), esc_html($message) );
			}
		}
	}
	new WCFP_Flex_Pricing();
}
