<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class FLASHFOLDERS_Usage {
    
    
    public static function get_usage( $attachment_id ) {
        $cache = get_post_meta( $attachment_id, '_mm_usage_cache', true );
        if ( $cache && isset( $cache['timestamp'] ) && ( time() - $cache['timestamp'] ) < 3600 ) {
            return $cache['usage'];
        }

        $usage = self::find_usage( $attachment_id );
        
        update_post_meta( $attachment_id, '_mm_usage_cache', array(
            'timestamp' => time(),
            'usage' => $usage,
        ) );

        return $usage;
    }

    private static function find_usage( $attachment_id ) {
        global $wpdb;

        self::debug_log( "=== FLASHFOLDERS Usage Search START for attachment ID: {$attachment_id} ===" );

        $usage = array(
            'posts' => array(),
            'featured' => array(),
            'product_gallery' => array(),
            'total_count' => 0,
        );

        $url = wp_get_attachment_url( $attachment_id );
        if ( ! $url ) {
            self::debug_log( "ERROR: Could not get URL for attachment {$attachment_id}" );
            return $usage;
        }

        $basename = basename( $url );
        self::debug_log( "Attachment URL: {$url}" );
        self::debug_log( "Basename: {$basename}" );

        // Array to avoid duplicates
        $added_post_ids = array();

        // ===================================================
        // 1. FEATURED IMAGE
        // ===================================================
        self::debug_log( "Searching for featured images..." );
        
        $featured = $wpdb->get_results( 
            $wpdb->prepare(
                "SELECT DISTINCT pm.post_id 
                 FROM {$wpdb->postmeta} pm
                 INNER JOIN {$wpdb->posts} p ON pm.post_id = p.ID
                 WHERE pm.meta_key = '_thumbnail_id' 
                 AND pm.meta_value = %d
                 AND p.post_status IN ('publish', 'draft', 'private', 'pending')",
                $attachment_id
            )
        );
        
        self::debug_log( "Featured results: " . count( $featured ) . " found" );

        foreach ( $featured as $meta ) {
            $post = get_post( $meta->post_id );
            
            if ( $post && ! in_array( $post->ID, $added_post_ids, true ) ) {
                self::debug_log( "Found featured in post ID: {$meta->post_id}" );
                
                $usage['featured'][] = array(
                    'id' => $post->ID,
                    'title' => $post->post_title ?: __( '(no title)', 'flashfolders' ),
                    'type' => $post->post_type,
                    'status' => $post->post_status,
                    'url' => get_permalink( $post->ID ),
                    'edit_url' => get_edit_post_link( $post->ID, 'raw' ),
                    'usage_type' => 'featured_image'
                );
                $added_post_ids[] = $post->ID;
            }
        }

        // ===================================================
        // 2. PRODUCT GALLERY (WooCommerce)
        // ===================================================
        if ( class_exists( 'WooCommerce' ) ) {
            self::debug_log( "Searching for product galleries..." );
            
            $galleries = $wpdb->get_results( 
                $wpdb->prepare(
                    "SELECT DISTINCT pm.post_id, pm.meta_value 
                     FROM {$wpdb->postmeta} pm
                     INNER JOIN {$wpdb->posts} p ON pm.post_id = p.ID
                     WHERE pm.meta_key = '_product_image_gallery' 
                     AND pm.meta_value LIKE %s
                     AND p.post_status IN ('publish', 'draft', 'private', 'pending')",
                    '%' . $wpdb->esc_like( (string) $attachment_id ) . '%'
                )
            );
            
            self::debug_log( "Gallery results: " . count( $galleries ) . " found" );

            foreach ( $galleries as $meta ) {
                $gallery_ids = array_filter( array_map( 'intval', explode( ',', $meta->meta_value ) ) );
                
                if ( in_array( $attachment_id, $gallery_ids, true ) ) {
                    $post = get_post( $meta->post_id );
                    
                    if ( $post && ! in_array( $post->ID, $added_post_ids, true ) ) {
                        self::debug_log( "Confirmed gallery usage in product ID: {$meta->post_id}" );
                        
                        $usage['product_gallery'][] = array(
                            'id' => $post->ID,
                            'title' => $post->post_title ?: __( '(no title)', 'flashfolders' ),
                            'type' => $post->post_type,
                            'status' => $post->post_status,
                            'url' => get_permalink( $post->ID ),
                            'edit_url' => get_edit_post_link( $post->ID, 'raw' ),
                            'usage_type' => 'product_gallery'
                        );
                        $added_post_ids[] = $post->ID;
                    }
                }
            }
        } else {
            self::debug_log( "WooCommerce not active, skipping gallery search" );
        }

        // ===================================================
        // 3. POST CONTENT
        // ===================================================
        self::debug_log( "Searching in post_content..." );
        
        // Search for both full URL and basename
        $posts = $wpdb->get_results( 
            $wpdb->prepare(
                "SELECT DISTINCT p.ID, p.post_title, p.post_type, p.post_status 
                 FROM {$wpdb->posts} p
                 WHERE p.post_status IN ('publish', 'draft', 'private', 'pending') 
                 AND (p.post_content LIKE %s OR p.post_content LIKE %s)",
                '%' . $wpdb->esc_like( $url ) . '%',
                '%' . $wpdb->esc_like( $basename ) . '%'
            )
        );
        
        self::debug_log( "Content results: " . count( $posts ) . " found" );

        foreach ( $posts as $post ) {
            if ( ! in_array( $post->ID, $added_post_ids, true ) ) {
                self::debug_log( "Found in content: post_id={$post->ID}" );
                
                $usage['posts'][] = array(
                    'id' => $post->ID,
                    'title' => $post->post_title ?: __( '(no title)', 'flashfolders' ),
                    'type' => $post->post_type,
                    'status' => $post->post_status,
                    'url' => get_permalink( $post->ID ),
                    'edit_url' => get_edit_post_link( $post->ID, 'raw' ),
                    'usage_type' => 'content'
                );
                $added_post_ids[] = $post->ID;
            }
        }

        // ===================================================
        // TOTAL COUNT
        // ===================================================
        $usage['total_count'] = count( $usage['posts'] ) + 
                                count( $usage['featured'] ) + 
                                count( $usage['product_gallery'] );

        self::debug_log( "=== FLASHFOLDERS Usage Search COMPLETE ===" );
        self::debug_log( "Total found: {$usage['total_count']}" );
        self::debug_log( "  - Featured: " . count( $usage['featured'] ) );
        self::debug_log( "  - Gallery: " . count( $usage['product_gallery'] ) );
        self::debug_log( "  - Content: " . count( $usage['posts'] ) );

        return $usage;
    }

    public static function clear_cache( $attachment_id ) {
        delete_post_meta( $attachment_id, '_mm_usage_cache' );
    }
}