<?php
/**
 * Plugin Name: FlashFolders
 * Description: A faster way to organize and browse your WordPress media library
 * Version: 1.0.0
 * Requires at least: 6.1
 * Tested up to: 6.9
 * Requires PHP: 7.4
 * Author: Silverwings
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: flashfolders
 * Domain Path: /languages
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Define plugin constants
define( 'FLASHFOLDERS_VERSION', '1.0.0' );
define( 'FLASHFOLDERS_PLUGIN_FILE', __FILE__ );
define( 'FLASHFOLDERS_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'FLASHFOLDERS_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'FLASHFOLDERS_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

/**
 * Main plugin class
 */
class FlashFolder {
    
    private static $instance = null;

    public static function get_instance() {
        if ( null === self::$instance ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        $this->load_dependencies();
        $this->init_hooks();
    }

    private function load_dependencies() {
        require_once FLASHFOLDERS_PLUGIN_DIR . 'includes/class-loader.php';
        require_once FLASHFOLDERS_PLUGIN_DIR . 'includes/class-media.php';
        require_once FLASHFOLDERS_PLUGIN_DIR . 'includes/class-folders.php';
        require_once FLASHFOLDERS_PLUGIN_DIR . 'includes/class-usage.php';
        require_once FLASHFOLDERS_PLUGIN_DIR . 'includes/class-rest.php';
        
        if ( is_admin() ) {
            require_once FLASHFOLDERS_PLUGIN_DIR . 'admin/class-admin.php';
            require_once FLASHFOLDERS_PLUGIN_DIR . 'admin/enqueue.php';
        }
    }

    private function init_hooks() {
        register_activation_hook( FLASHFOLDERS_PLUGIN_FILE, array( $this, 'activate' ) );
        register_deactivation_hook( FLASHFOLDERS_PLUGIN_FILE, array( $this, 'deactivate' ) );
        
        add_action( 'init', array( $this, 'init' ) );
    }

    public function activate() {
        FLASHFOLDERS_Folders::register_taxonomy();
        flush_rewrite_rules();
        
        $default_options = array(
            'version' => FLASHFOLDERS_VERSION,
            'installed_at' => current_time( 'mysql' ),
        );
        add_option( 'FLASHFOLDERS_options', $default_options );
    }

    public function deactivate() {
        flush_rewrite_rules();
    }

    public function init() {
        FLASHFOLDERS_Folders::register_taxonomy();
        FLASHFOLDERS_REST::init();
        
        if ( is_admin() ) {
            FLASHFOLDERS_Admin::init();
        }
    }

}


function FLASHFOLDERS_init() {
    return FlashFolder::get_instance();
}

FLASHFOLDERS_init();
