<?php
if ( ! defined( 'ABSPATH' ) ) exit;

add_action( 'admin_enqueue_scripts', 'flashfolder_enqueue_assets' );

function flashfolder_enqueue_assets( $hook ) {
    if ( $hook !== 'media_page_flashfolders' ) {
        return;
    }

    $asset_file = FLASHFOLDERS_PLUGIN_DIR . 'assets/js/build/index.asset.php';
    
    if ( file_exists( $asset_file ) ) {
        $asset = include $asset_file;
        
        wp_enqueue_script(
            'flashfolder-app',
            FLASHFOLDERS_PLUGIN_URL . 'assets/js/build/index.js',
            $asset['dependencies'],
            $asset['version'],
            true
        );

        // CSS principale
        wp_enqueue_style(
            'flashfolder-app',
            FLASHFOLDERS_PLUGIN_URL . 'assets/css/admin.css',
            array( 'wp-components' ),
            FLASHFOLDERS_VERSION
        );
        
        // ✨ NUOVO: CSS responsive come file separato
        wp_enqueue_style(
            'flashfolder-responsive',
            FLASHFOLDERS_PLUGIN_URL . 'assets/css/responsive.css',
            array( 'flashfolder-app' ), // Dipende dal CSS principale
            FLASHFOLDERS_VERSION,
            'all' // Media query: all (default)
        );
        
    } else {
        // Development fallback
        wp_enqueue_script(
            'flashfolder-app',
            FLASHFOLDERS_PLUGIN_URL . 'assets/js/index.js',
            array( 'wp-element', 'wp-components', 'wp-api-fetch', 'wp-i18n' ),
            FLASHFOLDERS_VERSION,
            true
        );

        // CSS principale
        wp_enqueue_style(
            'flashfolder-app',
            FLASHFOLDERS_PLUGIN_URL . 'assets/css/admin.css',
            array(),
            FLASHFOLDERS_VERSION
        );
        
        // ✨ NUOVO: CSS responsive come file separato
        wp_enqueue_style(
            'flashfolder-responsive',
            FLASHFOLDERS_PLUGIN_URL . 'assets/css/responsive.css',
            array( 'flashfolder-app' ),
            FLASHFOLDERS_VERSION,
            'all'
        );
    }

    wp_localize_script( 'flashfolder-app', 'flashfolderData', array(
        'apiUrl' => rest_url( 'media-manager/v1' ),
        'nonce' => wp_create_nonce( 'wp_rest' ),
    ) );
}