<?php
/**
* Plugin Name: FindAroo
* Description: Don't hunt through your admin menu ever again
* Version: 1.1
* Requires at least: 6.8
* Requires PHP: 7.2
* Author: Greg Goad
* Author URI:  https://greggoad.net/
* License: GPL v2
* License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/

namespace FINDAROO;
if(!defined('ABSPATH')){die();}
if(!is_admin()){return;}
add_action( 'admin_menu', function(){
	add_menu_page(
        "Find Aroo",
		'Find-Aroo',
		'read',
		'find-aroo',//slug
		'',//callback
		'dashicons-search',// icon
		2
    );
} );
add_action('admin_enqueue_scripts',function(){
	wp_enqueue_script('find-aroo',plugin_dir_url( __FILE__ ) . 'find-aroo.js', ['jquery'],'1.0',['in_footer'=>true]);
	wp_enqueue_style('find-aroo',plugin_dir_url( __FILE__ ) . 'find-aroo.css',[],'1.0');
});


add_action('admin_head',function(){
    echo "<style>
#adminmenu #toplevel_page_find-aroo a{
    pointer-events:none;
}
#adminmenu #toplevel_page_find-aroo:not(.findaroo-initialized):active:before{
    content:'Still Loading... Please Wait';
	position:absolute;
	left:calc(100% + 2px);
	top:8px;
	white-space:nowrap;
	background-color:rgba(170,100,100,1);
	border-radius:5px;
	padding:3px;
	color:white;
	pointer-events:none;
}
</style>";
    
});