(function($){
	$(document).on('ready',function(){
		var $li=$('#toplevel_page_find-aroo');
		var $icon=$li.find('.wp-menu-image');
		var $name=$li.find('.wp-menu-name');
		$li[0].classList.add('findaroo-initialized');
		
		var nameText=$name[0].textContent;
		
		var fromAdmin=false;
		
		$('#adminmenu li:not(#toplevel_page_find-aroo)').on('click',function(){
			fromAdmin=true;
		});
		$('#toplevel_page_find-aroo a').css('pointer-events','auto');
		
		var activated=false;
		$li[0].onclick=function(e){
			e.preventDefault();
			e.cancelBubble=true;
			if(!activated){
				Activate();
			}else if(e.target.tagName !== "INPUT"){
				Deactivate();
			}
		}
		document.body.addEventListener('click',function(){
			if(fromAdmin){
				fromAdmin=false; return;
			}
			fromAdmin=false;
			Deactivate();
		});
		
		addEventListener('keydown',function(e){
			if(e.key === 'Escape'){Deactivate();}
		});
		
		function Activate(){
			activated=true;
			if(document.body.offsetWidth > 782){
				if(document.getElementById('adminmenu').clientWidth < 120){
					document.getElementById("collapse-menu").querySelector('button').click();
				}
			}
			$icon[0].classList.remove('dashicons-search');
			$icon[0].classList.add('dashicons-admin-collapse');
			$name.html('<input>');
			var $inp=$name.children('input');
			$inp[0].focus();
			$inp[0].oninput=function(){
				var t=this;
				ResetHides();
				
				if(!this.value){return;}
				document.querySelectorAll('li.menu-top').forEach(function(e){
					if(e.id === 'toplevel_page_find-aroo'){
						return;
					}
					var name=e.querySelector('.wp-menu-name').textContent;
					if(!name.toLowerCase().includes(t.value.toLowerCase())){
						e.style.display='none';
					}
					var sub=e.querySelector('ul.wp-submenu');
					if(sub){
						var list=e.querySelectorAll('ul.wp-submenu>li:not([aria-hidden="true"])');
						var cap=[];
						list.forEach(function(ee){
							var eeText=ee.querySelector('a').textContent.toLowerCase();
							if(!eeText.includes(t.value.toLowerCase())){
								
							}else{
								cap.push(eeText);
								ee.classList.add('find-aroo-sub-found');
							}
						});
						if(cap.length){
							e.style.removeProperty('display');
							e.setAttribute('data-find-aroo-child', cap.join(' - '));
							e.classList.add('find-aroo-has-child');
							
						}
					}
				});
			};
			
		}
		
		function Deactivate(){
			
			activated=false;
			$icon[0].classList.add('dashicons-search');
			$icon[0].classList.remove('dashicons-admin-collapse');
			$name.html(nameText);
			ResetHides();
		}
		
		function ResetHides(){
			$('li.menu-top').css('display','').removeAttr('data-find-aroo-child').removeClass('find-aroo-has-child');
			$('li.menu-top ul.wp-submenu>li:not([aria-hidden="true"])').removeClass('find-aroo-sub-found');
			
		}
	
	});
})(jQuery)