<?php
/**
 * Find Missing More Tags
 *
 * @package           FindMissingMoreTags
 * @author            Tom McFarlin
 * @copyright         2024 Tom McFarlin
 * @license           GPL-2.0-or-later
 *
 * @wordpress-plugin
 * Plugin Name:       Find Missing More Tags
 * Plugin URI:        https://github.com/tommcfarlin/find-missing-more-tags
 * Description:       Helps content editors identify posts missing the &lt;!--more--&gt; tag.
 * Version:           1.0.0
 * Requires at least: 6.0
 * Requires PHP:      8.0
 * Tested up to:      6.9
 * Author:            Tom McFarlin
 * Author URI:        https://tommcfarlin.com
 * Text Domain:       find-missing-more-tags
 * Domain Path:       /languages
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 */

declare(strict_types=1);

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Plugin constants.
define( 'FMMT_VERSION', '1.0.0' );
define( 'FMMT_PLUGIN_FILE', __FILE__ );
define( 'FMMT_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'FMMT_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'FMMT_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

/**
 * Autoloader for plugin classes.
 *
 * @param string $class_name The fully-qualified class name.
 */
spl_autoload_register(
	function ( string $class_name ): void {
		$namespace = 'FindMissingMoreTags\\';

		if ( strpos( $class_name, $namespace ) !== 0 ) {
			return;
		}

		$relative_class = substr( $class_name, strlen( $namespace ) );
		$file_name      = 'class-' . strtolower( str_replace( '_', '-', $relative_class ) ) . '.php';
		$file_path      = FMMT_PLUGIN_DIR . 'includes/' . $file_name;

		if ( file_exists( $file_path ) ) {
			require_once $file_path;
		}
	}
);

/**
 * Initialize the plugin.
 *
 * @return void
 */
function fmmt_init(): void {
	\FindMissingMoreTags\Plugin::get_instance();
}
add_action( 'plugins_loaded', 'fmmt_init' );
