/**
 * Find Missing More Tags - Admin JavaScript
 *
 * Handles tab switching and UI interactions.
 *
 * @package FindMissingMoreTags
 */

( function() {
	'use strict';

	/**
	 * Initialize when DOM is ready.
	 */
	document.addEventListener( 'DOMContentLoaded', function() {
		initAccessibility();
	} );

	/**
	 * Initialize accessibility enhancements.
	 */
	function initAccessibility() {
		const tabs = document.querySelectorAll( '.fmmt-tab' );

		tabs.forEach( function( tab ) {
			// Handle keyboard navigation.
			tab.addEventListener( 'keydown', function( event ) {
				if ( event.key === 'Enter' || event.key === ' ' ) {
					event.preventDefault();
					tab.click();
				}
			} );
		} );
	}
} )();
