<?php
/**
 * This file includes all the plugin settings, constants, and notices
 */

 /******************************************************************************
 *
 * Plugin Settings
 *
 * This section registers the plugin settings in the WordPress database to
 * allow the repetitive use of set variables for this plugin.
 *
 ******************************************************************************/
function swsffs_settings()
{
  register_setting( 'swsffs_settings_group', 'swsffs_support_email' );
  register_setting( 'swsffs_settings_group', 'swsffs_client_name' );
  register_setting( 'swsffs_settings_group', 'swsffs_chat' );
}
add_action( 'admin_init', 'swsffs_settings' );

 /******************************************************************************
 *
 * Construct the admin menu
 *
 * This section builds the admin sidebar menu structure
 *
 ******************************************************************************/
function swsffs_page_menu()
{
  add_menu_page('Finally Free Support', 'Support', 'read', 'swsffs', 'swsffs_dashboard_page', 'dashicons-sos', 2);
  add_submenu_page('swsffs', 'Free Support', 'Dashboard', 'read', 'swsffs');
  add_submenu_page('swsffs', 'New Ticket', 'New Ticket', 'read', 'swsffs-new-ticket', 'swsffs_new_ticket_page');
  add_submenu_page('swsffs', 'Book a Call', 'Book a Call', 'read', 'swsffs-book-a-call', 'swsffs_booking_page');
  add_submenu_page('swsffs', 'Resources', 'Resourses', 'read', 'swsffs-resources', 'swsffs_resources_page');
  add_submenu_page('swsffs', 'Settings', 'Settings', 'read', 'swsffs-settings', 'swsffs_settings_page');
}
add_action('admin_menu', 'swsffs_page_menu' );

 /******************************************************************************
 *
 * Include the Page content
 *
 * This section includes the page content functions
 *
 ******************************************************************************/
require_once('pages/book-a-call.php');
require_once('pages/dashboard.php');
require_once('pages/resources.php');
require_once('pages/new-ticket.php');
require_once('pages/settings.php');

/*******************************************************************************
 *
 * Notices
 *
 * This section adds the admin area notices depending on set conditions.
 *
 ******************************************************************************/
function swsffs_authentication_alert()
{
  if (get_option('swsffs_support_email') == false)
  {
    echo '<div class="notice notice-error is-dismissible"><p><strong>NOTICE:</strong> Your support plugin has been activated but you have not finished the setup yet. <a href="admin.php?page=swsffs-settings">Please complete the setup process.</a></p></div>';
  }
}
add_action('admin_notices', 'swsffs_authentication_alert');

/*******************************************************************************
 *
 * Plugin Links
 *
 * This section adds additional links to the WordPress plugins area
 *
 ******************************************************************************/
function swsffs_custom_plugin_row_meta( $links, $file ) {

	if ( strpos( $file, 'sws_support_plugin.php' ) !== false ) {
		$new_links = array(
				'support'    => '<a href="https://secure.stoutewebsolutions.com/supporttickets.php" target="_blank" aria-label="Visit premium customer support">'.__('Premium Support', 'swsffs').'</a>',
		);

		$links = array_merge( $links, $new_links );
	}

	return $links;
}
add_filter( 'plugin_row_meta', 'swsffs_custom_plugin_row_meta', 10, 2 );

function swsffs_add_sws_action_links ( $actions, $plugin_file ) {
  static $plugin;
  if (!isset($plugin)) {
    $plugin = plugin_basename( plugin_dir_path( dirname( __FILE__) ) . 'sws_support_plugin.php' );
  }
  if ($plugin == $plugin_file) {
    $settings = array(
      'settings'  => '<a href="'.admin_url('admin.php?page=swsffs-settings').'">'.__('Settings', 'swsffs').'</a>',
    );
    $support = array(
      'support'   => '<a href="https://www.facebook.com/groups/finallyfreesupport/" target="_blank">'.__('Support', 'swsffs').'</a>',
    );
    $actions = array_merge($support, $actions);
    $actions = array_merge($settings, $actions);
  }
  return $actions;
}
add_filter( 'plugin_action_links', 'swsffs_add_sws_action_links', 10, 5 );

/*******************************************************************************
 *
 * Live Chat Settings
 *
 * This section adds the chat script to all admin area pages if the "Turn Live
 * Chat On" option has been enabled on the settings page.
 *
 ******************************************************************************/
function swsffs_live_chat()
{
  if (isset($_GET['page']) && $_GET['page'] !== 'swsffs-settings') {
    if (get_option('swsffs_chat') == '1')
    {
      wp_enqueue_script('swsffs_live_chat', plugin_dir_url(dirname(__FILE__)) . 'admin/js/chat.js', array(), '1.0', true );
    }
  }
}
add_action('admin_enqueue_scripts', 'swsffs_live_chat');

/*******************************************************************************
 *
 * Recommended Plugins Section
 *
 * This section adds all the recommended free plugins for WordPress websites
 * using the TGM Required Plugin class. All pulled from the .org repo.
 *
 ******************************************************************************/
require_once dirname( __FILE__ ) . '/class-tgm-plugin-activation.php';
function swsffs_register_required_plugins()
{
  $plugins = array(
    array(
      'name'        => 'WordPress SEO by Yoast',
			'slug'        => 'wordpress-seo',
      'is_callable' => 'wpseo_int',
			'required'    => false,
    ),
    array(
      'name'        => 'Hotjar for WordPress',
      'slug'        => 'sws-hotjar',
      'required'    => false,
    ),
    array(
      'name'        => 'Broken Link Checker',
      'slug'        => 'broken-link-checker',
      'required'    => false,
    ),
    array(
      'name'        => 'Imagify',
      'slug'        => 'imagify',
      'required'    => false,
    ),
    array(
      'name'        => 'WP Help',
      'slug'        => 'wp-help',
      'required'    => false,
    )
  );
  $config = array(
    'id'           => 'swsffs',
		'default_path' => '',
		'menu'         => 'swsffs-recommended-plugins',
		'parent_slug'  => 'plugins.php',
		'capability'   => 'manage_options',
		'has_notices'  => false,
		'dismissable'  => true,
		'dismiss_msg'  => '',
		'is_automatic' => false,
		'message'      => '',
    'strings'      => array(
      'page_title'  => __( 'Install Recommended Plugins', 'swsffs' ),
      'menu_title'  => __( 'Recommended', 'swsffs' ),
      'return'      => __( 'Return to Recommended Plugins Installer', 'swsffs' ),
    ),
  );
  tgmpa( $plugins, $config );
}
add_action( 'tgmpa_register', 'swsffs_register_required_plugins' );
