<?php
/**
 * This file includes the "Settings" page contents.
 */

 function swsffs_settings_page()
 {
   if (isset( $_GET['action']) && $_GET['action'] == 'auth' && $_POST['swsffs_support_email'] !== null)
   {
     // Save Email as "swsffs_support_email"
     if (is_email($_POST['swsffs_support_email']))
     {
       if (get_option('swsffs_support_email') !== false)
       {
         update_option('swsffs_support_email', sanitize_email($_POST['swsffs_support_email']));
       } else {
         add_option('swsffs_support_email', sanitize_email($_POST['swsffs_support_email']));
       }
       // Save Name as "swsffs_client_name"
       if (get_option('swsffs_client_name') !== false)
       {
         update_option('swsffs_client_name', sanitize_text_field($_POST['swsffs_client_name']));
       } else {
         add_option('swsffs_client_name', sanitize_text_field($_POST['swsffs_client_name']));
       }
       // Save chat option
       if (get_option('swsffs_chat') !== false)
       {
         update_option('swsffs_chat', sanitize_text_field($_POST['swsffs_chat']));
       } else {
         add_option('swsffs_chat', sanitize_text_field($_POST['swsffs_chat']));
       }
       echo '<div class="notice notice-success is-dismissible"><p>Settings updated successfully.</p></div>';
     } else {
       echo '<div class="notice notice-error is-dismissible"><p>You did not enter a valid email address.</p></div>';
     }
   }
   ?>
   <div class="wrap">
     <h1>Finally Free Support <span style="font-size:0.5em;">Provided by: <a href="https://www.stoutewebsolutions.com/" title="WordPress Support" target="_BLANK">Stoute Web Solutions</a></span></h1>
     <?php settings_errors(); ?>
     <div id="settings" class="panel">
       <h2>Settings</h2>
       <p>Please enter the information you'd like to use for your support tickets.</p>
       <p>If you don't have an account yet it's easy to <a href="https://secure.stoutewebsolutions.com/clientarea.php" target="_blank">create a new account</a>. It's free.</p>
       <form method="post" action="admin.php?page=swsffs-settings&action=auth">
         <?php settings_fields('swsffs_settings_group');?>
         <?php do_settings_sections('swsffs_settings_group');?>
         <table class="form-table">
           <tr valign="top">
             <th scope"row">Email Address</th>
             <td><input type="email" name="swsffs_support_email" size="98" <?php if (get_option('swsffs_support_email') !== false) {?>value="<?php esc_html_e(get_option('swsffs_support_email'));?>"<?php } ?> required/></td>
           </tr>
           <tr valign="top">
             <th scope="row">First and Last Name</th>
             <td><input type="text" name="swsffs_client_name" size="98" <?php if (get_option('swsffs_client_name') !== false) {?>value="<?php esc_html_e(get_option('swsffs_client_name'));?>"<?php } ?> required/></td>
           </tr>
           <tr valign="top">
             <th scope="row">Enable Live Chat</th>
             <td><input type="checkbox" name="swsffs_chat" value="1" <?php checked( '1', get_option('swsffs_chat') ); ?>/> Check box to enable.</td>
           </tr>
         </table>
         <button class="button-primary" type="submit">Save Support Information</button>
       </form>
     </div>
   </div>
   <?php
   include_once(dirname(dirname(dirname(__FILE__))).'/admin/css/inline-style.php');
 }
