<?php
/**
 * This file includes all the contents for the new ticket page
 */

function swsffs_new_ticket_page()
{
  if ($_GET['action'] == 'open' && $_POST['subject'] != null)
  {
    $to       = 'swsffs@stoutewebsolutions.com';
    $subject  = sanitize_text_field($_POST['subject']);
    $body     = sanitize_textarea_field($_POST['message']);
    $headers  = array(
      'From: '.get_option('swsffs_client_name').' <'.get_option('swsffs_support_email').'>',
      'Reply-To: '.get_option('swsffs_client_name').' <'.get_option('swsffs_support_email').'>',
    );

    $result = wp_mail( $to, $subject, $body, $headers );

    if ($result == true )
    {
      // Ticket Opened Notice
      echo '<div class="notice notice-success is-dismissible"><p>Support ticket successfully submitted. You will receive an email notification as soon as our team replies.</p></div>';
    } else {
      echo '<div class="notice notice-error is-dismissible"><p>Something went wrong. Please check your WordPress mail function. <a href="https://secure.stoutewebsolutions.com/submitticket.php">Open a ticket manually.</a></p></div>';
    }
  }
  ?>
  <div class="wrap">
    <h1>Finally Free Support <span style="font-size:0.5em;">Provided by: <a href="https://www.stoutewebsolutions.com/" title="WordPress Support" target="_BLANK">Stoute Web Solutions</a></span></h1>
    <?php settings_errors(); ?>
    <div id="new-ticket" class="panel">
      <h2>Open a Support Ticket</h2>
      <?php if (get_option('swsffs_support_email') == false ) {?>
      <p>Please <a href="admin.php?page=swsffs-settings">complete plugin setup</a> first.</p>
    <?php } else { ?>
      <p>We understand that you might need additional support for your request and we recommend opening a support ticket to resolve this issue.</p>
      <form method="post" action="admin.php?page=swsffs-new-ticket&action=open">
        <table class="form-table">
          <tr valign="top">
            <th scope="row">Subject</th>
            <td><input type="text" name="subject" size="98" required/></td>
          </tr>
          <tr valign="top">
            <th scope="row">Message</th>
            <td valign="top"><textarea name="message" rows="22" cols="98" required></textarea></td>
          </tr>
        </table>
        <button class="button-primary" type="submit">Open new ticket</button>
      </form>
    <?php } ?>
    </div>
  </div>
  <?php
  include_once(dirname(dirname(dirname(__FILE__))).'/admin/css/inline-style.php');
}
