<?php
/**
 * Plugin Name: File URL Replacer for Contact Form 7
 * Plugin URI: https://bonnyelangbam.com/plugins/file-url-replacer-for-contact-form-7
 * Description: Automatically replaces Contact Form 7 file field tags with clickable download URLs in email notifications. Files are permanently saved to WordPress Media Library.
 * Version: 1.0.0
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * Author: Bonny Elangbam
 * Author URI: https://profile.wordpress.org/bonnyelangbam
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: file-url-replacer-for-contact-form-7
 * Requires Plugins: contact-form-7
 * Domain Path: /languages
 * 
 * @package File_URL_Replacer_For_CF7
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}

/**
 * Current plugin version.
 */
define('FUR_CF7_VERSION', '1.0.0');

/**
 * Plugin base name.
 */
define('FUR_CF7_BASENAME', plugin_basename(__FILE__));

/**
 * Plugin directory path.
 */
define('FUR_CF7_PATH', plugin_dir_path(__FILE__));

/**
 * Plugin directory URL.
 */
define('FUR_CF7_URL', plugin_dir_url(__FILE__));

/**
 * Check if Contact Form 7 is active
 */
function fur_cf7_check_cf7_active()
{
    if (!is_plugin_active('contact-form-7/wp-contact-form-7.php') && !function_exists('wpcf7')) {
        add_action('admin_notices', 'fur_cf7_cf7_missing_notice');
        deactivate_plugins(FUR_CF7_BASENAME);
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- This is checking activation status, not processing form data
        if (isset($_GET['activate'])) {
            unset($_GET['activate']);
        }
    }
}
add_action('admin_init', 'fur_cf7_check_cf7_active');

/**
 * Admin notice if Contact Form 7 is not active
 */
function fur_cf7_cf7_missing_notice()
{
    ?>
    <div class="notice notice-error">
        <p><?php esc_html_e('File URL Replacer for Contact Form 7 requires Contact Form 7 to be installed and activated.', 'file-url-replacer-for-contact-form-7'); ?>
        </p>
    </div>
    <?php
}

/**
 * Include the main plugin class.
 */
require_once FUR_CF7_PATH . 'includes/class-file-url-replacer-for-cf7.php';

/**
 * Initialize the plugin.
 */
function fur_cf7_init()
{
    $plugin = new File_URL_Replacer_For_CF7();
    $plugin->init();
}
add_action('plugins_loaded', 'fur_cf7_init');

/**
 * Activation hook.
 */
function fur_cf7_activate()
{
    // Check minimum PHP version
    if (version_compare(PHP_VERSION, '7.4', '<')) {
        deactivate_plugins(FUR_CF7_BASENAME);
        wp_die(
            esc_html__('File URL Replacer for Contact Form 7 requires PHP 7.4 or higher.', 'file-url-replacer-for-contact-form-7'),
            esc_html__('Plugin Activation Error', 'file-url-replacer-for-contact-form-7'),
            array('back_link' => true)
        );
    }

    // Check if Contact Form 7 is active
    if (!is_plugin_active('contact-form-7/wp-contact-form-7.php') && !function_exists('wpcf7')) {
        deactivate_plugins(FUR_CF7_BASENAME);
        wp_die(
            esc_html__('File URL Replacer for Contact Form 7 requires Contact Form 7 to be installed and activated.', 'file-url-replacer-for-contact-form-7'),
            esc_html__('Plugin Activation Error', 'file-url-replacer-for-contact-form-7'),
            array('back_link' => true)
        );
    }
}
register_activation_hook(__FILE__, 'fur_cf7_activate');

/**
 * Deactivation hook.
 */
function fur_cf7_deactivate()
{
    // Cleanup if needed
}
register_deactivation_hook(__FILE__, 'fur_cf7_deactivate');
