<?php
/**
 * @package Fight On
 * @version 1.1
 */
/*
Plugin Name: Fight On
Description: A clone of the popular Hello Dolly plugin.  When activated you will see a random lyric from the <cite>WMU fight song</cite> in the upper right of your admin screen on every page.
Author: Kyle Wilson
Version: 1.0
Author URI: http://kyledwilson.com
*/

function wmu_fight_on_get_lyric() {
	/** These are the lyrics to the WMU fight song */
	$lyrics = "Fight on, fight on for Western;
Take the ball, make a score, win the game!
Onward for the Brown and Gold;
Push ‘em back, push ‘em back, bring us fame!
Fight on, fight on for Western;
Over one, over all, we will reign!
Fight, Broncos fight!
Fight with all your might!
Western win this game!";

	// Split into lines
	$lyrics = explode( "\n", $lyrics );

	// Get a random line
	return wptexturize( $lyrics[ mt_rand( 0, count( $lyrics ) - 1 ) ] );
}

// Echo the chosen line
function wmu_fight_on() {
	$chosen = wmu_fight_on_get_lyric();
	$lang   = '';
	if ( 'en_' !== substr( get_user_locale(), 0, 3 ) ) {
		$lang = ' lang="en"';
	}

	printf(
		'<p id="wmu"><span class="screen-reader-text">%s </span><span dir="ltr"%s>%s</span></p>',
		__( 'Quote from WMU Fight Song: ' ),
		$lang,
		$chosen
	);
}

// Execute the function when admin_notices action is called
add_action( 'admin_notices', 'wmu_fight_on' );

// CSS to position the lyric
function wmu_fight_on_css() {
	echo "
	<style type='text/css'>
	#wmu {
		float: right;
		padding: 5px 10px;
		margin: 0;
		font-size: 12px;
		line-height: 1.6666;
		font-style: italic;
	}
	.rtl #wmu {
		float: left;
	}
	.block-editor-page #wmu {
		display: none;
	}
	@media screen and (max-width: 782px) {
		#wmu,
		.rtl #wmu {
			float: none;
			padding-left: 0;
			padding-right: 0;
		}
	}
	</style>
	";
}

add_action( 'admin_head', 'wmu_fight_on_css' );
