<?php
/**
 * @wordpress-plugin
 * Plugin Name: 	feeCOMPASS rankings
 * Plugin URI:		https://demo-blog.feecompass.com
 * Description:     Plugin allows to include an intelligent product ranking into your blog. Ranking is inserted via a simple shortcode [ feecompass ]
 * Author:          innect feeCOMPASS
 * Author URI:		https://feecompass.com
 * Version: 		1.0.1
 * Text Domain:		feecompass-rankings
 * Domain Path:		/languages
 */

defined( 'ABSPATH' ) or die( 'No script kiddies please!' ); // Avoid direct file request

/**
 * Plugin constants. This file is procedural coding style for initialization of
 * the plugin core and definition of plugin configuration.
 */
if (defined('WPFC_PATH')) return;
define('WPFC_FILE', __FILE__);
define('WPFC_PATH', dirname(WPFC_FILE));
define('WPFC_SLUG', basename(WPFC_PATH));
define('WPFC_INC',	trailingslashit(path_join(WPFC_PATH, 'inc')));
define('WPFC_MIN_PHP', '5.6.0'); // Minimum of PHP 5.3 required for autoloading and namespacing
define('WPFC_MIN_WP', '4.8.0'); // Minimum of WordPress 5.0 required
define('WPFC_NS', 'innect\\FC');
define('WPFC_DB_PREFIX', 'wpfc'); // The table name prefix wp_{prefix}
define('WPFC_OPT_PREFIX', 'wpfc'); // The option name prefix in wp_options
//define('WPFC_TD', ''); This constant is defined in the core class. Use this constant in all your __() methods
//define('WPFC_VERSION', ''); This constant is defined in the core class
//define('WPFC_DEBUG', true); This constant should be defined in wp-config.php to enable the Base::debug() method

// Check PHP Version and print notice if minimum not reached, otherwise start the plugin core
require_once(WPFC_INC . "others/" . (version_compare(phpversion(), WPFC_MIN_PHP, ">=") ? "start.php" : "fallback-php-version.php"));