<?php
namespace innect\FC\menu;
use innect\FC\base;
use innect\FC\general;

defined('ABSPATH') or die('No script kiddies please!'); // Avoid direct file request

/**
 * Creates a WordPress backend menu page and demontrates a React component (public/src/admin.js).
 */
class Page extends base\Base {
    const COMPONENT_ID = WPFC_SLUG . '-component';

    public function admin_menu() {
        $pluginName = general\Core::getInstance()->getPluginData()['Name'];
        add_menu_page($pluginName, $pluginName, 'manage_options', self::COMPONENT_ID, [
            $this,
            'feecompass_options_page'
        ]);
//         add_action( 'admin_menu', [$this, 'feecompass_add_admin_menu'] );
        add_action( 'admin_init', [$this, 'feecompass_settings_init'] );
    }

    function feecompass_settings_init(  ) {
        $pluginName = general\Core::getInstance()->getPluginData()['Name'];
        register_setting( 'feecompass', 'feecompass_settings',
            ['sanitize_callback'=>[$this, 'feecompass_settings_sanitize'] ]);
        add_settings_section(
            $pluginName . '_section',
            __( 'API Settings', 'feecompass-rankings' ),
            [$this, 'feecompass_settings_section_callback'],
            'feecompass'
        );

        add_settings_field(
            'clientid',
            __( 'Blog identifier', 'feecompass-rankings' ),
            [$this, 'feecompass_clientid_render'],
            'feecompass',
            $pluginName . '_section'
        );

        add_settings_field(
            'apikey',
            __( 'API key', 'feecompass-rankings' ),
            [$this, 'feecompass_apikey_render'],
            'feecompass',
            $pluginName . '_section'
        );
    }

    function feecompass_settings_sanitize($inputs) {
        return $inputs;
    }

    function feecompass_clientid_render(  ) {
        $options = get_option( 'feecompass_settings' );
        ?>
        <input type='text' name='feecompass_settings[clientid]' value='<?php echo $options['clientid']; ?>'>
        <?php
    }

    function feecompass_apikey_render(  ) {
        $options = get_option( 'feecompass_settings' );
        ?>
        <input type='text' name='feecompass_settings[apikey]' value='<?php echo $options['apikey']; ?>'>
    <?php
    }

    function feecompass_settings_section_callback(  ) {
        /* echo __( 'Ustawienia dostępowe API', 'feecompass-rankings' ); */
    }

    function feecompass_options_page(  ) {
        $title = __('Admin page feeCOMPASS', 'feecompass-rankings');
        ?>
        <form action='options.php' method='post'>

            <h2><?php echo($title); ?></h2>

            <?php
            settings_fields( 'feecompass' );
            do_settings_sections( 'feecompass' );
            submit_button();
            ?>

        </form>
        <?php
    }

}
