<?php
namespace innect\FC\general;

use innect\FC\base;
use innect\FC\menu;
use innect\FC\rest;
use Ahc\Jwt\JWT;

defined('ABSPATH') or die('No script kiddies please!'); // Avoid direct file request


// Include files, where autoloading is not possible, yet
require_once WPFC_INC . 'base/Core.class.php';
// require_once WPFC_INC . 'shortcode/iframe.php';

/**
 * Singleton core class which handles the main system for plugin. It includes
 * registering of the autoloader, all hooks (actions & filters) (see base\Core class).
 */
class Core extends base\Core {
    /**
     * Singleton instance.
     */
    private static $me;

    /**
     * The main service.
     *
     * @see rest\Service
     */
    private $service;

    private $defaults;
    /**
     * Application core constructor.
     */
    protected function __construct() {
        parent::__construct();
        $defaults =
        // Register all your before init hooks here
        add_action('plugins_loaded', [$this, 'updateDbCheck']);
        }

    /**
     * The init function is fired even the init hook of WordPress. If possible
     * it should register all hooks to have them in one place.
     */
    public function init() {
        $this->service = new rest\Service();
        $options = $this->getOptions();
        if (is_array($options) && array_key_exists('apikey', $options) && array_key_exists('clientid', $options)) {
            $this->jwt = new JWT([$options['clientid'] => $options['apikey']], 'HS256', 12*3600, 10);
        } else {
            $this->jwt = NULL;
        }

        // Register all your hooks here
        add_action('rest_api_init', [$this->getService(), 'rest_api_init']);
        add_action('admin_enqueue_scripts', [$this->getAssets(), 'admin_enqueue_scripts']);
        add_action('wp_enqueue_scripts', [$this->getAssets(), 'wp_enqueue_scripts']);
        add_action('admin_menu', [new menu\Page(), 'admin_menu']);

        add_filter('override_load_textdomain', [new Localization(), 'override_load_textdomain'], 10, 3);
        add_filter('load_script_translation_file', [new Localization(), 'load_script_translation_file'], 10, 3);
        add_shortcode( 'feecompass', [$this, 'feecompass_func'] );
    }

    public function feecompass_func( $atts ){
        $options = $this->getOptions();
        $apikey = $options['apikey'];
        $tokenString = "invalid token";
        if ($this->jwt != NULL && array_key_exists('clientid', $options) && array_key_exists('apikey', $options) ) {
            $clientid = $options['clientid'];
            $token = $this->jwt->encode(['clientid' => $clientid], ['kid' => $clientid]);
            $tokenString = (string)$token;
        }
        $urlPath = "";
        if (is_array($atts) && array_key_exists('profile', $atts)) {
            $urlPath = $atts['profile'];
        }
        $iframeHost = "https://iframe.feecompass.com";
        if (is_array($atts) && array_key_exists('host', $atts)) {
            $iframeHost = $atts['host'];
        }
        $content = <<<EOD
        <div style>
<iframe src="$iframeHost/$urlPath?token=$tokenString" width="100%" scrolling="no" style="height:500px overflow: hidden; margin: 0px" id="iFrameResizer0"></iframe>
</div>
EOD;
        return $content;
    }

    private function getOptions() {
        $options = get_option( 'feecompass_settings' );
        $defaults = array(
                'clientid' => 'wordpress-demo',
                'apikey' => 'feecompass_wordpress_demo'
            );
        return wp_parse_args($options, $defaults);
    }

    /**
     * Get the service.
     *
     * @returns rest\Service
     */
    public function getService() {
        return $this->service;
    }

    /**
     * Get singleton core class.
     *
     * @returns Core
     */
    public static function getInstance() {
        return !isset(self::$me) ? (self::$me = new Core()) : self::$me;
    }
}
