
jQuery(document).ready(function($){
    var mediaUploader;

    $('#wpfv_select_video').on('click', function(e) {
        e.preventDefault();

        if (mediaUploader) {
            mediaUploader.open();
            return;
        }

        mediaUploader = wp.media({
            title: 'Select or Upload MP4 Video',
            button: {
                text: 'Use this video'
            },
            library: {
                type: 'video'
            },
            multiple: false
        });

        mediaUploader.on('select', function() {
            var attachment = mediaUploader.state().get('selection').first().toJSON();
            if (attachment.url.endsWith('.mp4')) {
                $('#wpfv_video_url').val(attachment.url);
                $('#wpfv_remove_video').show();
            } else {
                alert('Only .mp4 files are allowed.');
            }
        });

        mediaUploader.open();
    });

    $('#wpfv_remove_video').on('click', function() {
        $('#wpfv_video_url').val('');
        $(this).hide();
    });
});
