<?php
/**
 * Plugin Name:       Featured Video Link Preview Lite
 * Plugin URI:        https://alightmedia.net
 * Description:       Adds support for iMessage Video Previews when sending links to your site. Falls back to featured image if no video set.
 * Author:            Alight Media
 * Version:           1.0.2
 * License:           GPLv2+
 * Text Domain:       featured-video-link-preview-lite
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.html
 * Requires PHP:      7.3
 * Requires at least: 5.4
 */

// Add meta box in the sidebar under Featured Image
function wpfv_add_meta_box() {
    add_meta_box(
        'wpfv_meta_box',
        'Featured Video',
        'wpfv_meta_box_callback',
        ['post', 'page'],
        'side',
        'low'
    );
}
add_action('add_meta_boxes', 'wpfv_add_meta_box');

// Enqueue media scripts for admin
function wpfv_enqueue_media_scripts($hook) {
    if (in_array($hook, ['post.php', 'post-new.php'])) {
        wp_enqueue_media();
wp_enqueue_script(
    'wpfv-admin-js',
    plugin_dir_url(__FILE__) . 'wpfv-admin.js',
    ['jquery'],
    filemtime(plugin_dir_path(__FILE__) . 'wpfv-admin.js'),
    true
);
    }
}
add_action('admin_enqueue_scripts', 'wpfv_enqueue_media_scripts');

// Render the meta box UI
function wpfv_meta_box_callback($post) {
    
    $value = get_post_meta($post->ID, '_wpfv_video_url', true);
    wp_nonce_field('wpfv_save_meta_box_data', 'wpfv_meta_box_nonce');
    ?>
    <p><input type="text" id="wpfv_video_url" name="wpfv_video_url" value="<?php echo esc_attr($value); ?>" style="width:100%" /></p>
    <p>
        <button type="button" class="button" id="wpfv_select_video">Select Video</button>
        <button type="button" class="button" id="wpfv_remove_video" style="display:<?php echo $value ? 'inline-block' : 'none'; ?>;">Remove</button>
    </p>
    <p><em>Must be a local .mp4 file uploaded through the Media Library.</em></p>
    <?php
}

// Save the video URL
function wpfv_save_meta_box_data($post_id) {
if (
    !isset($_POST['wpfv_meta_box_nonce']) || 
    !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['wpfv_meta_box_nonce'])), 'wpfv_save_meta_box_data')
) return;
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;

    if (isset($_POST['wpfv_video_url'])) {
        update_post_meta($post_id, '_wpfv_video_url', esc_url_raw(wp_unslash($_POST['wpfv_video_url'])));
    }
}
add_action('save_post', 'wpfv_save_meta_box_data');

// Inject og:video tag into <head>
function wpfv_output_video_tag() {
    if (!is_singular()) return;

    global $post;
    $video = get_post_meta($post->ID, '_wpfv_video_url', true);
    if (!$video) return;

    echo '<meta property="og:video" content="' . esc_url($video) . '" />' . "\n";
}
add_action('wp_head', 'wpfv_output_video_tag', 5);

// Fallback og:image using Featured Image if no SEO plugin sets one
function wpfv_output_image_fallback() {
    if (!is_singular()) return;

    global $post;

    if (defined('WPSEO_VERSION')) return;

    if (has_post_thumbnail($post)) {
        $image = get_the_post_thumbnail_url($post, 'full');
        if ($image) {
            echo '<meta property="og:image" content="' . esc_url($image) . '" />' . "\n";
        }
    }
}
add_action('wp_head', 'wpfv_output_image_fallback', 5);
