jQuery(document).ready(function($){
    $('.fpct-carousel').each(function(){
        var $wrap = $(this);
        var autoplay = $wrap.data('fpct-autoplay') === true || $wrap.data('fpct-autoplay') === 'true';
        var items = parseInt( $wrap.data('fpct-items'), 10 ) || 4;

        // if owlCarousel not loaded, bail
        if ( typeof $wrap.owlCarousel !== 'function' ) {
            return;
        }

        // Initialize carousel if not already initialized
        if ( !$wrap.hasClass('fpct-initialized') ) {
            $wrap.owlCarousel({
                loop: true,
                margin: 12,
                nav: true,
                dots: false,
                autoplay: autoplay,
                responsive: {
                    0: { items: 1 },
                    480: { items: 2 },
                    768: { items: 3 },
                    992: { items: items }
                },
                navText: ['<span class="fpct-nav prev">‹</span>','<span class="fpct-nav next">›</span>']
            });
            $wrap.addClass('fpct-initialized');
        }
    });
});
