<?php
/**
 * Plugin Name:     Featured Products Carousel by Tag
 * Plugin URI:      https://d3veloper.es/featured-products-carousel-tag/
 * Description:     Muestra productos de WooCommerce con la etiqueta featured o destacado en un carrusel responsive con OwlCarousel2.
 * Version:         1.0.0
 * Author:          Daniel Esparza
 * Author URI:      https://d3veloper.es/
 * License:         GPLv2 or later
 * Text Domain:     featured-products-carousel-tag
 * Domain Path:     /languages
 *
 * @package featured-products-carousel-tag
 * @since   1.0.0
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Constants
if ( ! defined( 'fpct_plugin_path' ) ) {
    define( 'fpct_plugin_path', plugin_dir_path( __FILE__ ) );
}
if ( ! defined( 'fpct_plugin_url' ) ) {
    define( 'fpct_plugin_url', plugin_dir_url( __FILE__ ) );
}

// Register activation/deactivation hooks (always)
register_activation_hook( __FILE__, 'fpct_activate_plugin' );
register_deactivation_hook( __FILE__, 'fpct_deactivate_plugin' );

function fpct_activate_plugin() {
    if ( get_option( 'fpct_enabled' ) === false ) {
        add_option( 'fpct_enabled', 1 );
    }
}

function fpct_deactivate_plugin() {
    // keep options by default
}

// Load admin loader only when in admin or WP_CLI
if ( is_admin() || ( defined( 'WP_CLI' ) && WP_CLI ) ) {
    require_once fpct_plugin_path . 'includes/featured-products-carousel-tag-loader.php';
}

// Load public functions (shortcode, assets registration)
require_once fpct_plugin_path . 'public/featured-products-carousel-tag-functions.php';

// Add plugin action links (Settings / About)
add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'fpct_plugin_settings', 10, 1 );
function fpct_plugin_settings( $actions ) {
    array_unshift( $actions, '<a href="' . esc_url( get_admin_url( null, 'admin.php?page=featured-products-carousel-tag' ) ) . '">' . esc_html__( 'Settings', 'featured-products-carousel-tag' ) . '</a>' );
    array_unshift( $actions, '<a href="' . esc_url( get_admin_url( null, 'admin.php?page=featured-products-carousel-tag#wpv-about' ) ) . '">' . esc_html__( 'About', 'featured-products-carousel-tag' ) . '</a>' );
    return $actions;
}
