/* public/js/scripts.js */
(function($){
    'use strict';

    function fpct_pc_init_carousel($wrap, items, autoplay) {
        if ($wrap.hasClass('fpct-pc-initialized')) return;
        if ($.fn && typeof $.fn.owlCarousel === 'function') {
            $wrap.owlCarousel({
                loop: true,
                margin: 12,
                nav: true,
                dots: false,
                autoplay: !!autoplay,
                responsive: {
                    0: { items: 1 },
                    480: { items: 2 },
                    768: { items: 2 },
                    992: { items: items }
                },
                navText: ['<span class="fpct-pc-nav prev">‹</span>','<span class="fpct-pc-nav next">›</span>']
            });
            $wrap.addClass('fpct-pc-initialized');
            return;
        }
        var attempts = $wrap.data('fpct-pc-attempts') || 0;
        if ( attempts < 10 ) {
            $wrap.data('fpct-pc-attempts', attempts + 1);
            setTimeout(function(){
                fpct_pc_init_carousel($wrap, items, autoplay);
            }, 200);
        } else {
            if ( window.console && window.console.warn ) {
                console.warn('fpct_pc: OwlCarousel not available for', $wrap);
            }
        }
    }

    $(document).ready(function(){
        $('.fpct-pc-carousel').each(function(){
            var $this = $(this);
            var autoplay = $this.data('fpct-autoplay') === true || $this.data('fpct-autoplay') === 'true';
            var items = parseInt( $this.data('fpct-items'), 10 ) || 3;
            if ( !$this.hasClass('owl-carousel') ) {
                $this.addClass('owl-carousel');
            }
            fpct_pc_init_carousel($this, items, autoplay);
        });
    });
})(jQuery);
