<?php
/**
 * Plugin Name:     Featured Post Carousel by Tag
 * Plugin URI:      https://d3veloper.es/featured-post-carousel-tag/
 * Description:     Muestra posts, páginas, productos y otros CPTs con la etiqueta "featured" o "destacado" en un carrusel responsive.
 * Version:         1.0.0
 * Author:          Daniel Esparza
 * Author URI:      https://d3veloper.es/
 * License:         GPLv2 or later
 * Text Domain:     featured-post-carousel-tag
 * Domain Path:     /languages
 *
 * @package featured-post-carousel-tag
 * @since   1.0.0
 */

// Evitar acceso directo
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Constantes (únicas)
if ( ! defined( 'FPCT_PC_PLUGIN_DIR' ) ) {
    define( 'FPCT_PC_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}
if ( ! defined( 'FPCT_PC_PLUGIN_URL' ) ) {
    define( 'FPCT_PC_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}

// Activation / Deactivation
if ( ! function_exists( 'fpct_pc_activate_plugin' ) ) {
    function fpct_pc_activate_plugin() {
        if ( get_option( 'fpct_pc_enabled' ) === false ) {
            add_option( 'fpct_pc_enabled', 1 );
        }
        if ( get_option( 'fpct_pc_post_types' ) === false ) {
            add_option( 'fpct_pc_post_types', array( 'post', 'page', 'product' ) );
        }
        if ( get_option( 'fpct_pc_default_image' ) === false ) {
            add_option( 'fpct_pc_default_image', '' );
        }
    }
}
if ( ! function_exists( 'fpct_pc_deactivate_plugin' ) ) {
    function fpct_pc_deactivate_plugin() {
        // Mantener opciones por defecto (no borrar)
    }
}
register_activation_hook( __FILE__, 'fpct_pc_activate_plugin' );
register_deactivation_hook( __FILE__, 'fpct_pc_deactivate_plugin' );

// Cargar archivos admin/includes
if ( is_admin() || ( defined( 'WP_CLI' ) && WP_CLI ) ) {
    require_once FPCT_PC_PLUGIN_DIR . 'includes/featured-post-carousel-tag-loader.php';
}

// Cargar funciones públicas
require_once FPCT_PC_PLUGIN_DIR . 'public/featured-post-carousel-tag-functions.php';

// Añadir enlaces a la página de plugin
add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'fpct_pc_plugin_action_links', 10, 1 );
if ( ! function_exists( 'fpct_pc_plugin_action_links' ) ) {
    function fpct_pc_plugin_action_links( $links ) {
        $settings_link = '<a href="' . esc_url( get_admin_url( null, 'admin.php?page=featured-post-carousel-tag' ) ) . '">' . esc_html__( 'Ajustes', 'featured-post-carousel-tag' ) . '</a>';
        array_unshift( $links, $settings_link );
        return $links;
    }
}