 <?php 
    if ( ! defined( 'ABSPATH' ) ) exit;

    global $wpdb;
    $table_name = $wpdb->prefix . 'fahimptb_post_table'; 
    
    $result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE `type` = %s", 'taxonomy'));
    $num_results = count($result);
    wp_enqueue_style('fahimptb-styles-css', FAHIMPTB_PLUGIN_URL . 'assets/css/fahimptb-styles.css', [], time(), 'all' );
    wp_enqueue_script('fahimptb-admin-script', FAHIMPTB_PLUGIN_URL . 'assets/js/admin-script.js', ['jquery'], '1.0', true);
    wp_localize_script('fahimptb-admin-script', 'fahimptb_ajax_object', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'taxonomy_nonce' => wp_create_nonce('fahimptb_triger_taxonomies_nonce')
    ));
?>
<div class="fahimptb-headerbar">
    <h1 class="fahimptb-page-title"><?php echo esc_html('Taxonomies'); ?></h1>
    <a href="<?php echo esc_url(admin_url('admin.php?page=fahimptb-add-taxonomy')); ?>" class="fahimptb-btn fahimptb-btn-sm">
        <i class="fahimptb-icon fahimptb-icon-plus"></i><?php echo esc_html('Add New'); ?>
    </a>

</div>
<div class="fahimptb-body taxonomy-content">
  <div class="fahimptb-card">
  
  <?php if ($num_results == 0): ?>
    <div class="subsubsub_content">
        <ul class="subsubsub">
            <li class="all">
                <a href="#" class="current" aria-current="page"><?php echo esc_html('All'); ?> <span class="count"><?php echo esc_html('(0)'); ?></span></a></li>
        </ul>
    </div>
    <div class="posts_content">
        <form id="posts-filter" method="get">
            <?php wp_nonce_field( 'posts_filter', 'posts_filter_nonce' ); ?>
           <div class="fahimptb-no-post-types-wrapper">
              <div class="fahimptb-no-post-types-inner">
                <img src="<?php echo esc_url(FAHIMPTB_PLUGIN_URL . 'assets/images/empty-post-types.svg'); ?>"/>
                 <h2><?php echo esc_html('Add Your First Taxonomy'); ?></h2>
                 <p><?php echo esc_html('Create custom taxonomies to classify post type content'); ?></p>
                 <a href="<?php echo esc_url(admin_url('admin.php?page=fahimptb-add-taxonomy')); ?>" class="fahimptb-btn"><i class="fahimptb-icon fahimptb-icon-plus"></i> <?php echo esc_html('Add Post Type'); ?></a>
              </div>
           </div>
        </form>
    </div>
  <?php else: ?>

    <div class="subsubsub_content">
        <ul class="subsubsub">
            <li class="all">
                <a href="#" class="current" aria-current="page"><?php echo esc_html('All'); ?> <span class="count">(<?php echo esc_html($num_results); ?>)</span></a></li>
        </ul>
    </div>
    <div class="posts_content">

 
        <?php 
            // wp_enqueue_script('moment');
            // wp_enqueue_style('fahimptb-bootstrap4-css', FAHIMPTB_PLUGIN_URL . 'assets/css/dataTables.bootstrap4.min.css' , [], '1.0', 'all' );
            // wp_enqueue_style('fahimptb-datatables-css', FAHIMPTB_PLUGIN_URL . 'assets/css/datatables.min.css' , [], '1.0', 'all' );
            // wp_enqueue_script('fahimptb-jquery-dataTables', FAHIMPTB_PLUGIN_URL . 'assets/js/jquery.dataTables.min.js' , ['jquery', 'moment'], '1.0', false);
            // wp_enqueue_script('fahimptb-dataTables-bootstrap4', FAHIMPTB_PLUGIN_URL . 'assets/js/dataTables.bootstrap4.min.js' , ['jquery'], '1.0', false);
        ?>

        <div class="container mt-5">
        <table id="fahimptb_listing_table" class="display" style="width:100%">
         
            <thead>
                <tr>
                    <th><input type="checkbox" id="select-all-bottom"></th>
                    <th><?php echo esc_html('Title'); ?></th>
                    <th><?php echo esc_html('Slug'); ?></th>
                    <th><?php echo esc_html('Taxonomies'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($result as $key => $value): ?>
                <tr>
                    <td><input type="checkbox" class="bulk-checkbox"></td>
                    <td>
                        <a href="<?php  esc_url(admin_url()); ?>admin.php?page=fahimptb-add-taxonomy&edit=<?php echo esc_attr($value->id); ?>"><?php echo ($value->title)? esc_html($value->title) :''; ?></a>
                        <?php if ($value->status == 0): ?>
                            — <span class="post-state"><span class="dashicons dashicons-hidden"></span>  <?php echo esc_html('Inactive'); ?></span>
                        <?php endif; ?>
                        <div class="action_container">
                            <span class="edit">
                                <a href="<?php echo esc_url(admin_url('admin.php?page=fahimptb-add-taxonomy&edit=' . esc_attr($value->id))); ?>" aria-label="Edit <?php echo esc_attr($value->title); ?>"><?php echo esc_html('Edit'); ?></a> |
                            </span>
                            <span>
                                <a class="fahimptbduplicate" href="#" data-id="<?php echo esc_attr($value->id); ?>" aria-label="Duplicate this item"><?php echo esc_html('Duplicate'); ?></a> |
                            </span>
                            <span>
                                <?php if ($value->status == 1): ?>
                                    <a class="fahimptbactivate" href="#" data-id="<?php echo esc_attr($value->id); ?>"><?php echo esc_html('Deactivate'); ?></a>
                                <?php else: ?>
                                    <a class="fahimptbdeactivate" href="#" data-id="<?php echo esc_attr($value->id); ?>"><?php echo esc_html('Activate'); ?></a>
                                <?php endif; ?>
                                |
                            </span>
                            <span>
                                <a class="trash" href="#" data-id="<?php echo esc_attr($value->id); ?>" aria-label="Move <?php echo esc_attr($value->title); ?> to the Trash"><?php echo esc_html('Delete'); ?></a>
                            </span>

                        </div>
                    </td>
                    <td><?php echo esc_attr($value->singular_name); ?></td>
                    <td><?php echo esc_attr($value->fahimptb_taxonomies); ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot>
                <tr>
                    <th></th>
                    <th><?php echo esc_html('Title'); ?></th>
                    <th><?php echo esc_html('Slug'); ?></th>
                    <th><?php echo esc_html('Taxonomies'); ?></th>
                </tr>
            </tfoot>
        </table>

       <!--  <div class="bulk-action-selector-bottom mt-3">
            <button class="btn btn-primary">Apply Bulk Action</button>
        </div> -->
    </div>

  </div>
</div>
<?php endif; ?>
</div>  