<?php 
if ( ! defined( 'ABSPATH' ) ) exit;

global $pagenow;
$result = fahimptb_get_data('post');
$postType = [];
foreach ($result as $key => $value) {
    $postType[] = $value->post_type;
}
if ($pagenow == 'edit.php' && isset($_GET['post_type']) && in_array($_GET['post_type'], $postType)): ?>
	<?php $post_type = isset($_GET['post_type']) ? sanitize_text_field(wp_unslash($_GET['post_type'])) : '';  ?>
	<div class="category-section">
		<div class="wrap">
			<h1 class="wp-heading-inline"><?php echo esc_html('Taxonomy'); ?></h1>
            <?php if (isset($post_type)): ?>
            	<?php
                	$taxonomy_names = get_object_taxonomies($post_type);
                ?>
                <?php foreach ($taxonomy_names as $taxonomy_name): ?>
                    <?php 
                    	$taxonomy = get_taxonomy($taxonomy_name);
                        $taxonomy_label = $taxonomy->labels->name;
                        $terms = get_terms(array('taxonomy' => $taxonomy_name,'hide_empty' => false,'parent' => 0));
                    ?>
                    <div class="category_container">
	                    <h4 class="wp-heading-inline"><?php echo esc_html($taxonomy_label); ?>
						    <a href="<?php echo esc_url(admin_url('/edit-tags.php?taxonomy=' . $taxonomy_name)); ?>" class="page-title-action">
						        <i class="dashicons-before dashicons-open-folder"></i> <?php echo esc_html('New'); ?>
						    </a>
						</h4>
                    	<ul class="menu-0">
		                    <?php foreach ($terms as $term): ?>
		                    	<?php 
								    $term_name = $term->name;
								    $term_count = $term->count;
								    $term_link = get_term_link($term->term_id, $taxonomy_name);
								    $term_admin_url = get_edit_term_link($term->term_id, $taxonomy_name);

								    $subcategories = get_terms(array('taxonomy' => $taxonomy_name,'hide_empty' => false,'parent' => $term->term_id));
								?>
								<li class="items menu-item-0">
								    <a href="<?php echo esc_url($term_admin_url); ?>">
								        <i class="dashicons-before dashicons-open-folder"></i> <?php echo esc_html($term_name); ?>
								        <span><?php echo esc_html($term_count); ?></span>
								    </a>
								    <div class="fornt_view">
								        <a class="page-title-action" target="_blank" href="<?php echo esc_url($term_link); ?>"><?php echo esc_html('View'); ?></a>
								    </div>
								</li>

                    			<ul class="menu-1">
									<?php foreach ($subcategories as $subcategory): ?>
										<?php 
									        $subterm_name = $subcategory->name;
									        $subterm_count = $subcategory->count;
								    		$sub_link = get_term_link($subcategory->term_id, $taxonomy_name);
									        $subterm_admin_url = get_edit_term_link($subcategory->term_id, $taxonomy_name); 
									        $subcategories = get_terms(array('taxonomy' => $taxonomy_name,'hide_empty' => false,'parent' => $subcategory->term_id));
									    ?>
										<li class="items menu-item-1">
										    <a href="<?php echo esc_url($subterm_admin_url); ?>">
										        <i class="dashicons-before dashicons-open-folder"></i> <?php echo esc_html($subterm_name); ?>
										        <span><?php echo esc_html($subterm_count); ?></span>
										    </a>
										    <div class="fornt_view">
										        <a class="page-title-action" target="_blank" href="<?php echo esc_url($sub_link); ?>"><?php echo esc_html('View'); ?></a>
										    </div>
										</li>

                    					<ul class="menu-2">
                    						<?php foreach ($subcategories as $subcategory): ?>
                    						<?php
										        $subterm_name = $subcategory->name;
										        $subterm_count = $subcategory->count;
										        $term_link = get_term_link($subcategory->term_id, $taxonomy_name);
										        $subterm_admin_url = get_edit_term_link($subcategory->term_id, $taxonomy_name); 
									        	$subcategories = get_terms(array('taxonomy' => $taxonomy_name,'hide_empty' => false,'parent' => $subcategory->term_id));
										    ?>
										    	<li class="items menu-item-2">
												    <a href="<?php echo esc_url($subterm_admin_url); ?>">
												        <i class="dashicons-before dashicons-open-folder"></i> <?php echo esc_html($subterm_name); ?>
												        <span><?php echo esc_html($subterm_count); ?></span>
												    </a>
												    <div class="fornt_view">
												        <a class="page-title-action" target="_blank" href="<?php echo esc_url($term_link); ?>"><?php echo esc_html('View'); ?></a>
												    </div>
												</li>

		                    					<ul class="menu-3">
		                    						<?php foreach ($subcategories as $subcategory): ?>
		                    						<?php
												        $subterm_name = $subcategory->name;
												        $subterm_count = $subcategory->count;
												        $term_link = get_term_link($subcategory->term_id, $taxonomy_name);
												        $subterm_admin_url = get_edit_term_link($subcategory->term_id, $taxonomy_name);
											        	 
									        			$subcategories = get_terms(array('taxonomy' => $taxonomy_name,'hide_empty' => false,'parent' => $subcategory->term_id));
												    ?>
												    	<li class="items menu-item-3">
														    <a href="<?php echo esc_url($subterm_admin_url); ?>">
														        <i class="dashicons-before dashicons-open-folder"></i> <?php echo esc_html($subterm_name); ?>
														        <span><?php echo esc_html($subterm_count); ?></span>
														    </a>
														    <div class="fornt_view">
														        <a class="page-title-action" target="_blank" href="<?php echo esc_url($term_link); ?>"><?php echo esc_html('View'); ?></a>
														    </div>
														</li>

													<?php endforeach; ?>
												</ul>
											<?php endforeach; ?>
										</ul>
									<?php endforeach; ?>
								</ul>
								<?php endforeach; ?>
						</ul>
					</div>
                  <?php endforeach; ?>       
            <?php endif; ?> 
        </div>
    </div>
<?php endif; ?>