<?php 
if ( ! defined( 'ABSPATH' ) ) exit;

wp_enqueue_style('fahimptb-styles-css', FAHIMPTB_PLUGIN_URL . 'assets/css/fahimptb-styles.css' , [], time(), 'all' );
wp_enqueue_style('fahimptb-select2-css', FAHIMPTB_PLUGIN_URL . 'assets/css/select2.min.css' , [], '1.0', 'all' );
wp_enqueue_script('fahimptb-select2', FAHIMPTB_PLUGIN_URL . 'assets/js/select2.min.js' , array('jquery'), '1.0', false);

global $wpdb;
$table_name = $wpdb->prefix . 'fahimptb_post_table';

$result_taxonomy = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE `type` = %s",'taxonomy')); 

if ( isset( $_GET['edit'] ) && !empty( $_GET['edit'] ) ) {

    $id = isset( $_GET['edit'] ) ? absint( $_GET['edit'] ) : 0;
    $result = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM $table_name WHERE `id` = %d", $id ) )[0];
    $advanced_settings = json_decode( $result->advanced_settings );
}

wp_enqueue_media();
?>

<div class="fahimptb-headerbar fahimptb-headerbar-field-editor">
	<div class="fahimptb-headerbar-inner">
		<div class="fahimptb-headerbar-content">
			<?php if (isset($_GET['edit']) && !empty($_GET['edit'])): ?>
				<h1 class="fahimptb-page-title"><?php echo esc_html('Edit Post Type'); ?></h1>
			<?php else: ?>
				<h1 class="fahimptb-page-title"><?php echo esc_html('Add New Post Type'); ?></h1>
			<?php endif; ?>
		</div>

		<div class="fahimptb-headerbar-actions" id="submitpost">
			<?php if (isset($_GET['edit']) && !empty($_GET['edit'])): ?>
				<button class="fahimptb-btn post_update_btn fahimptb-publish disabled" id="update_publish" type="button"><?php echo esc_html('Update Changes'); ?></button>
			<?php else: ?>
				<button class="fahimptb-btn post_save_btn fahimptb-publish" id="top_publish" type="button"><?php echo esc_html('Save Changes'); ?></button>
			<?php endif; ?>
		</div>
	</div>
</div>
<div class="posts_content">
	<?php if (isset($_GET['edit']) && !empty($_GET['edit'])): ?>
		<form id="fahimptb_post_update">
	<?php else: ?>
		<form id="fahimptb_post">
	<?php endif; ?>
	    <div id="poststuff">
	        <div id="post-body" class="metabox-holder columns-1">
	            <div id="postbox-container-2" class="postbox-container">
	                <div id="normal-sortables" class="meta-box-sortables ui-sortable ui-sortable-disabled">
	                    <div id="fahimptb-basic-settings" class="postbox">
	                        
	                        <div class="inside">
	                            <div class="fahimptb-field fahimptb-field-text fahimptb-field-name is-required">
	                                <div class="fahimptb-label">
	                                    <label for="fahimptb_post_type-labels-name"><?php echo esc_html('Plural Label'); ?> <span class="fahimptb-required">*</span></label>
	                                </div>
	                                <div class="fahimptb-input">
	                                    <div class="fahimptb-input-wrap">
	                                    	<input type="text" id="fahimptb_post_type-labels-name" class="fahimptb_plural_label" name="name" placeholder="Movies" required="required"  value="<?php echo (isset($result->title)) ? esc_attr($result->title) : ''; ?>" />
	                                    </div>
	                                </div>
	                            </div>
	                            <div class="fahimptb-field fahimptb-field-text fahimptb-field-singular-name is-required" data-name="singular_name">
	                                <div class="fahimptb-label">
	                                    <label for="fahimptb_post_type-labels-singular_name"><?php echo esc_html('Singular Label'); ?> <span class="fahimptb-required">*</span></label>
	                                </div>
	                                <div class="fahimptb-input">
	                                    <div class="fahimptb-input-wrap">
	                                        <input type="text" id="fahimptb_post_type-labels-singular_name" class="fahimptb_slugify_to_key fahimptb_singular_label" name="singular_name" placeholder="Movie" required="required"  value="<?php echo (isset($result->singular_name))? esc_attr($result->singular_name) : ''; ?>"/>
	                                    </div>
	                                </div>
	                            </div>
	                            <div class="fahimptb-field fahimptb-field-text fahimptb-field-post-type is-required">
	                                <div class="fahimptb-label">
	                                    <label for="fahimptb_post_type-post_type"><?php echo esc_html('Post Type Key'); ?> <span class="fahimptb-required">*</span></label>
	                                </div>
	                                <div class="fahimptb-input">
	                                    <div class="fahimptb-input-wrap">
	                                    	<input type="text" id="fahimptb_post_type-post_type" class="fahimptb_slugified_key" name="post_type" placeholder="movie" maxlength="20" required="required" value="<?php echo (isset($result->post_type))? esc_attr($result->post_type) : ''; ?>"/></div>
	                                    <p class="description"><?php echo esc_html('Lower case letters, underscores and dashes only, Max 20 characters'); ?>.</p>
	                                </div>
	                            </div>

	                            <div class="fahimptb-field fahimptb-field-text fahimptb-field-menu-icon">
	                                <div class="fahimptb-label">
	                                    <label for="fahimptb_post_type-menu-icon"><?php echo esc_html('Menu Icon'); ?></label>
	                                </div>
	                                <div class="fahimptb-input">
	                                    <div class="fahimptb-input-wrap">
	                                    	<input type="text" id="fahimptb_post_type-menu-icon" name="menu_icon" placeholder="dashicons-admin-post" value="<?php echo (isset($result->menu_icon))? esc_attr($result->menu_icon) : ''; ?>"/></div>
	                                    <p class="description"><?php echo esc_html('Enter a Dashicon class name (e.g., dashicons-admin-post).'); ?> <a href="https://developer.wordpress.org/resource/dashicons/" target="_blank"><?php echo esc_html('View Dashicons'); ?></a></p>
	                                </div>
	                            </div>

	                            <div class="fahimptb-field fahimptb-field-text fahimptb-field-post-type is-required">
	                                <div class="fahimptb-label">
	                                    <label for="fahimptb_post_type-post_type"><?php echo esc_html('Taxonomies'); ?> </label>
	                                </div>
	                                <div class="fahimptb-input">
	                                    <div class="fahimptb-input-wrap">
	                                    	<?php 
	                                    		$taxonomies = explode(',', @$result->fahimptb_taxonomies); 
											?>
											<select id="multi-select-box" multiple name="taxonomies[]">
											    <?php foreach ($result_taxonomy as $key => $value): ?>
											        <?php $isSelected = in_array($value->id, $taxonomies); ?>
											        <option value="<?php echo isset($value->id) ? esc_attr($value->id) : ''; ?>" <?php echo $isSelected ? esc_html('selected') : ''; ?>>
													    <?php echo isset($value->title) ? esc_html($value->title) : ''; ?>
													</option>
											    <?php endforeach ?>
											</select>

	                                    	<p class="description"><?php echo esc_html('Select existing taxonomies to classify items of the post type'); ?>.</p>
	                                	</div>
	                            	</div>

	                            <hr>
	                            <br> 
	                            <div class="fahimptb-field fahimptb-field-text fahimptb-field-post-type is-required">
	                                <div class="fahimptb-input">
	                                    <div class="fahimptb-input-wrap d-flex">
	                                    	<label class="fahimptb_switch_btn">
											  <input value="1" name="public" type="checkbox" <?php if (@$result->public == 1) { echo esc_html('checked'); } ?>>
											  <span class="slider round"></span>
											</label>
											<label><b><?php echo esc_html('Public'); ?></b> <br> <?php echo esc_html('Visible on the frontend and in the admin dashboard'); ?>.</label>
	                                	</div>
	                            	</div>
	                            </div>

	                            <div class="fahimptb-field fahimptb-field-text fahimptb-field-post-type is-required">
	                                <div class="fahimptb-input">
	                                    <div class="fahimptb-input-wrap d-flex">
	                                    	<label class="fahimptb_switch_btn">
											  <input value="1" name="hierarchical" type="checkbox" <?php if (@$result->hierarchical == 1) { echo esc_html('checked'); } ?>>
											  <span class="slider round"></span>
											</label>
											<label><b><?php echo esc_html('Hierarchical'); ?></b> <br> <?php echo esc_html('Hierarchical post types can have descendants (like pages)'); ?>.</label>
	                                	</div>
	                            	</div>
	                            </div>

	                            <hr>
	                            <br>
	                            <h3><?php echo esc_html('Advanced Settings'); ?></h3>
	                            <hr>
								
								<div class="fahimptb-field fahimptb-field-checkbox fahimptb-field-supports">
								   <div class="fahimptb-label">
								      <label for="fahimptb_post_type-supports"><?php echo esc_html('Supports'); ?></label>
								      <p class="description"><?php echo esc_html('Enable various features in the content editor'); ?>.</p>
								   </div>
								   <div class="fahimptb-input">
								      <ul class="fahimptb-checkbox-list fahimptb-bl fahimptb_post_type_supports">
								         <li>
								         	<label class="selected">
								         		<input value="1" type="checkbox" id="fahimptb_post_type-supports-title" name="supports_title" <?php if (@$advanced_settings->supports_title == 'on' || @$advanced_settings->supports_title == 1  || !isset($_GET['edit'])) { echo esc_html('checked'); } ?>> <?php echo esc_html('Title'); ?></label>
								         </li>
								         <li>
								         	<label>
								         		<input value="1" type="checkbox" id="fahimptb_post_type-supports-author" name="supports_author" <?php if (@$advanced_settings->supports_author == 'on' || @$advanced_settings->supports_author == 1) { echo esc_html('checked'); } ?>> <?php echo esc_html('Author'); ?></label>
								         </li>
								         <li>
								         	<label>
								         		<input value="1" type="checkbox" id="fahimptb_post_type-supports-comments" name="supports_comments" <?php if (@$advanced_settings->supports_comments == 'on' || @$advanced_settings->supports_comments == 1) { echo esc_html('checked'); } ?>> <?php echo esc_html('Comments'); ?></label>
								         </li>
								         <li>
								         	<label>
								         		<input value="1" type="checkbox" id="fahimptb_post_type-supports-trackbacks" name="supports_trackbacks" <?php if (@$advanced_settings->supports_trackbacks == 'on' || @$advanced_settings->supports_trackbacks == 1) { echo esc_html('checked'); } ?>> <?php echo esc_html('Trackbacks'); ?></label>
								         </li>
								         <li>
								         	<label class="selected">
								         		<input value="1" type="checkbox" id="fahimptb_post_type-supports-editor" name="supports_editor" <?php if (@$advanced_settings->supports_editor == 'on' || @$advanced_settings->supports_editor == 1  || !isset($_GET['edit'])) { echo esc_html('checked'); } ?>> <?php echo esc_html('Editor'); ?></label></li>
								         <li>
								         	<label>
								         		<input value="1" type="checkbox" id="fahimptb_post_type-supports-excerpt" name="supports_excerpt" <?php if (@$advanced_settings->supports_excerpt == 'on' || @$advanced_settings->supports_excerpt == 1) { echo esc_html('checked'); } ?>> <?php echo esc_html('Excerpt'); ?></label>
								         </li>
								         <li>
								         	<label>
								         		<input value="1" type="checkbox" id="fahimptb_post_type-supports-revisions" name="supports_revisions" <?php if (@$advanced_settings->supports_revisions == 'on' || @$advanced_settings->supports_revisions == 1) { echo esc_html('checked'); } ?>> <?php echo esc_html('Revisions'); ?></label>
								         </li>
								         <li>
								         	<label>
								         		<input value="1" type="checkbox" id="fahimptb_post_type-supports-page-attributes" name="supports_attributes" <?php if (@$advanced_settings->supports_attributes == 'on' || @$advanced_settings->supports_attributes == 1) { echo esc_html('checked'); } ?>> <?php echo esc_html('Page Attributes'); ?></label>
								         </li>
								         <li>
								         	<label class="selected">
								         		<input value="1" type="checkbox" id="fahimptb_post_type-supports-thumbnail" name="supports_thumbnail" <?php if (@$advanced_settings->supports_thumbnail == 'on' || @$advanced_settings->supports_thumbnail == 1) { echo esc_html('checked'); } ?>> <?php echo esc_html('Featured Image'); ?></label>
								         </li>
								         <li>
								         	<label>
								         		<input value="1" type="checkbox" id="fahimptb_post_type-supports-custom-fields" name="supports_custom_fields" <?php if (@$advanced_settings->supports_custom_fields == 'on' || @$advanced_settings->supports_custom_fields == 1) { echo esc_html('checked'); } ?>> <?php echo esc_html('Custom Fields'); ?></label>
								         </li>
								      </ul>
								   </div>
								</div>


	                            <br>
	                            <hr>
	                            <br>
	                            <div class="fahimptb-field fahimptb-field-text fahimptb-field-post-type is-required">
	                                <div class="fahimptb-input">
	                                    <div class="fahimptb-input-wrap d-flex">
	                                    	<label class="fahimptb_switch_btn">
											  <input value="1" name="status" type="checkbox" <?php if (@$result->status == 1 || !isset($_GET['edit'])) { echo esc_html('checked'); } ?>>
											  <span class="slider round"></span>
											</label>
											<label><b><?php echo esc_html('Active'); ?></b> <br> <?php echo esc_html('Active post types are enabled and registered with WordPress'); ?>.</label>
	                                	</div>
	                            	</div>
	                            </div>
	                            <br>

	                            <br>
	                            <?php 
	                            $featured_image = isset($advanced_settings->featured_image) ? $advanced_settings->featured_image : '';
                            if (!filter_var($featured_image, FILTER_VALIDATE_URL)) {
                                $featured_image = '';
                            }
	                            ?>
	                            <div class="fahimptb-field fahimptb-field-text fahimptb-field-post-type is-required">
	                            	<div class="up_img">
	                            		<div class="img-section position-relative d-inline">
										    <?php if (!empty($featured_image)): ?>
										        <button type="button" class="btn btn-danger remove_img p-0">
										            x
										        </button>
										        <img src="<?php echo esc_url($featured_image); ?>" width="100" style="width: 30%;">
										    <?php endif; ?>
										</div>

				                        <label for="images"><?php echo esc_html('Archive Banner'); ?>:</label>
				                        <input class="img-up" type="hidden" name="featured_image" value="<?php echo !empty($featured_image) ? esc_url($featured_image) : ''; ?>" readonly>
				                        <input type="button" class="button button-primary upload_featured_image" value="Upload Image">
				                    </div>
				                </div>
	                        </div>
	                    </div>  
	                </div>
	            </div>
	        </div>
	        <br class="clear" />
	    </div>
	    <?php if (isset($_GET['edit']) && !empty($_GET['edit'])): ?>
			<button class="fahimptb-btn post_update_btn fahimptb-publish disabled" id="update" type="submit" style="float: right;"><?php echo esc_html('Update Changes'); ?></button>
		<?php else: ?>
			<button class="fahimptb-btn post_save_btn fahimptb-publish disabled" id="publish" type="submit" style="float: right;"><?php echo esc_html('Save Changes'); ?></button>
		<?php endif; ?>
	    
	</form>

</div>

 

<?php if (isset($_GET['edit']) && !empty($_GET['edit'])): ?>
	<?php $id = isset($_GET['edit']) ? absint($_GET['edit']) : 0; ?>
	<input type="hidden" id="edit_id_post" name="edit_id_post" value="<?php echo $id; ?>">
<?php endif; ?>

 