<?php

if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Uninstalls the plugin by dropping custom tables.
 */
function fahimptb_uninstall() {
       global $wpdb;
       $table_name = $wpdb->prefix . 'fahimptb_post_table';
       $table_setting = $wpdb->prefix . 'fahimptb_post_setting';
       
       // Check if the table exists in cache
       $cached_table_exists = wp_cache_get('fahimptb_table_exists');
       if ($cached_table_exists === false) {
           // Table existence not found in cache, fetch from database
           $table_exists = $wpdb->get_var($wpdb->prepare("SHOW TABLES LIKE %s", $table_name));

           // Cache the table existence for future use
           wp_cache_set('fahimptb_table_exists', $table_exists);
       } else {
           $table_exists = $cached_table_exists;
       }

       if ($table_exists == $table_name) {
           // Table exists, drop it
           $wpdb->query($wpdb->prepare("DROP TABLE IF EXISTS %s", $table_name));

           // Clear table existence cache
           wp_cache_delete('fahimptb_table_exists');
       }

       // Drop the second table
       $wpdb->query($wpdb->prepare("DROP TABLE IF EXISTS %s", $table_setting));
   }

/**
 * Creates custom tables for the plugin.
 */
function fahimptb_create_tables() {
        global $wpdb;
        $table_name = $wpdb->prefix . 'fahimptb_post_table';

        $table_exists = $wpdb->get_var($wpdb->prepare("SHOW TABLES LIKE %s", $table_name));

        if ($table_exists === null) {
            $charset_collate = $wpdb->get_charset_collate();

            $sql = "CREATE TABLE {$table_name} (
                `id` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
                `type` varchar(220) NOT NULL,
                `status` INT DEFAULT 0,
                `title` varchar(220) DEFAULT NULL,
                `singular_name` varchar(220) DEFAULT NULL,
                `post_type` varchar(220) NOT NULL,
                `fahimptb_taxonomies` varchar(220) NOT NULL,
                `advanced_settings` text DEFAULT NULL,
                `public` INT DEFAULT 0,
                `hierarchical` INT DEFAULT 0,
                `menu_icon` varchar(220) DEFAULT NULL,
                `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
                `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
            ) {$charset_collate};";

            require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
            dbDelta($sql);
        }

        $table_setting = $wpdb->prefix . 'fahimptb_post_setting';
        $table_exists = $wpdb->get_var($wpdb->prepare("SHOW TABLES LIKE %s", $table_setting));

        if ($table_exists !== $table_setting) {
            $charset_collate = $wpdb->get_charset_collate();
            $sql = "CREATE TABLE {$table_setting} (
                `id` int NOT NULL AUTO_INCREMENT PRIMARY KEY,
                `setting` varchar(220) NOT NULL,
                `data` INT DEFAULT 12
            ) {$charset_collate};";

            require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
            dbDelta($sql);

            // Check if the 'per_page' setting exists
            $result = $wpdb->get_results($wpdb->prepare("SELECT * FROM {$table_setting} WHERE `setting` = %s", 'per_page'));
            if (empty($result)) {
                $wpdb->insert($table_setting, array('setting' => 'per_page', 'data' => 12), array('%s', '%d'));
            }
        }
   }
add_action('after_setup_theme', 'fahimptb_create_tables');