<?php
/**
 * Fahim Project & Post Type Builder
 *
 * @package       Fahim Project & Post Type Builder
 * @author        Fahim Full Stack Web Developer
 * @license       GPLv2
 * @version       2.0.0
 *
 * @wordpress-plugin
 * Plugin Name:   Fahim Project & Post Type Builder
 * Plugin URI:    https://www.fahimshakir.com/blog/fahim-project-post-type-builder
 * Description:   Create custom post types and taxonomies
 * Version:       2.0.0
 * Author:        Fahim Full Stack Web Developer
 * Author URI:    https://www.fahimshakir.com/
 * Text Domain:   fahim-fahim-project-post-type-builder
 * License:       GPLv2
 * License URI:   https://www.gnu.org/licenses/gpl-2.0.html
 * Requires at least: 5.0
 * Requires PHP: 7.0
 * Support Email: info@fahimshakir.com
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Plugin constants
define( 'FAHIMPTB_VERSION', '2.0.0' );
define( 'FAHIMPTB_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'FAHIMPTB_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

// Include necessary files
require_once FAHIMPTB_PLUGIN_DIR . 'block/cpt.php';
require_once FAHIMPTB_PLUGIN_DIR . 'model/table.php';
require_once FAHIMPTB_PLUGIN_DIR . 'controller/admin.php';
require_once FAHIMPTB_PLUGIN_DIR . 'controller/index.php';

/**
 * Enqueue admin and frontend scripts/styles
 */


function fahimptb_enqueue_frontend_assets() {
    wp_enqueue_style(
        'fahimptb-styles',
        FAHIMPTB_PLUGIN_URL . 'assets/css/fahimptb-styles.css',
        [],
        FAHIMPTB_VERSION
    );
}
add_action( 'wp_enqueue_scripts', 'fahimptb_enqueue_frontend_assets' );


function fahimptb_enqueue_admin_assets( $hook ) {
    // Admin styles
    if ( is_admin() ) {
        wp_enqueue_style( 'fahimptb-admin-styles', FAHIMPTB_PLUGIN_URL . 'assets/css/fahimptb-admin.css', [], FAHIMPTB_VERSION );
    }



    $plugin_pages = [
        'fahim-project-post-type-builder',
        'fahimptb-add-new',
        'fahimptb-taxonomies',
        'fahimptb-add-taxonomy',
        'fahimptb-settings'
    ];

    $current_page = isset($_GET['page']) ? sanitize_text_field($_GET['page']) : '';

    if ( in_array( $current_page, $plugin_pages ) ) {


        // Enqueue styles
        wp_enqueue_style( 'fahimptb-bootstrap4-css', FAHIMPTB_PLUGIN_URL . 'assets/css/dataTables.bootstrap4.min.css', [], '1.0', 'all' );
        wp_enqueue_style( 'fahimptb-datatables-css', FAHIMPTB_PLUGIN_URL . 'assets/css/datatables.min.css', [], '1.0', 'all' );

        // Enqueue scripts
        wp_enqueue_script( 'moment' );
        wp_enqueue_script( 'fahimptb-jquery-dataTables', FAHIMPTB_PLUGIN_URL . 'assets/js/jquery.dataTables.min.js', [ 'jquery', 'moment' ], '1.0', true );
        wp_enqueue_script( 'fahimptb-dataTables-bootstrap4', FAHIMPTB_PLUGIN_URL . 'assets/js/dataTables.bootstrap4.min.js', [ 'jquery' ], '1.0', true );


        wp_enqueue_style('fahimptb-select2-css', FAHIMPTB_PLUGIN_URL . 'assets/css/select2.min.css' , false, '1.0', 'all' );
        wp_enqueue_script('fahimptb-select2', FAHIMPTB_PLUGIN_URL . 'assets/js/select2.min.js' , array('jquery'), '1.0', false);

        wp_enqueue_script( 'fahimptb-script', FAHIMPTB_PLUGIN_URL . 'assets/js/fahimptb-script.js', [ 'jquery' ], FAHIMPTB_VERSION, true );

        $plugin_url = FAHIMPTB_PLUGIN_URL;

        $fahimptb_taxonomy_nonce = wp_create_nonce( 'fahimptb_taxonomy' );
        $fahimptb_post_nonce = wp_create_nonce( 'fahimptb_post' );
        $fahimptb_taxonomy_update = wp_create_nonce( 'fahimptb_taxonomy_update' );
        $fahimptb_post_update = wp_create_nonce( 'fahimptb_post_update' );
        
        wp_localize_script('fahimptb-script', 'fahimptb_ajax_object', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'plugin_url' => $plugin_url,
            'fahimptb_post_nonce' => esc_js( $fahimptb_post_nonce ),
            'fahimptb_taxonomy_nonce' => esc_js( $fahimptb_taxonomy_nonce ),
            'fahimptb_taxonomy_update' => esc_js( $fahimptb_taxonomy_update ),
            'fahimptb_post_update' => esc_js( $fahimptb_post_update ),
        ));
    }

}
add_action( 'admin_enqueue_scripts', 'fahimptb_enqueue_admin_assets' );

// add_action( 'wp_enqueue_scripts', 'fahimptb_enqueue_assets' );
// add_action( 'admin_enqueue_scripts', 'fahimptb_enqueue_assets' );

/**
 * Register admin menu pages
 */
function fahimptb_register_admin_menu() {
    $parent_slug = 'fahim-project-post-type-builder';

    add_menu_page(
        __( 'Fahim Project & Post Type Builder', 'fahim-project-post-type-builder' ),
        __( 'Fahim Project & Post Type Builder', 'fahim-project-post-type-builder' ),
        'manage_options',
        $parent_slug,
        'fahimptb_post_types_page',
        'dashicons-admin-plugins',
        20
    );

    add_submenu_page(
        $parent_slug,
        __( 'Post Types', 'fahim-project-post-type-builder' ),
        __( 'Post Types', 'fahim-project-post-type-builder' ),
        'manage_options',
        $parent_slug,
        'fahimptb_post_types_page'
    );

    add_submenu_page(
        $parent_slug,
        __( 'Add New', 'fahim-project-post-type-builder' ),
        __( 'Add New', 'fahim-project-post-type-builder' ),
        'manage_options',
        'fahimptb-add-new',
        'fahimptb_add_new_page'
    );

    add_submenu_page(
        $parent_slug,
        __( 'Taxonomies', 'fahim-project-post-type-builder' ),
        __( 'Taxonomies', 'fahim-project-post-type-builder' ),
        'manage_options',
        'fahimptb-taxonomies',
        'fahimptb_taxonomies_page'
    );

    add_submenu_page(
        $parent_slug,
        __( 'Add Taxonomy', 'fahim-project-post-type-builder' ),
        __( 'Add Taxonomy', 'fahim-project-post-type-builder' ),
        'manage_options',
        'fahimptb-add-taxonomy',
        'fahimptb_add_taxonomy_page'
    );

    add_submenu_page(
        $parent_slug,
        __( 'Settings', 'fahim-project-post-type-builder' ),
        __( 'Settings', 'fahim-project-post-type-builder' ),
        'manage_options',
        'fahimptb-settings',
        'fahimptb_settings_page'
    );
}
add_action( 'admin_menu', 'fahimptb_register_admin_menu' );

/**
 * Admin page callbacks
 */
function fahimptb_post_types_page() {
    require_once FAHIMPTB_PLUGIN_DIR . 'view/admin/post-list.php';
}

function fahimptb_add_new_page() {
    require_once FAHIMPTB_PLUGIN_DIR . 'view/admin/fahimptb-post-type.php';
}

function fahimptb_taxonomies_page() {
    require_once FAHIMPTB_PLUGIN_DIR . 'view/admin/taxonomy-list.php';
}

function fahimptb_add_taxonomy_page() {
    require_once FAHIMPTB_PLUGIN_DIR . 'view/admin/fahimptb-post-taxonomy.php';
}

function fahimptb_settings_page() {
    require_once FAHIMPTB_PLUGIN_DIR . 'view/admin/settings.php';
}

/**
 * Admin notice / welcome message
 */
function fahimptb_admin_notice() {
    require_once FAHIMPTB_PLUGIN_DIR . 'view/admin/index.php';
}
add_action( 'admin_notices', 'fahimptb_admin_notice' );
