<?php
if ( ! defined( 'ABSPATH' ) ) exit;

function fahimptb_save_post_data($block){
	$postType = isset($block['post_type']) ? $block['post_type'] : '';
	$title = isset($block['name']) ? $block['name'] : '';
	$singular_name = isset($block['singular_name']) ? $block['singular_name'] : '';

	$taxonomies = isset($block['selected_taxonomies']) ? $block['selected_taxonomies'] : '';
 
    $public = isset($block['public']) ? 1 : 0;
    $hierarchical = isset($block['hierarchical']) ? 1 : 0;
    $status = isset($block['status']) ? 1 : 0;
     
	$supports_title = isset($block['supports_title']) ? $block['supports_title'] : '';
	$supports_author = isset($block['supports_author']) ? $block['supports_author'] : '';
	$supports_comments = isset($block['supports_comments']) ? $block['supports_comments'] : '';
	$supports_trackbacks = isset($block['supports_trackbacks']) ? $block['supports_trackbacks'] : '';
	$supports_editor = isset($block['supports_editor']) ? $block['supports_editor'] : '';
	$supports_excerpt = isset($block['supports_excerpt']) ? $block['supports_excerpt'] : '';
	$supports_revisions = isset($block['supports_revisions']) ? $block['supports_revisions'] : '';
	$supports_attributes = isset($block['supports_attributes']) ? $block['supports_attributes'] : '';
	$supports_thumbnail = isset($block['supports_thumbnail']) ? $block['supports_thumbnail'] : '';
	$supports_custom_fields = isset($block['supports_custom_fields']) ? $block['supports_custom_fields'] : '';
	$featured_image = '';
    if (isset($block['featured_image']) && !empty($block['featured_image'])) {
        $featured_image_parts = explode('uploads-', $block['featured_image']);
        if (isset($featured_image_parts[1])) {
            $featured_image_path = preg_replace('/-/', '/', $featured_image_parts[1], 2);
            $upload_dir = wp_upload_dir();
			$featured_image = esc_url( trailingslashit( $upload_dir['baseurl'] ) . $featured_image_path );
        }
    }

	$newdate = current_time('Y-m-d H:i:s');

	$supports = [];
	if (isset($block['supports_title']) && $block['supports_title'] == 1) {
	    $supports[] = 'title';
	}
	if (isset($block['supports_editor']) && $block['supports_editor'] == 1) {
	    $supports[] = 'editor';
	}
	if (isset($block['supports_excerpt']) && $block['supports_excerpt'] == 1) {
	    $supports[] = 'excerpt';
	}
	if (isset($block['supports_thumbnail']) && $block['supports_thumbnail'] == 1) {
	    $supports[] = 'thumbnail';
	}
	if (isset($block['supports_revisions']) && $block['supports_revisions'] == 1) {
	    $supports[] = 'revisions';
	}
	if (isset($block['supports_author']) && $block['supports_author'] == 1) {
	    $supports[] = 'author';
	}
	if (isset($block['supports_comments']) && $block['supports_comments'] == 1) {
	    $supports[] = 'comments';
	}
	if (isset($block['supports_trackbacks']) && $block['supports_trackbacks'] == 1) {
	    $supports[] = 'trackbacks';
	}
	if (isset($block['supports_attributes']) && $block['supports_attributes'] == 1) {
	    $supports[] = 'page-attributes';
	}
	if (isset($block['supports_custom_fields']) && $block['supports_custom_fields'] == 1) {
	    $supports[] = 'custom-fields';
	}

	$advanced = [
		'supports' => $supports,
		'supports_title' => $supports_title,
		'supports_author' => $supports_author,
		'supports_comments' => $supports_comments,
		'supports_trackbacks' => $supports_trackbacks,
		'supports_editor' => $supports_editor,
		'supports_excerpt' => $supports_excerpt,
		'supports_revisions' => $supports_revisions,
		'supports_attributes' => $supports_attributes,
		'supports_thumbnail' => $supports_thumbnail,
        'featured_image' => $featured_image,
		'supports_custom_fields' => $supports_custom_fields
	];
	$advanced_data = wp_json_encode($advanced,true);

    $data = array(
        'title' => $title,
        'type' => 'post',
        'status' => $status,
        'singular_name' => $singular_name,
        'post_type' => $postType,
        'fahimptb_taxonomies' => $taxonomies,
        'advanced_settings' => $advanced_data,
        'public' => $public,
        'hierarchical' => $hierarchical,
        'menu_icon' => isset($block['menu_icon']) ? sanitize_text_field($block['menu_icon']) : '',
        'created_at' => $newdate,
        'updated_at' => $newdate
    );

    return $data;
}

add_action('wp_ajax_fahimptb_add_post', 'fahimptb_post_handler' );
add_action('wp_ajax_nopriv_fahimptb_add_post','fahimptb_post_handler');

function fahimptb_post_handler(){

	if ( ! isset( $_POST['fahimptb_post_nonce'] ) || ! wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['fahimptb_post_nonce'])), 'fahimptb_post' ) ) {
        wp_die( 'Nonce verification failed' );
    }

	$formData = isset($_POST['formData']) ? sanitize_text_field(wp_unslash($_POST['formData'])) : '';
   	parse_str($formData, $block);

    try {
        global $wpdb;
      	$table_name = $wpdb->prefix . 'fahimptb_post_table';

      	$postType = @$block['post_type'];

		$cache_key = 'fahimptb_post_table_' . $postType;
		$cached_result = wp_cache_get($cache_key);
		if ($cached_result === false) {
		    $result = $wpdb->get_results($wpdb->prepare("SELECT `id` FROM $table_name WHERE `post_type` = %s" , $postType));
		    wp_cache_set($cache_key, $result);
		} else {
		    $result = $cached_result;
		}
    	 
		if (count($result) == 0) {
		    
			$data = fahimptb_save_post_data($block);
 
	        $wpdb->insert($table_name, $data);

	        if (isset($block['taxonomies'])){
				$inserted_id = $wpdb->insert_id;
				foreach ($block['taxonomies'] as $key => $value) {
				    
				    $result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE `id` = %s", $value))[0]; 

				    if (strpos($postType, ',') !== false) {
				    	$ids = $result->post_type.','.$inserted_id;
				    	$ids_ar = explode(',', $ids);
				    	$inserted_ids = array_unique($ids_ar);
				    	$getids = implode(',', $inserted_ids);
				    }else{
				    	$getids = $inserted_id;
				    }
			    	$data = array(
		                'post_type' => $getids
		            );
		            $where = array('id' => $value);
		            $wpdb->update($table_name, $data, $where);
		    	}
		    }

		    flush_rewrite_rules();

	        echo wp_json_encode([
	            'status'=> true,
	            'message'=>'Success'
	        ], true);
	        
		}else{
			echo esc_html('exist');
		}

		wp_die();

    } catch (Exception $e) {
        echo wp_json_encode([
            'status'=>false,
            'message'=>$e->getMessage()
        ], true);
        wp_die();
    }
}

add_action('wp_ajax_fahimptb_update_post', 'fahimptb_update_post_handler' );
add_action('wp_ajax_nopriv_fahimptb_update_post','fahimptb_update_post_handler');

function fahimptb_update_post_handler(){ 
  
	if (!isset($_POST['fahimptb_post_update_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['fahimptb_post_update_nonce'])), 'fahimptb_post_update')) {
        wp_die('Nonce verification failed');
    }
    $id = isset($_POST['id']) ? absint($_POST['id']) : 0;
	$formData = isset($_POST['formData']) ? sanitize_text_field(wp_unslash($_POST['formData'])) : '';
   	parse_str($formData, $block);
 
    try {
        global $wpdb;
      	$table_name = $wpdb->prefix . 'fahimptb_post_table';

      	$postType = @$block['post_type'];
 
	    $cache_key = 'fahimptb_post_' . $id;
        $cached_result = wp_cache_get($cache_key);
        if ($cached_result === false) {
            $storedPostType = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE `id` = %d" , $id))[0];
            wp_cache_set($cache_key, $storedPostType);
        } else {
            $storedPostType = $cached_result;
        }

	    if ($storedPostType->post_type === $postType) {
	    	$data = fahimptb_save_post_data($block);
	        $where = array('id' => $id);
            $wpdb->update($table_name, $data, $where);
  			flush_rewrite_rules();
	        echo wp_json_encode([
		            'status'=> true,
		            'message'=>'Success'
		        ], true);

	    }else{
	    	$result = $wpdb->get_results($wpdb->prepare("SELECT 'id' FROM $table_name WHERE `post_type` = %s", $postType));
	    	if (count($result) == 0) {

	    		$data = fahimptb_save_post_data($block);
		        $where = array('id' => $id);
	            $wpdb->update($table_name, $data, $where);
	            flush_rewrite_rules();
		        echo wp_json_encode([
		            'status'=> true,
		            'message'=>'Success'
		        ], true);
	        
			}else{
				echo esc_html('exist');
			}
		}

		wp_die();

	

    } catch (Exception $e) {
        echo wp_json_encode([
            'status'=>false,
            'message'=>$e->getMessage()
        ], true);
        wp_die();
    }
}



function fahimptb_duplicate_post($post) {
	global $wpdb;
    $table_name = $wpdb->prefix . 'fahimptb_post_table';
	$newdate = current_time('H:i:s');

	$cache_key = 'fahimptb_post_' . $post->post_type;
	$cached_result = wp_cache_get($cache_key);
	if ($cached_result === false) {
	    $result = $wpdb->get_results($wpdb->prepare("SELECT 'id' FROM $table_name WHERE `post_type` = %s", $post->post_type));
	    wp_cache_set($cache_key, $result);
	} else {
	    $result = $cached_result;
	}

	$postType = $post->post_type.'-'.count($result);
 
	$data = array(
        'title' => $post->title,
        'type' => $post->type,
        'status' => $post->status,
        'singular_name' => $post->singular_name,
        'post_type' => $postType,
        'fahimptb_taxonomies' => $post->fahimptb_taxonomies,
        'advanced_settings' => $post->advanced_settings,
        'public' => $post->public,
        'hierarchical' => $post->hierarchical,
        'created_at' => $newdate,
        'updated_at' => $newdate
    );
    return $data;
}
add_action('wp_ajax_fahimptb_triger_post', 'fahimptb_triger_post_handler' );
add_action('wp_ajax_nopriv_fahimptb_triger_post','fahimptb_triger_post_handler');
function fahimptb_triger_post_handler(){
	if (!isset($_POST['fahimptb_triger_post_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['fahimptb_triger_post_nonce'])), 'fahimptb_triger_post_nonce')) {
        wp_die('Nonce verification failed');
    }
    
    global $wpdb;
    $table_name = $wpdb->prefix . 'fahimptb_post_table';
    try {
		$id = isset($_POST['id']) ? absint($_POST['id']) : 0;
 
		$triger = isset($_POST['triger']) ? sanitize_text_field(wp_unslash($_POST['triger'])) : '';
		$newdate = current_time('Y-m-d H:i:s'); 
		if ($triger == 'trash') {

			$cache_key = 'fahimptb_post_taxonomy';
		    $cached_result = wp_cache_get($cache_key);
		    if ($cached_result === false) {
		        $result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE `type` = %s", 'taxonomy'));
		        wp_cache_set($cache_key, $result);
		    } else {
		        $result = $cached_result;
		    }

			foreach ($result as $value) {
				if (strpos($value->post_type, ',') !== false) {
					$ids = explode(',', $value->post_type);
					$ids = array_filter($ids, function ($item) use ($id) {
					    return $item !== $id;
					});
					$ids = array_values($ids);
					$ids = implode(',', $ids);
				}else{
					if ($value->post_type == $id) {
						$ids = '';
					}else{
						$ids = $value->post_type;
					}
				}
				$data = array(
			        'post_type' => $ids
			    );
				$where = array('id' => $value->id);
				$wpdb->update($table_name, $data, $where);
			}
   
	        $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE `id` = %d",$id));


	        flush_rewrite_rules();
	        echo wp_json_encode([
	            'status'=> true,
	            'message'=>'Success'
	        ], true);

	    }elseif($triger == 'activate'){
	    	$data = array(
		        'status' => 1,
		        'updated_at' => $newdate
		    );
	        $where = array('id' => $id);
            $wpdb->update($table_name, $data, $where);
	    }elseif($triger == 'deactivate'){
	    	$data = array(
		        'status' => 0,
		        'updated_at' => $newdate
		    );
	        $where = array('id' => $id);
            $wpdb->update($table_name, $data, $where);

	    }elseif($triger == 'duplicate'){

	    	$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE `id` = %d",$id))[0];
			$data = pacp_duplicate_post($result);
	        $wpdb->insert($table_name, $data);

	        echo wp_json_encode([
	            'status'=> true,
	            'message'=>'Success'
	        ], true);
	    }
	    flush_rewrite_rules();
        wp_die();
	} catch (Exception $e) {
        echo wp_json_encode([
            'status'=>false,
            'message'=>$e->getMessage()
        ], true);
        wp_die();
    }
}

function fahimptb_save_taxonomy_data($block){
	$newdate = current_time('Y-m-d H:i:s');

	$title = isset($block['name']) ? $block['name'] : '';
	$singular_name = isset($block['singular_name']) ? $block['singular_name'] : '';
	$taxonomy_type = isset($block['taxonomy_type']) ? $block['taxonomy_type'] : '';

    $posts = isset($block['selected_posts']) ? $block['selected_posts'] : '';

    $public = isset($block['public']) ? 1 : 0;
    $hierarchical = isset($block['hierarchical']) ? 1 : 0;
    $status = isset($block['status']) ? 1 : 0;

    $data = array(
        'title' => $title,
        'status' => $status,
        'type' => 'taxonomy',
        'singular_name' => $singular_name,
        'post_type' => $posts,
        'fahimptb_taxonomies' => $taxonomy_type,
        'public' => $public,
        'hierarchical' => $hierarchical,
        'created_at' => $newdate,
        'updated_at' => $newdate
    );

    return $data;

}

add_action('wp_ajax_fahimptb_add_taxonomy', 'fahimptb_taxonomy_handler' );
add_action('wp_ajax_nopriv_fahimptb_add_taxonomy','fahimptb_taxonomy_handler');
function fahimptb_taxonomy_handler(){ 
	if ( ! isset( $_POST['fahimptb_taxonomy_nonce'] ) || ! wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['fahimptb_taxonomy_nonce'])), 'fahimptb_taxonomy' ) ) {
        wp_die( 'Nonce verification failed' );
    }
	$formData = isset($_POST['formData']) ? sanitize_text_field(wp_unslash($_POST['formData'])) : '';
   	parse_str($formData, $block);
    try {
        global $wpdb;
      	$table_name = $wpdb->prefix . 'fahimptb_post_table';

      	$taxonomyType = @$block['taxonomy_type'];
	 
	    // Check if data is cached
		$cache_key = 'fahimptb_taxonomy_' . $taxonomyType;
		$cached_result = wp_cache_get($cache_key);
		if ($cached_result === false) {
		    $result = $wpdb->get_results($wpdb->prepare("SELECT 'id' FROM $table_name WHERE `fahimptb_taxonomies` = %s", $taxonomyType));
		    wp_cache_set($cache_key, $result);
		} else {
		    $result = $cached_result;
		}
    	 
		if (count($result) == 0) {

			$data = fahimptb_save_taxonomy_data($block);
			$wpdb->insert($table_name, $data);

			if (isset($block['posts'])) {
				$inserted_id = $wpdb->insert_id;
				foreach ($block['posts'] as $key => $value) {
			    	$data = array(
		                'fahimptb_taxonomies' => $inserted_id
		            );
		            $where = array('id' => $value);
		            $wpdb->update($table_name, $data, $where);
		    	}
		    }
		    flush_rewrite_rules();
	        echo wp_json_encode([
	            'status'=> true,
	            'message'=>'Success'
	        ], true);
		}else{
			echo esc_html('exist');
		}
        wp_die();
    } catch (Exception $e) {
        echo wp_json_encode([
            'status'=>false,
            'message'=>$e->getMessage()
        ], true);
        wp_die();
    }
}


add_action('wp_ajax_fahimptb_update_taxonomy', 'fahimptb_update_taxonomy_handler' );
add_action('wp_ajax_nopriv_fahimptb_update_taxonomy','fahimptb_update_taxonomy_handler');

function fahimptb_update_taxonomy_handler(){
	if ( ! isset( $_POST['fahimptb_taxonomy_update_nonce'] ) || ! wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['fahimptb_taxonomy_update_nonce'])), 'fahimptb_taxonomy_update' ) ) {
        wp_die( 'Nonce verification failed' );
    }

	$id = isset($_POST['id']) ? absint($_POST['id']) : 0;
	$formData = isset($_POST['formData']) ? sanitize_text_field(wp_unslash($_POST['formData'])) : '';
   	parse_str($formData, $block);
 
    try {
        global $wpdb;
      	$table_name = $wpdb->prefix . 'fahimptb_post_table';
      	$taxonomyType = @$block['taxonomy_type'];

	    // Check if data is cached
        $cache_key = 'fahimptb_taxonomy_' . $id;
        $cached_result = wp_cache_get($cache_key);
        if ($cached_result === false) {
            $storedtaxonomiesType = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE `id` = %d", $id))[0];
            wp_cache_set($cache_key, $storedtaxonomiesType);
        } else {
            $storedtaxonomiesType = $cached_result;
        }

	    if ($storedtaxonomiesType->fahimptb_taxonomies === $taxonomyType) {
	    	$data = fahimptb_save_taxonomy_data($block);
 
	        $where = array('id' => $id);
            $wpdb->update($table_name, $data, $where);

            if (isset($block['posts'])) {
            	$inserted_id = $wpdb->insert_id;
            	 
            	foreach ($block['posts'] as $key => $value) {
            		
            		// Check if data is cached
			        $cache_key = 'pacp_post_' . implode('_', $block['posts']);
			        $cached_result = wp_cache_get($cache_key);
			        if ($cached_result === false) {
			            foreach ($block['posts'] as $key => $value) {
			                $result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE `id` = %s", $value))[0];
			                wp_cache_set($cache_key, $result);
			            }
			        } else {
			            $result = $cached_result;
			        }

            		if (strpos($result->fahimptb_taxonomies, ',') !== false) {
            			$array = explode(',', $result->fahimptb_taxonomies);
            			
            			array_push($array, $inserted_id);
 						$uniqueArray = array_unique($array);
            			$ids = implode(',',$uniqueArray);
            		}else{
            			if ($result->fahimptb_taxonomies == $inserted_id) {
							$ids = $inserted_id;
						}else{
							$ids = $result->fahimptb_taxonomies;
						}
            		}
            		$data = array(
		                'fahimptb_taxonomies' => $ids
		            );
		            $where = array('id' => $value);
		            $wpdb->update($table_name, $data, $where);
            	}
            	
				 
		    }
 			flush_rewrite_rules();
	        echo wp_json_encode([
		            'status'=> true,
		            'message'=>'Success'
		        ], true);

	    }else{
	   
	    	$result = $wpdb->get_results($wpdb->prepare("SELECT 'id' FROM $table_name WHERE `fahimptb_taxonomies` = %s", $taxonomyType));

	    	if (count($result) == 0) {

	    		$data = fahimptb_save_taxonomy_data($block);
		        $where = array('id' => $id);
	            $wpdb->update($table_name, $data, $where);
	            flush_rewrite_rules();
		        echo wp_json_encode([
		            'status'=> true,
		            'message'=>'Success'
		        ], true);
	        
			}else{
				echo esc_html('exist');
			}
		}

		wp_die();
    } catch (Exception $e) {
        echo wp_json_encode([
            'status'=>false,
            'message'=>$e->getMessage()
        ], true);
        wp_die();
    }
}


function fahimptb_duplicate_taxonomies($post) {
	global $wpdb;
    $table_name = $wpdb->prefix . 'fahimptb_post_table';
	$newdate = current_time('H:i:s');
   
  	// Check if data is cached
	$cache_key = 'fahimptb_taxonomies_' . $post->fahimptb_taxonomies;
	$cached_result = wp_cache_get($cache_key);
	if ($cached_result === false) {
	    $result = $wpdb->get_results($wpdb->prepare("SELECT 'id' FROM $table_name WHERE `fahimptb_taxonomies` = %s", $post->fahimptb_taxonomies)); 
	    wp_cache_set($cache_key, $result);
	} else {
	    $result = $cached_result;
	}
	$taxonomy_type = $post->fahimptb_taxonomies.'-'.count($result);
 	
	$data = array(
		'title' => $post->title,
        'type' => $post->type,
        'status' => $post->status,
        'singular_name' =>  $post->singular_name,
        'post_type' =>  $post->post_type,
        'fahimptb_taxonomies' => $taxonomy_type,
        'public' => $post->public,
        'hierarchical' => $post->hierarchical,
        'created_at' => $newdate,
        'updated_at' => $newdate
    );
	$taxonomyType = @$block['taxonomy_type'];
    return $data;
}

add_action('wp_ajax_fahimptb_triger_taxonomies', 'fahimptb_triger_taxonomies_handler' );
add_action('wp_ajax_nopriv_fahimptb_triger_taxonomies','fahimptb_triger_taxonomies_handler');
function fahimptb_triger_taxonomies_handler(){
	if (!isset($_POST['fahimptb_triger_taxonomies_nonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['fahimptb_triger_taxonomies_nonce'])), 'fahimptb_triger_taxonomies_nonce')) {
        wp_die('Nonce verification failed');
    }
    global $wpdb;
    $table_name = $wpdb->prefix . 'fahimptb_post_table';
    try {
		$id = isset($_POST['id']) ? absint($_POST['id']) : 0;
 
		$triger = isset($_POST['triger']) ? sanitize_text_field(wp_unslash($_POST['triger'])) : '';
		$newdate = current_time('Y-m-d H:i:s');

		if ($triger == 'trash') {

			$cache_key = 'fahimptb_post_trash';
			$cached_result = wp_cache_get($cache_key);
			if ($cached_result === false) {
			    $result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE `type` = %s", 'post'));
			    wp_cache_set($cache_key, $result);
			} else {
			    $result = $cached_result;
			}

			foreach ($result as $value) {
				if (strpos($value->fahimptb_taxonomies, ',') !== false) {
					$ids = explode(',', $value->fahimptb_taxonomies);
					$ids = array_filter($ids, function ($item) use ($id) {
					    return $item !== $id;
					});
					$ids = array_values($ids);
					$ids = implode(',', $ids);
				}else{
					if ($value->fahimptb_taxonomies == $id) {
						$ids = '';
					}else{
						$ids = $value->fahimptb_taxonomies;
					}
				}
				$data = array(
			        'fahimptb_taxonomies' => $ids
			    );
				$where = array('id' => $value->id);
				$wpdb->update($table_name, $data, $where);
			}
 
	        $wpdb->query($wpdb->prepare("DELETE FROM $table_name WHERE `id` = %d", $id));
	        echo wp_json_encode([
	            'status'=> true,
	            'message'=>'Success'
	        ], true);

	    }elseif($triger == 'activate'){
	    	$data = array(
		        'status' => 1,
		        'updated_at' => $newdate
		    );
	        $where = array('id' => $id);
            $wpdb->update($table_name, $data, $where);
	    }elseif($triger == 'deactivate'){
	    	$data = array(
		        'status' => 0,
		        'updated_at' => $newdate
		    );
	        $where = array('id' => $id);
            $wpdb->update($table_name, $data, $where);

	    }elseif($triger == 'duplicate'){

	  
	    	$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE `id` = %d", $id))[0];
			$data = pacp_duplicate_taxonomies($result);
	        $wpdb->insert($table_name, $data);

	        echo wp_json_encode([
	            'status'=> true,
	            'message'=>'Success'
	        ], true);
	        


	    }
	    flush_rewrite_rules();
        wp_die();
	} catch (Exception $e) {
        echo wp_json_encode([
            'status'=>false,
            'message'=>$e->getMessage()
        ], true);
        wp_die();
    }
}


add_action('wp_ajax_fahimptb_setting_post', 'fahimptb_setting_post_handler' );
add_action('wp_ajax_nopriv_fahimptb_setting_post','fahimptb_setting_post_handler');
function fahimptb_setting_post_handler(){
	global $wpdb;
	$table_name = $wpdb->prefix . 'fahimptb_post_setting';


	// Check if data is cached
	$cache_key = 'fahimptb_post_setting';
	$cached_result = wp_cache_get($cache_key);
	if ($cached_result === false) {
		$result = $wpdb->get_results($wpdb->prepare("SELECT * FROM $table_name WHERE `setting` = %s", 'per_page'))[0]; 
		wp_cache_set($cache_key, $result);
	} else {
		$result = $cached_result;
	}
 
	if (isset($_POST['setting_post_nonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_POST['setting_post_nonce'])), 'setting_post')) {
	    if (isset($_POST['setting_per_pages'])) {

	    	try {
		        $new_value = intval($_POST['setting_per_pages']);
		        $wpdb->update(
		            $table_name,
		            array('data' => $new_value),
		            array('setting' => 'per_page'),
		            array('%d'),
		            array('%s')
		        );

		        echo wp_json_encode([
		            'status'=> true,
		            'message'=>'Success'
		        ], true);
		        wp_die();
	        } catch (Exception $e) {
		        echo wp_json_encode([
		            'status'=>false,
		            'message'=>$e->getMessage()
		        ], true);
		        wp_die();
		    }
	    }
	}

}