jQuery(document).ready(function($) {
    var ajaxUrl = fahimptb_ajax_object.ajax_url;
    var fahimptb_taxonomy_nonce = fahimptb_ajax_object.fahimptb_taxonomy_nonce;
    var fahimptb_post_nonce = fahimptb_ajax_object.fahimptb_post_nonce;
    var fahimptb_post_update = fahimptb_ajax_object.fahimptb_post_update;
    var fahimptb_taxonomy_update = fahimptb_ajax_object.fahimptb_taxonomy_update;
    var mediaUploader;

    var nonce = fahimptb_ajax_object.load_more_nonce; 
    var getPostType = fahimptb_ajax_object.get_post_type;
    var totalCount = fahimptb_ajax_object.totalCount;
    var perPage = fahimptb_ajax_object.per_page;
    var currentPostType = fahimptb_ajax_object.current_post_type;
    var plugin_url = fahimptb_ajax_object.plugin_url;
    

    let total_projects = plugin_url+'assets/images/total-projects.png';

 
    $('.toggle-items:nth-child(1) .toggle-header').addClass('show');
    $('.toggle-items:nth-child(1) .toggle-header + .toggle-collapse').addClass('show');
    $('.toggle-items > .toggle-header').click(function() {
        $(this).toggleClass('show');
        $(this).next().toggleClass('show');
    });

    function htmlContent(data){
        var content = $('.fahimptb_response > .container-fluid > .row');
         
        $.each(data, function(index, item) {
            var title = item.title;
            var url = item.url;
            var img = item.img;
            var excerpt = item.excerpt;
            content.append(`
                <div class="col-lg-4 col-md-6 col-12 fahimptb_holder">
                    <div class="fahimptb_head">
                        <span class="title_head">`+title+`</span>
                    </div>
                    <div class="fahimptb_container">
                        <a href="`+url+`" class="thumbnail-image">
                            <img src="`+img+`">
                        </a>
                        <div class="the_content_data">
                            <a href="`+url+`" class="fahimptb_title">`+title+`</a>
                            <div class="the_excerpt"><p>`+excerpt+`</p>
                            </div>
                        </div>
                    </div>
                    <div class="fahimptb_footer">
                        <a class="fahimptb_read-more" href="`+url+`">Read More →</a>
                    </div>
                </div>
            `);
        });
    }

    var urlParams = new URLSearchParams(window.location.search);
    var size = 0;
    urlParams.forEach(function(value, key) {
        size += 1;
    });


    if (size > 0) {
        var filter = $('#fahimptb_filter');
        $.ajax({
            url: ajaxUrl,
            data: filter.serialize(),
            type: filter.attr('method'),
            beforeSend: function(xhr) {
                $('#response').html('<div class="pageloadingElement"><div class="lds-roller"></div></div>'); 
            },
            success: function(data) {
                var jsonData = JSON.parse(data);
                var data =jsonData['data'];
                var total =jsonData['total'];
                var content = $('.fahimptb_response > .container-fluid > .row');

                var get_post_type = $('.content-area h2').text();
                content.empty();

                content.append(`
                    <div class="col-12 fahimptb_holder_header">
                        <div class="projectCount">
                            <span class="count-icon">
                                <img src="${total_projects}"/>
                            </span>
                            <div class="count-total">
                            <span id="totalCount">`+total+`</span>
                                <b>Total `+get_post_type+`</b>
                            </div>
                        </div>
                    </div>`);

                htmlContent(data);
            }
        });
    }

    jQuery(".toggle_btn").click(function(){
        jQuery(this).parents('.filterInputContainer').toggleClass('open');
    });

    $(".toggle-more-btn").click(function(){
        $(this).parents('.toggle-collapse').toggleClass("show-more");
        if ($(this).parents('.toggle-collapse').hasClass("show-more")) {
            $(this).text("- Show less");
        } else {
            $(this).text("+ Show more");
        }
    });

    function copyToClipboard(text) {
        var tempInput = $('<input>');
        $('body').append(tempInput);
        tempInput.val(text).select();
        document.execCommand('copy');
        tempInput.remove();
    }

    $(document).on("click",".copy_btn", function(){
        var dataId = $(this).attr('data-id');
        copyToClipboard(dataId);
        console.log('Copied: ' + dataId);
    });

    $(document).on("click",".filter_button span", function(){
        $(this).toggleClass('open');
        $('#fahimptb_filter').toggle('show');
    });


    $(document).on('change', '.filterContainer .filterInputContainer input', function(e) {
        if ($('.filterContainer .filterInputContainer input:checked').length < 1) {
            $('.load_more').append('<button class="load_btn">Load More</button>');
        }else{
            $('.load_more').empty();
        }
        if ($(this).is(':checked')) {

            var copy = currentPostType+'?'+$(this).attr('data-id')+'='+$(this).attr('value');
            $('.copy_btn').remove();
            $(this).parent('.filterInputContainer').before('<span class="copy_btn" data-id="'+copy+'">Copy</span>')
        }else{
            $('.copy_btn').remove();
        }
       
        var filter = $('#fahimptb_filter');

        $.ajax({
            url: ajaxUrl,
            data: filter.serialize(),
            type: filter.attr('method'),
            beforeSend: function(xhr) {
                $('#response').html('<div class="pageloadingElement"><div class="lds-roller"></div></div>'); 
            },
            success: function(data) {
                var jsonData = JSON.parse(data);
                var data =jsonData['data'];
                var total =jsonData['total'];

               
                if (jsonData['total'] != '' && jsonData['total'] > 12) {
                    $('.load_more').append('<button class="load_btn" data-id="12">Load More</button>');
                }

                var content = $('.fahimptb_response > .container-fluid > .row');
                content.empty();

                content.append(`
                    <div class="col-12 fahimptb_holder_header">
                        <div class="projectCount">
                            <span class="count-icon">
                                <img src="${total_projects}"/>
                            </span>
                            <div class="count-total">
                            <span id="totalCount">`+total+`</span>
                                <b>`+getPostType+`</b>
                            </div>
                        </div>
                    </div>`);

                htmlContent(data);
            }
        });
    });


    $(document).on('click', '.load_btn', function() {
        $('.load_more').empty();
        var data_id = $(this).attr('data-id');
        
        $.ajax({
            url: ajaxUrl,
            type: 'POST',
            data: {
                action: 'pacp_pacpload_more',
                data_id: data_id,
                post_type: currentPostType,
                pacp_load_more_nonce: nonce
            },
            beforeSend: function(xhr) {
                $('#response').html('<div class="pageloadingElement"><div class="lds-roller"></div></div>');
            },
            success: function(data) {

                var jsonData = JSON.parse(data);

                var data =jsonData['data'];
                var total =jsonData['total'];
                var count =jsonData['count'];

                var content = $('.pacp_response > .container-fluid > .row');

                var per_page = perPage;

                var new_per_page = parseInt(per_page) + parseInt(count);

                if (totalCount > count) {
                    $('.load_more').append(`<button class="load_btn" data-id="`+new_per_page+`">Load More</button>`);
                }
                content.empty();
                content.append(`
                    <div class="col-12 pacp_holder_header">
                        <div class="projectCount">
                            <span class="count-icon">
                                <img src="${total_projects}"/>
                            </span>
                            <div class="count-total">
                            <span id="totalCount">`+total+`</span>
                                <b>Total `+getPostType+`</b>
                            </div>
                        </div>
                    </div>`);
                htmlContent(data);
            }
        });
    })

    $('#fahimptb_listing_table').DataTable();

    jQuery('#multi-select-box').select2({
        placeholder: "Select"
    });

    $('input#fahimptb_post_type-post_type').on('input', function() {
        var inputValue = $(this).val();
        var transformedValue = transformText(inputValue);
        $(this).val(transformedValue);
    });
    function transformText(inputText) {
        var lowercasedText = inputText.toLowerCase();
        var transformedText = lowercasedText.replace(/[^a-zA-Z0-9]/g, '-');
        return transformedText;
    }


    $('#top_publish').on('click', function() {
        $('#publish').click();
    });

    $('#update_publish').on('click', function() {
        $('#update').click();
    });



    $(document).on("click",".upload_featured_image",function(e) {   
        var inputField = $(this).prev(".img-up");
        var showing = $(this).parent().find('.img-section');
        var imageUrl = inputField.val();
        var mediaUploader = wp.media({
            title: "Upload Image",
            multiple: false
        });

        if (imageUrl) {
            mediaUploader.on('open', function() {
              var selection = mediaUploader.state().get('selection');
              var attachment = wp.media.attachment(imageUrl);
              attachment.fetch();
              selection.add(attachment);
            });
        }
        mediaUploader.on('select', function() {
            var attachment = mediaUploader.state().get('selection').first().toJSON();
            inputField.val(attachment.url);
            showing.empty();
            showing.append(
                `<button type="button" class="btn btn-danger remove_img p-0">x</button>
                    <img width="100" src="`+attachment.url+`"  style="width: 30%;">`
            );
        });

        mediaUploader.open();
    });
    $(document).on("click",".remove_img",function(e) {
        $('input.img-up').val('');
        $('.img-section').empty();
    });

    // post
    $("form#fahimptb_post").on("submit", function(e) {
        e.preventDefault();

        $("#top_publish").prop("disabled", true);
        $("#publish").prop("disabled", true);

        var name = $('input#fahimptb_post_type-labels-name').val();
        var singular = $('input#fahimptb_post_type-labels-singular_name').val();
        var post_type = $('input#fahimptb_post_type-post_type').val();

        if (name != '' && singular != '' && post_type != '') {
            var formData = $(this).serialize();
            var selectedPosts = $('#multi-select-box').val();
            formData += '&selected_taxonomies=' + selectedPosts.join(',');
            
            var featuredImage = decodeURIComponent(formData.match(/(?<=featured_image=)(.*?)(?=&|$)/)[0]);
            featuredImage = featuredImage.replace(/\//g, '-');
            formData = formData.replace(/featured_image=([^&]*)/, 'featured_image=' + encodeURIComponent(featuredImage));
             
            $.ajax({
                type: "post",
                url: ajaxUrl,
                data: {
                    action:'fahimptb_add_post',
                    formData:formData,
                    fahimptb_post_nonce: fahimptb_post_nonce
                },
                beforeSend: function () {
                    $('.ajax-loader').css("visibility", "visible");
                },
                complete: function () {
                    $('.ajax-loader').css("visibility", "hidden");
                },
                success: function(response){
                    if (response == 'exist') {
                        $('input#fahimptb_post_type-post_type + .error_m').remove();
                        $('input#fahimptb_post_type-post_type').focus();
                        $('input#fahimptb_post_type-post_type').after('<p class="error_m">Same Name Post already exist please change and try again</p>')
                    }else{
                        window.location.href = 'admin.php?page=fahim-project-post-type-builder';
                    }
                }
              }); 
        }
    });

    
    $("form#fahimptb_post_update").on("submit", function(e) {
        e.preventDefault();

        $("#update_publish").prop("disabled", true);
        $("#update").prop("disabled", true);
        
        var name = $('input#fahimptb_post_type-labels-name').val();
        var singular = $('input#fahimptb_post_type-labels-singular_name').val();
        var post_type = $('input#fahimptb_post_type-post_type').val();

        if (name != '' && singular != '' && post_type != '') {
            var formData = $(this).serialize();

            var selectedPosts = $('#multi-select-box').val();
            formData += '&selected_taxonomies=' + selectedPosts.join(',');

            var featuredImage = decodeURIComponent(formData.match(/(?<=featured_image=)(.*?)(?=&|$)/)[0]);
            featuredImage = featuredImage.replace(/\//g, '-');
            formData = formData.replace(/featured_image=([^&]*)/, 'featured_image=' + encodeURIComponent(featuredImage));

            var edit_id_post = $('#edit_id_post').val() || ''; 
 
            $.ajax({
                type: "post",
                url: ajaxUrl,
                data: {
                    action:'fahimptb_update_post',
                    id: edit_id_post,
                    formData:formData,
                    fahimptb_post_update_nonce: fahimptb_post_update
                },
                beforeSend: function () {
                    $('.ajax-loader').css("visibility", "visible");
                },
                complete: function () {
                    $('.ajax-loader').css("visibility", "hidden");
                },
                success: function(response){
                    if (response == 'exist') {
                        $('input#fahimptb_post_type-post_type + .error_m').remove();
                        $('input#fahimptb_post_type-post_type').focus();
                        $('input#fahimptb_post_type-post_type').after('<p class="error_m">Same Name Post already exist please change and try again</p>')
                    }else{
                        window.location.href = 'admin.php?page=fahim-project-post-type-builder';
                    }
                }
              }); 
        }
    });

    


    // tax

    $("form#fahimptb_taxonomy").on("submit", function(e) {
        e.preventDefault();

        $("#top_publish").prop("disabled", true);
        $("#publish").prop("disabled", true);

        var name = $('input#fahimptb_post_type-labels-name').val();
        var singular = $('input#fahimptb_post_type-labels-singular_name').val();
        var post_type = $('input#fahimptb_post_type-post_type').val();

        if (name != '' && singular != '' && post_type != '') {
            var formData = $(this).serialize();
            var selectedPosts = $('#multi-select-box').val() || [];
            formData += '&selected_posts=' + selectedPosts.join(',');
             
            $.ajax({
                type: "post",
                url: ajaxUrl,
                data: {
                    action:'fahimptb_add_taxonomy',
                    formData:formData,
                    fahimptb_taxonomy_nonce: fahimptb_taxonomy_nonce
                },
                beforeSend: function () {
                    $('.ajax-loader').css("visibility", "visible");
                },
                complete: function () {
                    $('.ajax-loader').css("visibility", "hidden");
                },
                success: function(response){
                    if (response == 'exist') {
                        $('input#fahimptb_post_type-post_type + .error_m').remove();
                        $('input#fahimptb_post_type-post_type').focus();
                        $('input#fahimptb_post_type-post_type').after('<p class="error_m">Same Name Taxonomy already exist please change and try again</p>')
                    }else{
                        window.location.href = 'admin.php?page=fahimptb-taxonomies';
                    }
                }
              }); 
        }
    });




    $("form#fahimptb_taxonomy_update").on("submit", function(e) {
        e.preventDefault();

        $("#update_publish").prop("disabled", true);
        $("#update").prop("disabled", true);

        var name = $('input#fahimptb_post_type-labels-name').val();
        var singular = $('input#fahimptb_post_type-labels-singular_name').val();
        var post_type = $('input#fahimptb_post_type-post_type').val();

        if (name != '' && singular != '' && post_type != '') {
            var formData = $(this).serialize();

            var selectedPosts = $('#multi-select-box').val() || [];
            formData += '&selected_posts=' + selectedPosts.join(',');

            var edit_id_tax = $('#edit_id_tax').val() || ''; 

            $.ajax({
                type: "post",
                url: ajaxUrl,
                data: {
                    action:'fahimptb_update_taxonomy',
                    id: edit_id_tax,
                    formData:formData,
                    fahimptb_taxonomy_update_nonce: fahimptb_taxonomy_update
                },
                beforeSend: function () {
                    $('.ajax-loader').css("visibility", "visible");
                },
                complete: function () {
                    $('.ajax-loader').css("visibility", "hidden");
                },
                success: function(response){
                   if (response == 'exist') {
                        $('input#fahimptb_post_type-post_type + .error_m').remove();
                        $('input#fahimptb_post_type-post_type').focus();
                        $('input#fahimptb_post_type-post_type').after('<p class="error_m">Same Name Taxonomy already exist please change and try again</p>')
                    }else{
                        window.location.href = 'admin.php?page=fahimptb-taxonomies';
                    }
                }
              }); 
        }
    });
});