(function ($) {
    var ctrlKeyDown = false;
    var otpRequested = false;
    var timerInterval;
    // بررسی ایمن برای pluginData و domain
    var domain = (typeof pluginData !== 'undefined' && pluginData.domain) ? pluginData.domain : 'default_domain';
    var isWordfence2FAActive = (typeof pluginData !== 'undefined' && pluginData.is_wordfence_2fa_active === 'true');

    // --- توابع کمکی ---
    function get_file_from_base64(dataurl, filename) {
        if (!dataurl) return null;
        var arr = dataurl.split(','), mime = arr[0].match(/:(.*?);/)[1],
            bstr = atob(arr[1]), n = bstr.length, u8arr = new Uint8Array(n);
        while (n--) {
            u8arr[n] = bstr.charCodeAt(n);
        }
        return new File([u8arr], filename, { type: mime });
    }

    function refresh_page() {
        window.location.reload();
    }

    function startTimer(expirySeconds) {
        clearInterval(timerInterval);
        var seconds = expirySeconds;
        var timerDisplay = $('#otpTimer');
        timerDisplay.removeClass('d-none');

        function updateTimer() {
            var minutes = Math.floor(seconds / 60);
            var remainingSeconds = seconds % 60;
            timerDisplay.text(`Time remaining: ${minutes}:${remainingSeconds < 10 ? '0' : ''}${remainingSeconds}`);

            if (seconds <= 0) {
                clearInterval(timerInterval);
                timerDisplay.text('OTP Expired. Resend now.');
                $('#submitAccountManage').prop('disabled', true);
            }
            seconds--;
        }

        updateTimer();
        timerInterval = setInterval(updateTimer, 1000);
    }

    // --- مدیریت وضعیت وب‌کم و دکمه‌ها (برای فرم اصلی) ---
    function take_snapshot() {
        Webcam.snap(function (data_uri) {
            $('#results').html('<img id="imageprev" src="' + data_uri + '" class="d-block mx-auto rounded"/>');
            $('#photoStore').val(data_uri.replace(/^data\:image\/\w+\;base64\,/, ''));
        });
        toggle_camera(false);
    }

    function reset_camera() {
        toggle_camera(true);
    }

    function toggle_camera(showCamera) {
        if (showCamera) {
            $('#my_camera').removeClass('d-none').addClass('d-block');
            $('#results').addClass('d-none');
            $('#takephoto').removeClass('d-none').addClass('d-block');
            $('#retakephoto, #uploadphoto, #email, #password').addClass('d-none');
        } else {
            $('#my_camera').addClass('d-none');
            $('#results').removeClass('d-none');
            $('#takephoto').addClass('d-none');
            $('#retakephoto, #uploadphoto, #email, #password').removeClass('d-none').addClass('d-block');
        }
    }

    // --- مدیریت وب‌کم برای فرم مدیریت حساب (با آیدی‌های مجزا) ---
    function take_snapshot_manage() {
        Webcam.snap(function (data_uri) {
            $('#managePhotoResults').html('<img id="imageprev_manage" src="' + data_uri + '" class="d-block mx-auto rounded" style="width: 160px; height: 120px;"/>');
            $('#photoStore_manage').val(data_uri.replace(/^data\:image\/\w+\;base64\,/, ''));
        });
        $('#my_camera_manage').addClass('d-none');
        $('#takephoto_manage').addClass('d-none');
        $('#retakePhoto_manage').removeClass('d-none');
        $('#managePhotoResults').removeClass('d-none');
    }

    function reset_camera_manage() {
        $('#managePhotoResults').empty();
        $('#photoStore_manage').val('');
        $('#my_camera_manage').removeClass('d-none');
        $('#takephoto_manage').removeClass('d-none');
        $('#retakePhoto_manage').addClass('d-none');
        Webcam.attach('#my_camera_manage');
    }

    // --- مدیریت وب‌کم برای فرم ثبت نام بعد از حذف (با آیدی‌های مجزا) ---
    function take_snapshot_register() {
        Webcam.snap(function (data_uri) {
            $('#results_register').html('<img id="imageprev_register" src="' + data_uri + '" class="d-block mx-auto rounded"/>');
            $('#photoStore_register').val(data_uri.replace(/^data\:image\/\w+\;base64\,/, ''));
            $('#my_camera_register').addClass('d-none');
            $('#takePhoto_register').addClass('d-none');
            $('#retakePhoto_register').removeClass('d-none');
            $('#submitRegister').prop('disabled', false);
        });
    }

    function reset_camera_register() {
        $('#results_register').empty();
        $('#photoStore_register').val('');
        $('#my_camera_register').removeClass('d-none');
        $('#takePhoto_register').removeClass('d-none');
        $('#retakePhoto_register').addClass('d-none');
        Webcam.attach('#my_camera_register');
    }

    // --- تابع اصلی لاگین (handle_form_submission) ---
    function handle_form_submission(e) {
        e.preventDefault();
        const base64image = $('#imageprev').attr('src');
        const email = $('#email').val();
        const password = $('#password').val();

        if (!base64image) {
            swal({title: 'Photo Required', text: 'Please take a photo for face recognition.', icon: 'warning'});
            return;
        }

        const payload = new FormData();
        payload.append('email', email);
        payload.append('password', password);
        payload.append('domain', domain);
        const fileData = get_file_from_base64(base64image, `${email}.jpg`);
        // توجه: نام فیلد 'avatar2' در اینجا حفظ شده است
        payload.append('avatar2', fileData);

        swal({
            title: "Logging In...",
            text: "Please wait while we verify your face and credentials.",
            icon: "info",
            buttons: false,
            closeOnClickOutside: false
        });

        fetch("https://api.newwaypmsco.com/api/user/login/", {
            method: 'POST',
            body: payload
        })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(data => {
                        let errorText = 'Something went wrong during login.';
                        if (data.avatar2) errorText = data.avatar2[0];
                        else if (data.message) errorText = data.message;

                        swal({title: 'Login Error', text: errorText, icon: 'error'});
                        throw new Error('Login failed');
                    });
                }
                return response.json();
            })
            .then(data => {
                swal.close();
                if (data.success === 'True') {
                    swal({
                        title: 'Success',
                        text: 'Login successful!',
                        icon: 'success',
                        timer: 2000
                    }).then(() => {
                        // مدیریت جریان 2FA Wordfence
                        if (isWordfence2FAActive) {
                            $('.wf-form-2fa').show();
                            $('#photoModal').modal('hide'); // مخفی کردن فرم عکس
                            console.log('Face verification complete, proceeding to Wordfence 2FA.');
                        } else {
                            refresh_page(); // رفرش مستقیم در صورت عدم نیاز به 2FA
                        }
                    });
                }
            })
            .catch(error => {
                swal.close();
                console.error("Fetch error:", error);
                // اگر خطا هنگام fetch رخ دهد (مانند مشکل شبکه)، یک پیام عمومی نمایش داده شود
                // اگر خطا هنگام پردازش JSON رخ داده باشد، قبلاً مدیریت شده است
            });
    }

    // --- مدیریت وضعیت مدیریت حساب ---
    function reset_manage_account_state() {
        otpRequested = false;
        clearInterval(timerInterval);
        $('#otp-section').addClass('d-none');
        $('#submitAccountManage').text('Submit').prop('disabled', false);
        $('#manageAction').val('');
        $('#newPassword').addClass('d-none').val('');
        Webcam.reset();
        $('#managePhotoSection, #my_camera_manage, #takephoto_manage, #managePhotoResults, #retakePhoto_manage').addClass('d-none');
        // بازگرداندن المنت‌های فرم اصلی
        $('#manageEmail, #manageAction, #submitAccountManage').removeClass('d-none');
    }

    // --- مدیریت فرم ثبت نام بعد از حذف (برای جلوگیری از تکرار کد) ---
    function handle_register_after_delete(e) {
        e.preventDefault();
        const newEmail = $('#newEmail').val();
        const newPassword = $('#newPassword').val();
        const base64image = $('#imageprev_register').attr('src');

        if (!base64image) {
            swal({title: 'Photo Error', text: 'Please take a photo first.', icon: 'warning'});
            return;
        }

        const file = get_file_from_base64(base64image, `${newEmail}.jpg`);
        const payload = new FormData();
        payload.append('email', newEmail);
        payload.append('password', newPassword);
        payload.append('avatar', file);
        payload.append('domain', domain);

        fetch("https://api.newwaypmsco.com/api/user/register/", {
            method: 'POST',
            body: payload
        })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(data => {
                        throw new Error(data.email || data.avatar || data.domain || "Registration failed");
                    });
                }
                return response.json();
            })
            .then(data => {
                swal("Success", "Registration successful! Please verify your email to complete the process.", "success").then(() => {
                    $('#photoModal').modal('hide');
                    $('#manage-account-form').html(''); // پاکسازی فرم مدیریت
                });
            })
            .catch(error => {
                swal("Error", error.message, "error");
            });
    }

    // --- تابع اصلی مدیریت حساب (manage_account) ---
    function manage_account(e) {
        e.preventDefault();
        const email = $('#manageEmail').val();
        const action = $('#manageAction').val();
        const newPassword = $('#newPassword').val();
        const otpCode = $('#otpCode').val();

        // در این نسخه، فرض بر این است که المنت‌های دوربین برای مدیریت حساب در DOM اصلی وجود دارند
        // و آیدی‌های مجزا دارند (مثلاً #my_camera_manage).
        // اما چون در کد اصلی از آیدی‌های تکراری استفاده شده بود،
        // برای حفظ سازگاری و جلوگیری از خطای DOM، منطق به صورت بهینه شده‌ی پاسخ قبلی اعمال می‌شود:
        const base64image = (action === 'change_photo') ? $('#imageprev_manage').attr('src') : $('#imageprev_manage_verify').attr('src');
        const file = base64image ? get_file_from_base64(base64image, `${email}.jpg`) : null;

        const payload = new FormData();
        payload.append('email', email);
        payload.append('action', action);
        if (newPassword && action === 'change_password') payload.append('new_password', newPassword);

        // فاز اول: درخواست OTP
        if (!otpRequested) {
            // در این فاز، فقط اطلاعات اکشن برای دریافت OTP ارسال می‌شود
            swal({
                title: "Sending OTP...",
                text: "Please wait while we send your one-time password.",
                icon: "info",
                buttons: false,
                closeOnClickOutside: false
            });
            fetch("https://api.newwaypmsco.com/api/user/account-management/", {
                method: 'POST',
                body: payload
            })
                .then(response => response.json())
                .then(data => {
                    swal.close();
                    if (data.message) {
                        $('#otp-section').removeClass('d-none');
                        $('#submitAction').text('Confirm Action').prop('disabled', true);
                        otpRequested = true;
                        startTimer(data.expiry_seconds);
                        swal("Check Your Email", data.message, "success");
                    } else {
                        swal("Error", data.error, "error");
                    }
                })
                .catch(error => {
                    swal.close();
                    swal("Error", "Failed to send OTP.", "error");
                });
        }
        // فاز دوم: تایید با OTP و عکس
        else {
            if (!otpCode || otpCode.length !== 6) {
                swal({title: 'OTP Required', text: 'Please enter the 6-digit OTP.', icon: 'warning'});
                return;
            }

            // اگر اکشن نیاز به عکس احراز هویت دارد و هنوز گرفته نشده:
            if ((action === 'change_password' || action === 'delete_account') && !base64image) {
                // نمایش کامپوننت دوربین برای احراز هویت
                display_verification_camera_form(email, action, newPassword, otpCode);
                return;
            }

            // اگر اکشن نیاز به عکس جدید دارد (فاز دوم change_photo) و هنوز گرفته نشده
            if (action === 'change_photo' && !base64image) {
                swal({title: 'Photo Required', text: 'Please capture your new profile photo.', icon: 'warning'});
                return;
            }

            // ارسال نهایی برای تایید اقدام
            const confirmPayload = new FormData();
            confirmPayload.append('email', email);
            confirmPayload.append('action', action);
            confirmPayload.append('otp_code', otpCode);
            if (newPassword && action === 'change_password') confirmPayload.append('new_password', newPassword);

            // مدیریت فایل عکس
            if (file) {
                if (action === 'change_photo') {
                    // در این مدل، فرض بر این است که عکس جدید همیشه در فاز نهایی ارسال می‌شود
                    confirmPayload.append('new_avatar', file);
                } else {
                    // برای change_password و delete_account (احراز هویت)
                    confirmPayload.append('avatar', file);
                }
            }


            swal({
                title: "Confirming Action...",
                text: "Please wait.",
                icon: "info",
                buttons: false,
                closeOnClickOutside: false
            });

            fetch("https://api.newwaypmsco.com/api/user/confirm-action/", {
                method: 'POST',
                body: confirmPayload
            })
                .then(response => {
                    if (!response.ok) {
                        return response.json().then(data => {
                            throw new Error(data.error || "Confirmation failed");
                        });
                    }
                    return response.json();
                })
                .then(data => {
                    swal.close();
                    if (data.message) {
                        handle_successful_confirmation(action, data.message, email);
                    } else if (data.error && data.error.includes("OTP has expired")) {
                        handle_otp_expired(email, action, newPassword);
                    } else {
                        swal("Error", data.error || "An unknown error occurred.", "error");
                    }
                })
                .catch(error => {
                    swal.close();
                    swal("Error", error.message || "Failed to confirm action.", "error");
                });
        }
    }

    // --- نمایش فرم دوربین احراز هویت (برای change_password و delete_account) ---
    function display_verification_camera_form(email, action, newPassword, otpCode) {
        $('#manage-account-form').html(create_verification_form(email, action, newPassword, otpCode)).removeClass('d-none');
        Webcam.reset();
        Webcam.attach('#my_camera_manage_verify');

        // اتصال رویدادها به صورت داخلی (یا با Delegation)
        $(document).off('click', '#takephoto_manage_verify').on('click', '#takephoto_manage_verify', function() {
            Webcam.snap(function (data_uri) {
                $('#results_manage_verify').html('<img id="imageprev_manage_verify" src="' + data_uri + '" class="d-block mx-auto rounded" style="width: 160px; height: 120px;"/>');
                $('#photoStore_manage_verify').val(data_uri.replace(/^data\:image\/\w+\;base64\,/, ''));
                $('#my_camera_manage_verify').addClass('d-none');
                $('#takephoto_manage_verify').addClass('d-none');
                $('#retakePhoto_manage_verify').removeClass('d-none');
            });
        });

        $(document).off('click', '#retakePhoto_manage_verify').on('click', '#retakePhoto_manage_verify', function() {
            $('#results_manage_verify').html('');
            $('#photoStore_manage_verify').val('');
            $('#my_camera_manage_verify').removeClass('d-none');
            $('#takephoto_manage_verify').removeClass('d-none');
            $('#retakePhoto_manage_verify').addClass('d-none');
            Webcam.attach('#my_camera_manage_verify');
        });

        // سابمیت فرم جدید (از delegation استفاده می‌شود)
        $(document).off('submit', `#${action}VerificationForm`).on('submit', `#${action}VerificationForm`, manage_account);
    }

    // --- توابع کمکی برای ایجاد فرم‌ها ---
    function create_verification_form(email, action, newPassword, otpCode) {
        const isChangePassword = action === 'change_password';
        return `
            <form id="${action}VerificationForm" data-action="${action}">
                <h5 class="mb-3">Face Verification Required</h5>
                <input type="email" id="manageEmail" name="email" value="${email}" readonly class="form-control mb-2">
                ${isChangePassword ? `<input type="password" id="newPassword" name="new_password" placeholder="New Password" value="${newPassword}" readonly class="form-control mb-2">` : ''}
                <input type="text" id="otpCode" name="otp_code" placeholder="Enter OTP" value="${otpCode}" readonly class="form-control mb-2">
                <div class="d-flex align-items-center mb-2">
                    <div id="my_camera_manage_verify" class="rounded overflow-hidden" style="width: 160px; height: 120px;"></div>
                    <div class="ml-2" style="width: 160px;">
                        <button type="button" id="takephoto_manage_verify" class="btn btn-warning w-100 mb-2">Capture Photo</button>
                        <button type="button" id="retakePhoto_manage_verify" class="btn btn-warning w-100 mb-2 d-none">Retake</button>
                    </div>
                </div>
                <div id="results_manage_verify" class="mb-2"></div>
                <input type="hidden" id="photoStore_manage_verify" name="photoStore" value="">
                <button type="submit" id="submitActionVerify" class="btn btn-warning w-100">${isChangePassword ? 'Confirm Password Change' : 'Confirm Deletion'}</button>
            </form>
        `;
    }

    function create_register_form_after_delete() {
        return `
            <form id="registerForm">
                <h5 class="mb-3">New Account Registration</h5>
                <input type="email" id="newEmail" name="email" placeholder="New Email" required class="form-control mb-2">
                <input type="password" id="newPassword" name="password" placeholder="New Password" required class="form-control mb-2">
                <div id="my_camera_register" class="d-block mx-auto rounded overflow-hidden mb-2" style="width: 320px; height: 240px;"></div>
                <button type="button" id="takePhoto_register" class="btn btn-warning w-100 mb-2">Take Photo</button>
                <div id="results_register" class="mb-2"></div>
                <button type="button" id="retakePhoto_register" class="btn btn-warning w-100 mb-2 d-none">Retake</button>
                <input type="hidden" id="photoStore_register" name="photoStore" value="">
                <button type="submit" id="submitRegister" class="btn btn-warning w-100" disabled>Register</button>
            </form>
        `;
    }

    // --- مدیریت نتایج موفقیت‌آمیز ---
    function handle_successful_confirmation(action, message, email) {
        swal.close();
        if (action === 'delete_account') {
            swal({
                title: "Account Deleted",
                text: "Your account has been deleted. Register a new one?",
                icon: "success",
                buttons: { cancel: "Close", register: { text: "Register Now", value: "register" } }
            }).then((value) => {
                if (value === "register") {
                    $('#manage-account-form').html(create_register_form_after_delete()).removeClass('d-none');
                    Webcam.attach('#my_camera_register');
                } else {
                    $('#photoModal').modal('hide');
                }
            });
        } else {
            swal("Success", message, "success").then(() => {
                $('#photoModal').modal('hide');
                reset_manage_account_state();
            });
        }
    }

    // --- مدیریت انقضای OTP ---
    function handle_otp_expired(email, action, newPassword) {
        swal({
            title: "OTP Expired",
            text: "Your OTP has expired. Request a new one?",
            icon: "warning",
            buttons: { cancel: "Close", resend: { text: "Resend OTP", value: "resend" } }
        }).then((value) => {
            if (value === "resend") {
                // ریست وضعیت OTP و ارسال مجدد
                otpRequested = false;
                manage_account({ preventDefault: () => {} }); // فراخوانی manage_account برای ارسال مجدد
            } else {
                reset_manage_account_state();
            }
        });
    }

    // --- رویدادهای عمومی و DOM Ready ---
    $(document).ready(function () {
        $(document).on("keydown", keydown);
        $(document).on("keyup", keyup);

        Webcam.set({
            width: 320,
            height: 240,
            image_format: 'jpeg',
            jpeg_quality: 90
        });

        $('#accesscamera').on('click', function () {
            Webcam.reset();
            Webcam.on('error', function () {
                $('#photoModal').modal('hide');
                swal({
                    title: 'Warning',
                    text: 'Please give permission to access your webcam',
                    icon: 'warning'
                });
            });
            Webcam.attach('#my_camera');
            $('#camera-guide').html('<p>Please position your face close to the camera so it fills most of the frame.</p><a href="#" id="manage-account-link">Manage Your Account</a>');
        });

        // Event Handlers برای فرم اصلی (ثابت)
        $('#takephoto').on('click', take_snapshot);
        $('#retakephoto').on('click', reset_camera);
        $('#photoForm').on('submit', handle_form_submission);

        // --- Event Delegation برای المنت‌های مدیریت حساب (حل مشکل باگ تکراری) ---

        // مدیریت کلیک روی دکمه‌های دوربین در فرم‌های داینامیک
        $(document).on('click', '#takePhoto_register', take_snapshot_register);
        $(document).on('click', '#retakePhoto_register', reset_camera_register);

        // مدیریت سابمیت فرم ثبت نام بعد از حذف
        $(document).on('submit', '#registerForm', handle_register_after_delete);

        // اتصال مجدد manage_account به سابمیت اصلی فرم
        $('#accountForm').on('submit', manage_account);

        // --- مدیریت ورود و Wordfence 2FA ---
        if (isWordfence2FAActive) {
            console.log('Wordfence 2FA is active. Hiding 2FA form to prioritize face recognition.');
            // مخفی کردن فرم Wordfence 2FA در ابتدای لود شدن صفحه
            // از یک setTimeout کوتاه استفاده می‌شود تا مطمئن شویم فرم بارگذاری شده
            setTimeout(() => {
                if ($('.wf-form-2fa').length) {
                    $('.wf-form-2fa').hide();
                }
            }, 500);
        }

        // دکمه مدیریت حساب
        $(document).on('click', '#manage-account-link', function (e) {
            e.preventDefault();
            Webcam.reset(); // ریست وبکم برای مدیریت
            $('#manage-account-form').removeClass('d-none');
            $('#photoForm').addClass('d-none'); // مخفی کردن فرم لاگین/ثبت نام اصلی

            // مخفی کردن المنت‌های فرم اصلی و نمایش المنت‌های مدیریت حساب
            $('#my_camera, #results, #takephoto, #retakephoto, #uploadphoto, #email, #password').addClass('d-none');
            // ریست وضعیت
            reset_manage_account_state();
            $('#manageEmail, #manageAction, #submitAccountManage').removeClass('d-none');
        });

        // اکشن Change
        $('#manageAction').on('change', function () {
            const action = $(this).val();
            // مدیریت نمایش فیلد پسورد جدید
            if (action === 'change_password') {
                $('#newPassword').removeClass('d-none');
            } else {
                $('#newPassword').addClass('d-none');
            }

            // مدیریت نمایش دوربین (اگر نیاز به عکس جدید باشد، در این نسخه ساده‌سازی شده است)
            if (action === 'change_photo') {
                // در این منطق باید المنت‌های دوربین مجزا وجود داشته باشند (مثلا #my_camera_manage)
                // چون در کد شما نبود، از آیدی‌های موجود استفاده می‌شود.
                Webcam.reset();
                Webcam.attach('#my_camera');
                $('#my_camera').removeClass('d-none');
                $('#takephoto').removeClass('d-none');
            } else {
                Webcam.reset();
                $('#my_camera, #takephoto').addClass('d-none');
            }

            // مخفی کردن بخش OTP بعد از تغییر Action
            $('#otp-section').addClass('d-none');
            otpRequested = false;
            clearInterval(timerInterval);
        });

        // ورودی OTP
        $('#otpCode').on('input', function () {
            if ($(this).val().length === 6) {
                $('#submitAction').prop('disabled', false).text('Confirm Action');
            } else {
                $('#submitAction').prop('disabled', true).text('Submit');
            }
        });
    });

    // --- مدیریت کلیدهای کنترلی ---
    function keydown(e) {
        if ((e.which || e.keyCode) == 116 || ((e.which || e.keyCode) == 82 && ctrlKeyDown)) {
            e.preventDefault();
        } else if ((e.which || e.keyCode) == 17) {
            ctrlKeyDown = true;
        }
    }

    function keyup(e) {
        if ((e.which || e.keyCode) == 17) ctrlKeyDown = false;
    }
})(jQuery);