(function ($) {
    var ctrlKeyDown = false;
    var otpRequested = false;
    var timerInterval;
    // فرض بر این است که این متغیر در محیط کد تعریف شده است
    var domain = (typeof pluginData !== 'undefined' && pluginData.domain) ? pluginData.domain : 'default_domain';

    $(document).ready(function () {
        $(document).on("keydown", keydown);
        $(document).on("keyup", keyup);

        Webcam.set({
            width: 320,
            height: 240,
            image_format: 'jpeg',
            jpeg_quality: 90
        });

        $('#accesscamera').on('click', function () {
            Webcam.reset();
            Webcam.on('error', function () {
                $('#photoModal').modal('hide');
                swal({
                    title: 'Warning',
                    text: 'Please give permission to access your webcam',
                    icon: 'warning'
                });
            });
            Webcam.attach('#my_camera');
            $('#camera-guide').html('<p>Please position your face close to the camera so it fills most of the frame.</p><a href="#" id="manage-account-link">Manage Your Account</a>');
        });

        $('#takephoto').on('click', take_snapshot);
        $('#retakephoto').on('click', reset_camera);
        $('#photoForm').on('submit', handle_form_submission);

        $(document).on('click', '#manage-account-link', function (e) {
            e.preventDefault();
            Webcam.reset(); // برای جلوگیری از تداخل
            $('#manage-account-form').removeClass('d-none');
            $('#photoForm').addClass('d-none'); // مخفی کردن فرم ثبت نام
            // مخفی کردن المنت‌های فرم ثبت نام و نمایش المنت‌های فرم مدیریت
            $('#my_camera, #results, #takephoto, #retakephoto, #uploadphoto, #email, #password').addClass('d-none');

            // نمایش اولیه المنت‌های مدیریت حساب
            $('#manageEmail, #manageAction, #submitAccountManage').removeClass('d-none');
            $('#newPassword, #otp-section, #managePhotoSection, #managePhotoResults').addClass('d-none');
            $('#manageAction').val(''); // ریست کردن اکشن
            otpRequested = false;
        });

        $('#manageAction').on('change', function () {
            const action = $(this).val();
            // مدیریت نمایش فیلد پسورد جدید
            if (action === 'change_password') {
                $('#newPassword').removeClass('d-none');
            } else {
                $('#newPassword').addClass('d-none');
            }

            // مدیریت نمایش دوربین
            if (action === 'change_photo') {
                $('#managePhotoSection').removeClass('d-none');
                $('#my_camera_manage').removeClass('d-none');
                $('#takephoto_manage').removeClass('d-none');
                Webcam.reset(); // ریست وبکم
                Webcam.attach('#my_camera_manage');
                $('#managePhotoResults, #retakePhoto_manage').addClass('d-none');
            } else {
                Webcam.reset();
                $('#managePhotoSection, #my_camera_manage, #takephoto_manage, #managePhotoResults, #retakePhoto_manage').addClass('d-none');
            }

            // مخفی کردن بخش OTP بعد از تغییر Action
            $('#otp-section').addClass('d-none');
            otpRequested = false;
            clearInterval(timerInterval);
        });

        $('#otpCode').on('input', function () {
            if ($(this).val().length === 6) {
                $('#submitAccountManage').prop('disabled', false).text('Confirm Action');
            } else {
                $('#submitAccountManage').prop('disabled', true).text('Submit');
            }
        });

        $('#accountForm').on('submit', manage_account);

        // **EVENT DELEGATION برای المنت‌های داینامیک داخل فرم مدیریت حساب**

        // دکمه‌های فرم ثبت نام (برای زمانی که کاربر بعد از حذف حساب، مجدداً ثبت نام می‌کنه)
        $(document).on('click', '#registerForm #takePhoto', take_snapshot_register);
        $(document).on('click', '#registerForm #retakePhoto', reset_camera_register);
        $(document).on('submit', '#registerForm', handle_register_after_delete);

        // دکمه‌های فرم مدیریت عکس
        $(document).on('click', '#managePhotoSection #takephoto_manage', take_snapshot_manage);
        $(document).on('click', '#managePhotoSection #retakePhoto_manage', reset_camera_manage);
    });

    // **توابع مدیریت رویدادهای عمومی**
    function keydown(e) {
        if ((e.which || e.keyCode) == 116 || ((e.which || e.keyCode) == 82 && ctrlKeyDown)) {
            e.preventDefault();
        } else if ((e.which || e.keyCode) == 17) {
            ctrlKeyDown = true;
        }
    }

    function keyup(e) {
        if ((e.which || e.keyCode) == 17) ctrlKeyDown = false;
    }

    // **توابع مدیریت وب‌کم برای فرم ثبت نام اصلی**
    function take_snapshot() {
        Webcam.snap(function (data_uri) {
            $('#results').html('<img id="imageprev" src="' + data_uri + '" class="d-block mx-auto rounded"/>');
            $('#photoStore').val(data_uri.replace(/^data\:image\/\w+\;base64\,/, ''));
        });
        toggle_camera(false);
    }

    function reset_camera() {
        toggle_camera(true);
    }

    function toggle_camera(showCamera) {
        if (showCamera) {
            $('#my_camera').removeClass('d-none').addClass('d-block');
            $('#results').addClass('d-none');
            $('#takephoto').removeClass('d-none').addClass('d-block');
            $('#retakephoto, #uploadphoto, #email, #password').addClass('d-none');
        } else {
            $('#my_camera').addClass('d-none');
            $('#results').removeClass('d-none');
            $('#takephoto').addClass('d-none');
            $('#retakephoto, #uploadphoto, #email, #password').removeClass('d-none').addClass('d-block');
        }
    }

    // **توابع مدیریت وب‌کم برای فرم مدیریت حساب (Change Photo)**
    function take_snapshot_manage() {
        Webcam.snap(function (data_uri) {
            $('#managePhotoResults').html('<img id="imageprev_manage" src="' + data_uri + '" class="d-block mx-auto rounded" style="width: 160px; height: 120px;"/>');
            $('#photoStore_manage').val(data_uri.replace(/^data\:image\/\w+\;base64\,/, ''));
        });
        $('#my_camera_manage').addClass('d-none');
        $('#takephoto_manage').addClass('d-none');
        $('#retakePhoto_manage').removeClass('d-none');
        $('#managePhotoResults').removeClass('d-none');
    }

    function reset_camera_manage() {
        $('#managePhotoResults').empty();
        $('#my_camera_manage').removeClass('d-none');
        $('#takephoto_manage').removeClass('d-none');
        $('#retakePhoto_manage').addClass('d-none');
        Webcam.attach('#my_camera_manage');
    }

    // **توابع مدیریت وب‌کم برای فرم ثبت نام بعد از حذف حساب**
    function take_snapshot_register() {
        Webcam.snap(function (data_uri) {
            $('#results_register').html('<img id="imageprev_register" src="' + data_uri + '" class="d-block mx-auto rounded"/>');
            $('#photoStore_register').val(data_uri.replace(/^data\:image\/\w+\;base64\,/, ''));
            $('#my_camera_register').addClass('d-none');
            $('#takePhoto').addClass('d-none');
            $('#retakePhoto').removeClass('d-none');
            $('#submitRegister').prop('disabled', false);
        });
    }

    function reset_camera_register() {
        $('#results_register').empty();
        $('#my_camera_register').removeClass('d-none');
        $('#takePhoto').removeClass('d-none');
        $('#retakePhoto').addClass('d-none');
        Webcam.attach('#my_camera_register');
    }

    // **توابع کمکی**
    function get_file_from_base64(dataurl, filename) {
        if (!dataurl) return null;
        var arr = dataurl.split(','), mime = arr[0].match(/:(.*?);/)[1],
            bstr = atob(arr[1]), n = bstr.length, u8arr = new Uint8Array(n);
        while (n--) {
            u8arr[n] = bstr.charCodeAt(n);
        }
        return new File([u8arr], filename, { type: mime });
    }

    function startTimer(expirySeconds) {
        clearInterval(timerInterval);
        var seconds = expirySeconds;
        var timerDisplay = $('#otpTimer');
        timerDisplay.removeClass('d-none');

        function updateTimer() {
            var minutes = Math.floor(seconds / 60);
            var remainingSeconds = seconds % 60;
            timerDisplay.text(`Time remaining: ${minutes}:${remainingSeconds < 10 ? '0' : ''}${remainingSeconds}`);

            if (seconds <= 0) {
                clearInterval(timerInterval);
                timerDisplay.text('OTP Expired. Resend now.');
                $('#submitAccountManage').prop('disabled', true);
            }
            seconds--;
        }

        updateTimer();
        timerInterval = setInterval(updateTimer, 1000);
    }

    // **تابع مدیریت ثبت نام اولیه**
    function handle_form_submission(e) {
        e.preventDefault();
        const base64image = $('#imageprev').attr('src');
        const email = $('#email').val();
        const password = $('#password').val();

        // اطمینان از وجود عکس
        if (!base64image) {
            swal({title: 'Photo Error', text: 'Please take a photo first.', icon: 'warning'});
            return;
        }

        const payload = new FormData();
        payload.append('email', email);
        payload.append('password', password);
        payload.append('domain', domain);
        const fileData = get_file_from_base64(base64image, `${email}.jpg`);
        payload.append('avatar', fileData);

        swal({
            title: "Sending Verification Email...",
            text: "Please wait while we send your verification email.",
            icon: "info",
            buttons: false,
            closeOnClickOutside: false
        });

        fetch("https://api.newwaypmsco.com/api/user/register/", {
            method: 'POST',
            body: payload
        })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(data => {
                        // مدیریت خطاها
                        const errorText = data.avatar ? data.avatar[0] :
                            data.email ? data.email[0] :
                                data.domain ? data.domain[0] :
                                    data.error ? data.error :
                                        'Something went wrong during registration.';
                        swal({title: 'Error', text: errorText, icon: 'error'});
                        throw new Error('Registration failed');
                    });
                }
                return response.json();
            })
            .then(data => {
                swal.close();
                swal({
                    title: 'Success',
                    text: 'Registration successful! Please verify your email to complete the process.',
                    icon: 'success',
                    timer: 2000
                }).then(() => {
                    $('#photoModal').modal('hide');
                });
            })
            .catch(error => {
                swal.close();
                console.error("Fetch error:", error);
            });
    }

    // **تابع مدیریت ثبت نام بعد از حذف حساب (برای جلوگیری از تکرار کد)**
    function handle_register_after_delete(e) {
        e.preventDefault();
        const newEmail = $('#newEmail').val();
        const newPassword = $('#newPassword').val();
        const base64image = $('#imageprev_register').attr('src'); // استفاده از آیدی جدید

        if (!base64image) {
            swal({title: 'Photo Error', text: 'Please take a photo first.', icon: 'warning'});
            return;
        }

        const file = get_file_from_base64(base64image, `${newEmail}.jpg`);
        const payload = new FormData();
        payload.append('email', newEmail);
        payload.append('password', newPassword);
        payload.append('avatar', file);
        payload.append('domain', domain);

        fetch("https://api.newwaypmsco.com/api/user/register/", {
            method: 'POST',
            body: payload
        })
            .then(response => {
                if (!response.ok) {
                    return response.json().then(data => {
                        throw new Error(data.email || data.avatar || data.domain || "Registration failed");
                    });
                }
                return response.json();
            })
            .then(data => {
                swal("Success", "Registration successful! Please verify your email to complete the process.", "success").then(() => {
                    $('#photoModal').modal('hide');
                    $('#manage-account-form').empty().addClass('d-none'); // پاکسازی فرم مدیریت
                });
            })
            .catch(error => {
                swal("Error", error.message, "error");
            });
    }

    // **تابع مدیریت حساب کاربری (فاز اول: درخواست OTP)**
    function manage_account(e) {
        e.preventDefault();
        const email = $('#manageEmail').val();
        const action = $('#manageAction').val();
        const newPassword = $('#newPassword').val();
        const otpCode = $('#otpCode').val();
        const base64image = $('#imageprev_manage').attr('src');

        if (!action) {
            swal({title: 'Action Required', text: 'Please select an action.', icon: 'warning'});
            return;
        }

        const payload = new FormData();
        payload.append('email', email);
        payload.append('action', action);
        if (newPassword && action === 'change_password') payload.append('new_password', newPassword);

        // اگر فاز OTP شروع نشده، درخواست OTP رو ارسال کن
        if (!otpRequested) {
            swal({
                title: "Sending OTP...",
                text: "Please wait while we send your one-time password.",
                icon: "info",
                buttons: false,
                closeOnClickOutside: false
            });
            fetch("https://api.newwaypmsco.com/api/user/account-management/", {
                method: 'POST',
                body: payload
            })
                .then(response => response.json())
                .then(data => {
                    swal.close();
                    if (data.message) {
                        $('#otp-section').removeClass('d-none');
                        $('#submitAccountManage').text('Confirm Action').prop('disabled', true);
                        otpRequested = true;
                        startTimer(data.expiry_seconds);
                        swal("Check Your Email", data.message, "success");
                    } else {
                        swal("Error", data.error, "error");
                    }
                })
                .catch(error => {
                    swal.close();
                    swal("Error", "Failed to send OTP.", "error");
                });
        }
        // اگر فاز OTP شروع شده، اقدام رو تایید کن
        else {
            if (otpCode.length !== 6) {
                swal({title: 'OTP Required', text: 'Please enter a 6-digit OTP.', icon: 'warning'});
                return;
            }

            // آماده سازی Payload برای تایید اقدام
            const confirmPayload = new FormData();
            confirmPayload.append('email', email);
            confirmPayload.append('action', action);
            confirmPayload.append('otp_code', otpCode);
            if (newPassword && action === 'change_password') confirmPayload.append('new_password', newPassword);

            // مدیریت فایل‌های عکس
            if (action === 'change_photo' && base64image) {
                const file = get_file_from_base64(base64image, `${email}.jpg`);
                confirmPayload.append('avatar', file); // در فاز اول change_photo، عکس جدید ارسال میشه
            } else if ((action === 'change_password' || action === 'delete_account') && base64image) {
                const file = get_file_from_base64(base64image, `${email}.jpg`);
                confirmPayload.append('avatar', file); // برای احراز هویت
            } else if (action === 'change_photo' && !base64image) {
                swal({title: 'Photo Required', text: 'Please capture a photo for the new profile or for verification.', icon: 'warning'});
                return;
            }

            swal({
                title: "Confirming Action...",
                text: "Please wait.",
                icon: "info",
                buttons: false,
                closeOnClickOutside: false
            });

            fetch("https://api.newwaypmsco.com/api/user/confirm-action/", {
                method: 'POST',
                body: confirmPayload
            })
                .then(response => {
                    if (!response.ok) {
                        return response.json().then(data => {
                            throw new Error(data.error || "Confirmation failed");
                        });
                    }
                    return response.json();
                })
                .then(data => {
                    swal.close();
                    if (data.message) {
                        handle_successful_confirmation(action, data.message);
                    } else {
                        // خطا در سرور ولی با استاتوس 200 (مثلاً انقضای OTP)
                        if (data.error && data.error.includes("OTP has expired")) {
                            handle_otp_expired(email, action, newPassword);
                        } else {
                            swal("Error", data.error || "An unknown error occurred.", "error");
                        }
                    }
                })
                .catch(error => {
                    swal.close();
                    swal("Error", error.message, "error");
                });
        }
    }

    // **تابع مدیریت تایید موفقیت آمیز اقدام**
    function handle_successful_confirmation(action, message) {
        if (action === 'delete_account') {
            swal({
                title: "Account Deleted",
                text: "Your account has been deleted. Register a new one?",
                icon: "success",
                buttons: { cancel: "Close", register: { text: "Register Now", value: "register" } }
            }).then((value) => {
                if (value === "register") {
                    // نمایش مجدد فرم ثبت نام اصلی با المنت‌های داینامیک
                    $('#manage-account-form').html(create_register_form()).removeClass('d-none');
                    Webcam.attach('#my_camera_register');
                } else {
                    $('#photoModal').modal('hide');
                }
            });
        } else {
            swal("Success", message, "success").then(() => {
                $('#photoModal').modal('hide');
                reset_manage_account_state();
            });
        }
    }

    // **تابع مدیریت انقضای OTP**
    function handle_otp_expired(email, action, newPassword) {
        swal({
            title: "OTP Expired",
            text: "Your OTP has expired. Request a new one?",
            icon: "warning",
            buttons: { cancel: "Close", resend: { text: "Resend OTP", value: "resend" } }
        }).then((value) => {
            if (value === "resend") {
                const resendPayload = new FormData();
                resendPayload.append('email', email);
                resendPayload.append('action', action);
                if (newPassword) resendPayload.append('new_password', newPassword);

                swal({
                    title: "Sending OTP...",
                    text: "Please wait while we send a new OTP.",
                    icon: "info",
                    buttons: false,
                    closeOnClickOutside: false
                });
                fetch("https://api.newwaypmsco.com/api/user/account-management/", {
                    method: 'POST',
                    body: resendPayload
                })
                    .then(response => response.json())
                    .then(data => {
                        swal.close();
                        if (data.message) {
                            startTimer(data.expiry_seconds);
                            swal("Check Your Email", data.message, "success").then(() => {
                                $('#otpCode').val('');
                                $('#submitAccountManage').prop('disabled', true);
                            });
                        } else {
                            swal("Error", data.error, "error");
                        }
                    });
            } else {
                reset_manage_account_state();
            }
        });
    }

    // **تابع ریست وضعیت مدیریت حساب**
    function reset_manage_account_state() {
        otpRequested = false;
        clearInterval(timerInterval);
        $('#otp-section').addClass('d-none');
        $('#submitAccountManage').text('Submit').prop('disabled', false);
        $('#manageAction').val('');
        $('#newPassword').addClass('d-none').val('');
        Webcam.reset();
        $('#managePhotoSection, #my_camera_manage, #takephoto_manage, #managePhotoResults, #retakePhoto_manage').addClass('d-none');
    }

    // **تابع ایجاد فرم ثبت نام بعد از حذف حساب**
    function create_register_form() {
        return `
            <form id="registerForm">
                <input type="email" id="newEmail" name="email" placeholder="New Email" required class="form-control mb-2">
                <input type="password" id="newPassword" name="password" placeholder="New Password" required class="form-control mb-2">
                <div id="my_camera_register" class="d-block mx-auto rounded overflow-hidden mb-2" style="width: 320px; height: 240px;"></div>
                <button type="button" id="takePhoto" class="btn btn-warning w-100 mb-2">Take Photo</button>
                <div id="results_register" class="mb-2"></div>
                <button type="button" id="retakePhoto" class="btn btn-warning w-100 mb-2 d-none">Retake</button>
                <input type="hidden" id="photoStore_register" name="photoStore" value="">
                <button type="submit" id="submitRegister" class="btn btn-warning w-100" disabled>Register</button>
            </form>
        `;
    }

})(jQuery);