<?php
/*
Plugin Name: ExtraShield
Plugin URI: http://www.extrashield.com
Description: Adds an ExtraShield of protection and security to your WordPress by using your mobile phone to generate a one-time password for login.
Version: 0.8
Author: Amr M. ElHalawany
Author URI: http://www.extrashield.com
License: GPL2
*/


## Hooks, Actions and Filters
register_activation_hook (__FILE__, 'extrashield_register_plugin');

add_action('admin_menu', 'extrashield_create_menu');
add_action('show_user_profile', 'show_extrashield_id_profile_field' );
add_action('edit_user_profile', 'show_extrashield_id_profile_field' );
add_action('personal_options_update', 'update_extrashield_id_profile_fields' );
add_action('edit_user_profile_update', 'update_extrashield_id_profile_fields' );
add_action('user_profile_update_errors', 'update_extrashield_id_profile_fields_errors',10,3 );
add_action('login_form', 'seccode_login_form');
add_filter('authenticate','check_sec_code',100,3);
add_action('wp_ajax_nopriv_get_ex_login_mode', 'get_ex_login_mode');
add_action('wp_ajax_get_ex_system_ip', 'get_ex_system_ip');
add_action('login_head', 'ex_c_login_head');

## Some Globals
$ex_plugin_name="extrashield";
$ex_plugin_images_path=WP_PLUGIN_URL.'/'.$ex_plugin_name;
$ex_c_errors="";

## Login Modes Array
$ex_login_modes=array("1"=>"<b>Password</b> <u>AND</u> <b>Mobile Security Code</b>.",
                      "2"=>"<b>Password</b> <u>OR</u> <b>Mobile Security Code</b>.",
                      "3"=>"<b>Mobile Security Code</b> only.");

function extrashield_validate($ExtraShieldID, $SecurityCode){
   ## Main Validation Function
   require_once (dirname(__FILE__).'/ExtraShieldAPI.php');
   $Validate = new ExtraShieldAPI;
   $Validate->set_Licence(get_option('extrashield_license_id'),get_option('extrashield_license_code'));
   $ValidationResults = $Validate->Check($ExtraShieldID,$SecurityCode);
   if ($ValidationResults === "VALID"){return $ValidationResults;
   }else{//Validation Failed
       $ErrorsArray=array("Error_Type"=>$Validate->get_Error_Type(),
                          "Error_Code"=>$Validate->get_Error_Code(),
                          "Error_Message"=>$Validate->get_Error_Message());
       return $ErrorsArray;
   }
}

function extrashield_get_localIP(){
       require("ExtraShieldAPI.php");
       $Validate = new ExtraShieldAPI;
       $SystemIP = $Validate->get_LocalIP();
       return $SystemIP;
}

function extrashield_register_plugin(){
       ## Register Settings
       extrashield_settings();
       ## This will run on initial activation of the plugin.
       if (!get_option('extrashield_license_id') && !get_option('extrashield_license_code')){
           ## Generate a Unique **anonymouse** Token for plugin registration.
           $RegToken=md5($_SERVER['SERVER_ADDR'].md5(rand(10000000, 99999999)));
           require("ExtraShieldAPI.php");
           $Register = new ExtraShieldAPI;
           $LicenseArray = $Register->register_plugin($RegToken);
           if (is_array($LicenseArray) && $LicenseArray['License_ID'] && $LicenseArray['License_CODE']){
               update_option('extrashield_license_id', $LicenseArray['License_ID']);
               update_option('extrashield_license_code', $LicenseArray['License_CODE']);
           }
       }
}

function seccode_login_form(){?>

   <script type="text/javascript" >
   /* <![CDATA[ */
   jQuery(document).ready(function($){
      var current_user="";
      var f = $("#loginform");
      f.html( f.html().replace(/<label><?php _e('Username') ?>/i,"<label id='username_box' ><?php _e('Username') ?>") );
      f.html( f.html().replace(/<label><?php _e('Password') ?>/i,"<label id='password_box' ><span id='password_label'><?php _e('Password') ?></span>") );
      $('#place-holder').after("<p style='font-size:14px;width:97%;padding:3px;margin-top:2px;margin-right:6px;margin-bottom:16px;border:1px solid #e5e5e5;background:#fbfbfb;' id='ex_please_wait' >Please Wait ...</p>");
      $('#ex_please_wait').hide();
      $('#security_code_block').hide();

      $('#user_login').blur(function() {
       if (($('#user_login').val()) && ( $('#user_login').val() != current_user)){
         current_user = $('#user_login').val();
         $('#password_box').hide();
         $('#password_label').text("<?php _e('Password') ?>");
         $('#security_code_block').hide();
         $('#ex_please_wait').show();
         var data = {
		action: 'get_ex_login_mode',
		ex_user_name: $('#user_login').val()
         };
         jQuery.post("<?php echo admin_url('admin-ajax.php');?>", data, function(response) {
              response=response.replace(/^\s+|\s+$/g, '');
              $('#ex_please_wait').hide();
              if (response == '1'){
                  $('#password_box').show();
                  $('#security_code_block').show();
              }else if (response == '2'){
                  $('#password_label').text("Password [Or] Security Code");
                  $('#password_box').show();
              }else if (response == '3'){
                  $('#security_code_block').show();
                  $('#user_email').focus();
              }else{
                  $('#password_box').show();
              }
              $('#user_pass').focus();
	});
       }
      });
   });
   /* ]]> */
   </script>

<?php
   echo "<p id='place-holder'></p><p style='display: none;' id='security_code_block' ><label>Security Code<br /><input type='text' name='SecCode' id='user_email' class='input' value='' size='20' tabindex='30' /></label></p>";
}

function check_sec_code($user, $username, $password){
   $myuserobject = new WP_User($username);
   ## Main function, where all the checking is done
   ## First, we need to check if the supplied username has added a valid ExtraShield ID to their profile.
   if (!empty($myuserobject->extrashield_id)){//a valid ExtraShield ID has been found in the user's profile
       ## Checking User Login Mode
       switch ($myuserobject->ex_login_mode){
               case "1"://UserName, Password and Security Code will be checked
                    if (wp_check_password($password, $myuserobject->user_pass, $myuserobject->ID)){
                        $ValidationResults=extrashield_validate($myuserobject->extrashield_id,$_POST['SecCode']);
                        if ($ValidationResults === "VALID"){return $myuserobject;}
                        else{return new WP_Error('authentication_failed', __("<strong> Error [ ".$ValidationResults['Error_Type']."".$ValidationResults['Error_Code']." ]</strong> : ".$ValidationResults['Error_Message']));}
                    }else{return null;}//Invalid username or password.
                    break;

               case "2"://UserName AND either the Password OR Security Code must be valid
                    ##First Check if the password matches
                    if (wp_check_password($password, $myuserobject->user_pass, $myuserobject->ID)){return $myuserobject;}
                    else { $ValidationResults=extrashield_validate($myuserobject->extrashield_id,$password);
                           if ($ValidationResults === "VALID"){return $myuserobject;}
                           else{return new WP_Error('authentication_failed', __("<strong>Invalid Password/Security Code. <br>Error [ ".$ValidationResults['Error_Type']."".$ValidationResults['Error_Code']." ]</strong> : ".$ValidationResults['Error_Message']));}
                    }
                    break;

               case "3"://UserName AND Security Code only.
                    $ValidationResults=extrashield_validate($myuserobject->extrashield_id,$_POST['SecCode']);
                    if ($ValidationResults === "VALID"){return $myuserobject;}
                    else{return new WP_Error('authentication_failed', __("<strong> Error [ ".$ValidationResults['Error_Type']."".$ValidationResults['Error_Code']." ]</strong> : ".$ValidationResults['Error_Message']));}
                    break;

               default:
                    return $user;
	            break;
       }
   }else{return $user;}//No ExtraShield ID found for that user.
}


function extrashield_create_menu() {
   add_menu_page('ExtraShield Plugin Settings', 'ExtraShield', 'administrator', __FILE__, 'extrashield_settings_page','');
   add_action( 'admin_init', 'extrashield_settings' );
}


function extrashield_settings() {
   register_setting( 'extrashield-settings-group', 'extrashield_system_ip' );
   register_setting( 'extrashield-settings-group', 'extrashield_license_id' );
   register_setting( 'extrashield-settings-group', 'extrashield_license_code' );
}

function extrashield_settings_page(){
   global $ex_login_modes;
   $SystemIP = get_option('extrashield_system_ip');
   $LicenseID = get_option('extrashield_license_id');
   $LicenseCode = get_option('extrashield_license_code');

?>
   <div class="wrap">
   <div id="icon-options-general" class="icon32"><br /></div>
   <h2>Settings</h2>

<?php

   if (empty($LicenseID) || empty($LicenseCode)){
       if (empty($SystemIP)){$SystemIP = extrashield_get_localIP();}


?>
   <script type="text/javascript" >
   /* <![CDATA[ */
   jQuery(document).ready(function($){
      $('#re-check').click(function() {
         $('#ex_system_ip').val('Please Wait .. ');
         var data = {
		action: 'get_ex_system_ip'
         };
         jQuery.post(ajaxurl, data, function(response) {
              var ex_ip = response.replace(/^\s+|\s+$/g, '');
              $('#ex_system_ip').val(ex_ip);
	 });
      });
   });
   /* ]]> */
   </script>


   <form method="post" action="options.php">
   <?php settings_fields('extrashield-settings-group'); ?>
   <table class="form-table">


        <tr valign="top">
        <td colspan="2"><b>Congratulations !</b><br>
            <b>ExtraShield WordPress Plugin</b> has been installed and after a few simple steps, you'll be ready to go !<br>
            To register the plugin and obtain a <b>License ID</b> and a <b>License Code</b>, please complete the registration form at :<br>
            <a href="http://www.extrashield.com/register.php" target="_blank">http://www.extrashield.com/register.php</a>

            </td>
        </tr>
        <tr valign="top">
        <th scope="row">System IP</th>
        <td><b><input type="text" id="ex_system_ip" name="extrashield_system_ip" value="<?php echo $SystemIP; ?>" readonly />&nbsp;&nbsp;<a id='re-check' class="button" >Check Again</a></td>
        </tr>
        <tr valign="top">
        <th scope="row">License ID</th>
        <td><input type="text" name="extrashield_license_id" value="<?php echo $LicenseID; ?>" /></td>
        </tr>
        <tr valign="top">
        <th scope="row">License Code</th>
        <td><input type="text" size="40" name="extrashield_license_code" value="<?php echo $LicenseCode; ?>" /></td>
        </tr>
    </table>
    <p class="submit">
    <input type="submit" class="button-primary" value="<?php _e('Save Changes') ?>" />
    </p>
    </form>

<?php

   }else{
?>

   <table class="form-table">
        <td colspan="2"><b>Congratulations !</b><br>
            <b>ExtraShield WordPress Plugin</b> has been installed and registered .. you are ready to go !
            <br> If you ever needed to <a href="mailto:support@extrashield.com">contact support</a>, please mention your <b>"System License ID"</b> : <b>[<?php echo $LicenseID; ?>].</b>

            <br><br>Don't forget that you need to <a href="http://www.extrashield.com/" target="_blank" >install</a> the <b><u>FREE</u> "ExtraShield Mobile Application"</b> on your mobile phone !
        </td>
        </tr>
    </table>



<?php

   }


?>
    <br>
    <table class="widefat" id="install-plugins" cellspacing="0" width="200">
		<thead>
			<tr>
				<th colspan="3" class="name">Users Currently using the plugin</th>
			</tr>
			<tr>
				<th scope="col" class="name">Name</th>
				<th scope="col" class="name">ExtraShield Mobile ID</th>
				<th scope="col" class="name">WordPress Login Mode</th>
			</tr>
		</thead>
		<tbody class="plugins">
<?php
    $CurrentProtectedUsers = get_all_extrashield_ids();
    if (!empty($CurrentProtectedUsers)){
        foreach ($CurrentProtectedUsers as $PUser) {
                 echo  "<tr><td class='name'><a href='user-edit.php?user_id=".$PUser['ID']."#ex_id_box'>".$PUser['Name']."</a></td><td>".$PUser['ExtraShieldID']."</td><td>".$ex_login_modes[$PUser['LoginMode']]."</td></tr>";
        }
    }else{
        ?>
            <tr><td colspan="3" class='vers'>
                 <br>No users have added a valid an <b>ExtraShield Mobile ID</b> to their profile, why don't you be the first!
                 <br>Click <a href="profile.php#ex_id_box">here</a> to add an <b>ExtraShield Mobile ID</b> to your profile.
                 <br>&nbsp;
            </td></tr>
        <?php
    }

?>
                </tbody>
    </table>




    </div>
<?php }

function get_all_extrashield_ids(){
    global $wpdb;
    $ExUserArray=array();
    $user_ids = $wpdb->get_col("SELECT ID FROM $wpdb->users ORDER BY 'ID'"); // query users
    foreach($user_ids as $user_id){
           $user = get_userdata($user_id);
           if (!empty($user->extrashield_id)){
                $ExUserArray[]=array("ID"=>$user->ID,
                                     "Name"=>$user->user_nicename,
                                     "ExtraShieldID"=>$user->extrashield_id,
                                     "LoginMode"=>$user->ex_login_mode
                                     );
           }
    }
    return $ExUserArray;
}

function extrashield_show_hide_help($ID,$Option){
    $clmode=get_the_author_meta("ex_login_mode",$ID);
    if (empty($clmode) && $Option == '1'){return "";}
    if (!is_numeric($clmode) || $clmode != $Option){
        return "display:none;";
    }
}


function show_extrashield_id_profile_field( $user ) {
   global $ex_login_modes;
   global $ex_plugin_images_path;
?>

   <script type="text/javascript" >
   /* <![CDATA[ */
   function showSecCode(){
      if(document.getElementById('extrashield_id').value){
         document.getElementById('tmpseccode').style.display='';
      }else{
         document.getElementById('tmpseccode').style.display='none';
      }
   }

   function showExHelp(){
      if(document.getElementById('ex_help_profile').style.display == 'none'){
         document.getElementById('ex_help_profile').style.display='';
      }else{
         document.getElementById('ex_help_profile').style.display='none';
      }
   }

   function showExModesHelp(what){
        document.getElementById('ex_mode_1').style.display = 'none';
        document.getElementById('ex_mode_2').style.display = 'none';
        document.getElementById('ex_mode_3').style.display = 'none';
        document.getElementById('ex_mode_'+what).style.display = '';
   }

   /* ]]> */
   </script>
       <br><br>
    <table class="widefat" id="install-plugins" cellspacing="0" width="200">
		<thead>
			<tr>
				<a name="ex_id_box"><th colspan="3" class="name">ExtraShield Settings &nbsp;&nbsp;&nbsp;&nbsp; <span class="button" onClick="showExHelp();">What is this ? </span></th></a>
			</tr>
		</thead>
		<tbody class="plugins">

        <tr><td  class='desc'>

        <table class="form-table">
		<tr id="ex_help_profile" style="display:none;">
                  <th><label for="extrashield_id">What is ExtraShield ?</label></th>
                   <td>
                      In a nutshell, ExtraShield is a <b>FREE</b> mobile application, which generates a <u><i>unique 6 digit number</i></u> called the "<b>Security Code</b>".
                      Every 50 seconds a new "<b>Security Code</b>" is generated, this code will be used to log in to your wordpress account according to your "<b>WordPress Login Mode</b>" set below.
                      <br><br>

                      <b>How to get started ?</b>
                      <br>Using your <u>mobile phone</u>, go to <b>http://wap.extrashield.com</b> and download the <b>ExtraShield</b> application to your mobile phone, run the application and follow the on-screen instructions:
                      <br><br>
                      <div style="text-align:center;margin:2px 2px 2px 2px;padding:20px 20px 20px 20px;font-weight:normal;-moz-border-radius:11px;-khtml-border-radius:11px;-webkit-border-radius:11px;border-radius:5px;background:#fff;border:1px solid #e5e5e5;background:#fbfbfb;-moz-box-shadow:rgba(200,200,200,1) 0 4px 18px;-webkit-box-shadow:rgba(200,200,200,1) 0 4px 18px;-khtml-box-shadow:rgba(200,200,200,1) 0 4px 18px;box-shadow:rgba(200,200,200,1) 0 4px 18px;">
                       	<img src="<?php echo $ex_plugin_images_path.'/screen_1.png'; ?>" border="0" >&nbsp;&nbsp;&nbsp;&nbsp;
                        <img src="<?php echo $ex_plugin_images_path.'/screen_2.png'; ?>" border="0" >&nbsp;&nbsp;&nbsp;&nbsp;
                        <img src="<?php echo $ex_plugin_images_path.'/screen_3.png'; ?>" border="0" >&nbsp;&nbsp;&nbsp;&nbsp;
                      </div>
                      <br>
                      Choose <b>New Customer</b>, Then choose a 4 digits <b>PIN</b> code, which will be used to open the application on your mobile.
                      After entering a new <b>PIN</b> code, the application will communicate with the server and registers a new <b>ExtraShield Mobile ID</b> for you, as shown above.
                      <br><br>
                      When done, add your <b>ExtraShield Mobile ID</b> to your WordPress profile below and choose your desired <b>WordPress Login Mode</b>.
                      That's it .. enjoy :)

                      <br><br>
                      <div id="ex_notes">
                         Please Note :
                         <UL>
                         <li><small>Remember to keep your <b>PIN</b> code secret and never share it with any one. It's only used to open the mobile application.</small></li>
                         <li><small><b>ExtraShield Mobile Application</b> will only require internet connectivity during the registration process, you don't need to be connected every time you need to use the application for generating new Security Codes.</small></li>
                         </UL>
                      </div>
                   </td>

                </tr>
		<tr>
                  <th><label for="extrashield_id">ExtraShield Mobile ID</label></th>
                   <td>
                      <input type="text" name="extrashield_id" id="extrashield_id" value="<?php echo esc_attr( get_the_author_meta( 'extrashield_id', $user->ID ) ); ?>" class="input" size="16" maxlength="12" onKeyUp="showSecCode();" onBlur="showSecCode();" />
		      <span class="description">Please enter your ExtraShield ID as shown on your <b>mobile phone</b> (i.e., XTSH12345678).</span>
		   </td>

                </tr>
                <tr id="tmpseccode" style="display:none;background-color: #DFDFDF;">
		  <th><label for="extrashield_temp_sec_code">Current Mobile Security Code</label></th>
		   <td>
		      <input type="text" name="tmp_sec_code" id="tmp_sec_code" value="" class="input" size="10" maxlength="6" />
		      <span class="description">To add, edit or update your ExtraShield ID, you need to enter your current 6 digits security code as shown on your <b>mobile phone</b>.</span>
		   </td>
		</tr>
                <tr>
                 <th scope="row">WordPress Login Mode</th>
                   <td>
                    <fieldset><legend class="screen-reader-text"><span>Date Format</span></legend>
                    <label title="ex_login_mode_1"><input type="radio" name="ex_login_mode" value="1" onClick="showExModesHelp('1');" <?php checked("", get_the_author_meta("ex_login_mode",$user->ID)); checked("1", get_the_author_meta("ex_login_mode",$user->ID)); ?> /> Login using my <?php echo $ex_login_modes['1'];?> [Recommended]</label><br />
                    <div id="ex_mode_1" style="<?php echo extrashield_show_hide_help($user->ID,'1');?>margin:10px 10px 10px 20px;padding:10px 10px 10px 10px;border:1px solid #e5e5e5;background:#fbfbfb;" >
                      	<img src="<?php echo $ex_plugin_images_path.'/login_mode_1.png'; ?>" style=" padding: 5px; position:relative;float:right;margin: 0 15px 15px 0;" border="0" >
                        In this mode, you need to enter your <b>UserName</b>, <b>Password</b> and the <b>Mobile Security Code</b> generated on your mobile phone to access your WordPress account.
                          <br><br>This means, for anyone else to access your account, he/she needs to know your WordPress account UserName, Password <b>and</b> be able to access the ExtraShield Application installed on <b>YOUR</b> mobile phone to get a valid Mobile Security Code .. Pretty hard, right !
                    </div>
                    <label title="ex_login_mode_2"><input type="radio" name="ex_login_mode" value="2" onClick="showExModesHelp('2');" <?php checked("2", get_the_author_meta("ex_login_mode",$user->ID)); ?> /> Login using my <?php echo $ex_login_modes['2'];?></label><br />
                    <div id="ex_mode_2" style="<?php echo extrashield_show_hide_help($user->ID,'2');?>margin:10px 10px 10px 20px;padding:10px 10px 10px 10px;border:1px solid #e5e5e5;background:#fbfbfb;">
                      	<img src="<?php echo $ex_plugin_images_path.'/login_mode_2.png'; ?>" style=" padding: 5px; position:relative;float:right;margin: 0 15px 15px 0;" border="0" >
                        In this mode, you need to enter your <b>UserName</b> and <u>either</u> your <b>Password</b> <u>or</u> <b>Mobile Security Code</b> generated on your mobile phone to access your WordPress account.
                         <br><br>This mode is useful if you occasionally need to access your WordPress account from insecure/public places. For example, at an internet cafe you may access your account using the Mobile Security Code instead of your password, thus eliminating the risk of your password being hijacked by Trojans or Viruses,
                         and when you are back at home or a secure environment, you may use your normal password again .. It's all about choices !
                    </div>
                    <label title="ex_login_mode_3"><input type="radio" name="ex_login_mode" value="3" onClick="showExModesHelp('3');" <?php checked("3", get_the_author_meta("ex_login_mode",$user->ID)); ?>/> Login using <?php echo $ex_login_modes['3'];?></label><br />
                    <div id="ex_mode_3" style="<?php echo extrashield_show_hide_help($user->ID,'3');?>margin:10px 10px 10px 20px;padding:10px 10px 10px 10px;border:1px solid #e5e5e5;background:#fbfbfb;">
                      <img src="<?php echo $ex_plugin_images_path.'/login_mode_3.png'; ?>" style=" padding: 5px; position:relative;float:right;margin: 0 15px 15px 0;" border="0" >
                      In this mode, you only need to enter your <b>UserName</b> and the <b>Mobile Security Code</b> generated on your mobile phone to access your WordPress account.
                         <br><br>If you don't want to remember a password, this mode is for you !
                    </div>
                    </fieldset>
                   </td>
                </tr>
        </table>

        </td></tr>
                </tbody>
    </table>


<?php }

function update_extrashield_id_profile_fields($user_id){
    global $ex_c_errors;
    $CurrentExtraShieldID = esc_attr(get_the_author_meta('extrashield_id',$user_id));
    if (!current_user_can( 'edit_user', $user_id )){return false;}
    else{
         update_usermeta( $user_id, 'ex_login_mode', $_POST['ex_login_mode'] );
         if(strtolower($_POST['extrashield_id']) === strtolower($CurrentExtraShieldID)){return false;}
         elseif(empty($_POST['extrashield_id'])){update_usermeta( $user_id, 'extrashield_id', "" );}
         else{ $ValidationResults=extrashield_validate($_POST['extrashield_id'],$_POST['tmp_sec_code']);
               if ($ValidationResults === "VALID"){update_usermeta( $user_id, 'extrashield_id', strtoupper($_POST['extrashield_id']) );}
               else {$ex_c_errors = new WP_Error;
                     $ex_c_errors->add('extrashield_errors', __("<strong>ExtraShield Error [ ".$ValidationResults['Error_Type']."".$ValidationResults['Error_Code']." ]</strong> : ".$ValidationResults['Error_Message']));
                     return false;
               }//Invalid/Missing Security Code
         }
    }
}

function update_extrashield_id_profile_fields_errors($errors, $update, $user){
    global $ex_c_errors;
    if ($ex_c_errors != ""){$errors=$ex_c_errors; return $errors; }
}


function get_ex_login_mode(){
    @header('Content-Type: text/html; charset=' . get_option('blog_charset'));
    $user_name = sanitize_user($_POST['ex_user_name']);
    global $wpdb;
    $sql = "SELECT * FROM " . $wpdb->users . " WHERE user_login='" . $user_name . "'";
    $user = $wpdb->get_row($wpdb->prepare($sql));
    $user_extrashield_id = get_usermeta($user->ID, 'extrashield_id');
    if (!empty($user_extrashield_id)){echo get_usermeta($user->ID, 'ex_login_mode');}
    else{ echo "";}
    die();
}

function get_ex_system_ip(){
    @header('Content-Type: text/html; charset=' . get_option('blog_charset'));
    echo extrashield_get_localIP();
    die();
}


function ex_c_login_head() {
   wp_enqueue_script('jquery');
   wp_print_scripts();
}
?>
